/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.gui.ExperimentRenderer;
import edu.udo.cs.yale.gui.MainFrame;
import edu.udo.cs.yale.gui.SwingTools;
import edu.udo.cs.yale.gui.Template;
import edu.udo.cs.yale.gui.WizardPropertyTable;
import edu.udo.cs.yale.tools.ParameterService;
import edu.udo.cs.yale.tools.Tools;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class WizardDialog
extends JDialog {
    private static Icon wizardIcon;
    private MainFrame mainFrame;
    private JButton delete = new JButton("Delete");
    private JButton next = new JButton("Next >");
    private JButton previous = new JButton("< Previous");
    private CardLayout cardLayout = new CardLayout();
    private JPanel mainPanel = new JPanel(this.cardLayout);
    private ExperimentRenderer experimentRenderer = new ExperimentRenderer();
    private WizardPropertyTable propertyTable = new WizardPropertyTable();
    private int currentStep = 0;
    private int numberOfSteps = 0;
    private Experiment[] experiments;
    private Template[] templates;
    private int selectedTemplateIndex;

    public WizardDialog(MainFrame mainFrame) {
        super(mainFrame, "Wizard", true);
        this.mainFrame = mainFrame;
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this.next);
        buttonPanel.add(this.previous);
        this.previous.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.step(-1);
            }
        });
        buttonPanel.add(this.next);
        this.next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.step(1);
            }
        });
        buttonPanel.add(Box.createHorizontalStrut(11));
        JButton cancel = new JButton("Cancel");
        buttonPanel.add(cancel);
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.cancel();
            }
        });
        this.getContentPane().add((Component)buttonPanel, "South");
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        this.addTitle();
        JPanel panel = this.createChooseTemplate();
        this.addStep(panel);
        this.addParameters();
        this.step(0);
        this.pack();
        this.setSize(800, 600);
        this.setLocationRelativeTo(mainFrame);
    }

    private void addTitle() {
        JPanel panel = SwingTools.createTextPanel("Welcome to the Yale Experiment Wizard", "This wizard will guide you setting up a new experiment.</p>");
        JPanel content = new JPanel(new FlowLayout(0));
        JLabel image = new JLabel(wizardIcon);
        image.setBorder(BorderFactory.createLoweredBevelBorder());
        content.add(image);
        JLabel label = new JLabel("<html>Using the wizard will involve the following steps:<ul><li>Choose a template experiment</li><li>Set some of the important parameters</li><li>Create an attribute description file if necessary</li></ul><p>Completing these steps you can immediately start the experiment or go on editing and make advanced settings.</p><p>Please check also the sample directory of Yale containing a huge number of additional experiments.</p></html>");
        label.setPreferredSize(new Dimension(300, 200));
        label.setFont(label.getFont().deriveFont(0));
        content.add(label);
        panel.add((Component)content, "Center");
        this.addStep(panel);
    }

    private JPanel createChooseTemplate() {
        File[] preDefinedTemplateFiles = ParameterService.getConfigFile("templates").listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".template");
            }
        });
        File[] userDefinedTemplateFiles = ParameterService.getUserYaleDir().listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".template");
            }
        });
        File[] templateFiles = new File[preDefinedTemplateFiles.length + userDefinedTemplateFiles.length];
        System.arraycopy(preDefinedTemplateFiles, 0, templateFiles, 0, preDefinedTemplateFiles.length);
        System.arraycopy(userDefinedTemplateFiles, 0, templateFiles, preDefinedTemplateFiles.length, userDefinedTemplateFiles.length);
        JPanel panel = SwingTools.createTextPanel("Select a template", "Please select one of the following template experiments listed below. The image on the right is a schematic figure of the experiment showing operators as blue boxes and chains and wrappers as brownish boxes containing their inner operators.");
        Box radioBox = new Box(1);
        ButtonGroup group = new ButtonGroup();
        this.templates = new Template[templateFiles.length];
        this.experiments = new Experiment[templateFiles.length];
        int i = 0;
        while (i < this.templates.length) {
            try {
                this.templates[i] = new Template(templateFiles[i]);
                this.experiments[i] = new Experiment(new File(templateFiles[i].getParent(), this.templates[i].getFilename()));
                this.experiments[i].setExperimentFile(null);
            }
            catch (Throwable e) {
                SwingTools.showErrorMessage("Cannot load template file '" + templateFiles[i] + "'", e);
                this.experiments[i] = new Experiment();
                this.templates[i] = new Template();
            }
            JRadioButton b = new JRadioButton("<html>" + this.templates[i].toHTML() + "</html>");
            b.setFont(b.getFont().deriveFont(0));
            if (i == 0) {
                b.setSelected(true);
            }
            final int j = i++;
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    WizardDialog.this.select(j);
                }
            });
            radioBox.add(b);
            group.add(b);
        }
        this.select(0);
        GridBagLayout layout = new GridBagLayout();
        JPanel centerPanel = new JPanel(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        layout.setConstraints(radioBox, c);
        centerPanel.add(radioBox);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(this.experimentRenderer, c);
        centerPanel.add(this.experimentRenderer);
        panel.add((Component)new JScrollPane(centerPanel), "Center");
        return panel;
    }

    private void addParameters() {
        JPanel panel = SwingTools.createTextPanel("Make Settings", "In the following, you find a list of the most important parameters of this experiment. Some of the parameters may have default values. The parameters set in bold face are mandatory. Pointing with the mouse on one of the parameters you will get some information about the meaning of the parameter.");
        panel.add((Component)new JScrollPane(this.propertyTable), "Center");
        JPanel buttons = new JPanel(new FlowLayout(1));
        panel.add((Component)buttons, "South");
        this.addStep(panel);
    }

    private void addStep(Component c) {
        this.mainPanel.add(c, this.numberOfSteps + "");
        ++this.numberOfSteps;
    }

    private void select(int index) {
        this.selectedTemplateIndex = index;
        Experiment experiment = this.experiments[index];
        Template template = this.templates[index];
        if (experiment != null && template != null) {
            this.experimentRenderer.setOperator(experiment.getRootOperator());
            this.propertyTable.setExperiment(experiment, template.getParameters());
        } else {
            this.experimentRenderer.setOperator(null);
            this.propertyTable.setExperiment(null, null);
        }
    }

    private void step(int dir) {
        this.currentStep += dir;
        if (this.currentStep == 1) {
            this.delete.setEnabled(true);
        } else {
            this.delete.setEnabled(false);
        }
        if (this.currentStep < 0) {
            this.currentStep = 0;
        }
        if (this.currentStep == 0) {
            this.previous.setEnabled(false);
        } else {
            this.previous.setEnabled(true);
        }
        if (this.currentStep >= this.numberOfSteps) {
            this.finish();
        }
        if (this.currentStep == this.numberOfSteps - 1) {
            this.next.setText("Finish");
        } else {
            this.next.setText("Next >");
        }
        this.cardLayout.show(this.mainPanel, this.currentStep + "");
    }

    private void finish() {
        this.mainFrame.setExperiment(this.experiments[this.selectedTemplateIndex]);
        this.dispose();
    }

    private void cancel() {
        this.dispose();
    }

    static {
        try {
            wizardIcon = new ImageIcon(ImageIO.read(Tools.getResource("wizard.jpg")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

