/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import javax.swing.JPanel;

public class SystemMonitor
extends JPanel {
    private static final Color MEMORY_COLOR = new Color(0, 200, 0);
    private static final Color TEXT_COLOR = new Color(0, 220, 0);
    private static final Color GRID_COLOR = Color.gray;
    private static final Color BACKGROUND = new Color(0, 60, 0);
    private static final String[] MEMORY_UNITS = new String[]{"b", "kB", "MB", "GB", "TB"};
    private static final int NUMBER_OF_MEASUREMENTS = 20;
    private static final int GRID_X = 10;
    private static final int GRID_Y = 10;
    private static final int MARGIN = 10;
    private long delay = 1000L;
    private long[] memory = new long[20];
    private int currentMeasurement = 0;

    public SystemMonitor() {
        this.setBackground(BACKGROUND);
        new Thread(){
            {
                this.setDaemon(true);
            }

            public void run() {
                this.setPriority(1);
                while (true) {
                    ((SystemMonitor)SystemMonitor.this).memory[((SystemMonitor)SystemMonitor.this).currentMeasurement] = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                    SystemMonitor.this.currentMeasurement = (SystemMonitor.this.currentMeasurement + 1) % SystemMonitor.this.memory.length;
                    SystemMonitor.this.repaint();
                    try {
                        1.sleep(SystemMonitor.this.delay);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }.start();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        GeneralPath path = new GeneralPath();
        Dimension d = this.getSize();
        int monitorWidth = (int)d.getWidth() - 20;
        int monitorHeight = (int)d.getHeight() - 20;
        long total = Runtime.getRuntime().totalMemory();
        path.moveTo(10.0f, 10 + monitorHeight);
        for (int i = 0; i < this.memory.length; ++i) {
            int index = (this.currentMeasurement + i) % this.memory.length;
            path.lineTo(10 + i * monitorWidth / (this.memory.length - 1), (long)(10 + monitorHeight) - (long)monitorHeight * this.memory[index] / total);
        }
        path.lineTo(10 + monitorWidth, 10 + monitorHeight);
        path.closePath();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(GRID_COLOR);
        for (int x = 0; x < 11; ++x) {
            g2d.drawLine(10 + x * monitorWidth / 10, 10, 10 + x * monitorWidth / 10, 10 + monitorHeight);
        }
        for (int y = 0; y < 11; ++y) {
            g2d.drawLine(10, 10 + y * monitorHeight / 10, 10 + monitorWidth, 10 + y * monitorHeight / 10);
        }
        g2d.setColor(MEMORY_COLOR);
        g2d.fill(path);
        g2d.setColor(Color.green);
        g2d.draw(path);
        g2d.setColor(TEXT_COLOR);
        Font font = new Font("Courier", 0, 12);
        g2d.setFont(font);
        g2d.drawString(" Total: " + this.humanReadable(total), 10, 10 + 3 * font.getSize() / 2);
        g2d.drawString(" Max:   " + this.humanReadable(Runtime.getRuntime().maxMemory()), 10, 10 + 5 * font.getSize() / 2);
    }

    private String humanReadable(long bytes) {
        long result;
        long rest = 0L;
        int unit = 0;
        for (result = bytes; result > 1024L; result /= 1024L) {
            rest = result % 1024L;
            if (++unit < MEMORY_UNITS.length - 1) continue;
        }
        if (result < 10L && unit > 0) {
            return result + "." + 10L * rest / 1024L + " " + MEMORY_UNITS[unit];
        }
        return result + " " + MEMORY_UNITS[unit];
    }
}

