/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.gui.ErrorDialog;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.io.File;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class SwingTools {
    public static final int TABLE_ROW_EXTRA_HEIGHT = 8;
    public static final Color DARK_YELLOW = new Color(180, 164, 148);
    public static final Color LIGHT_YELLOW = new Color(206, 184, 163);
    public static final Color DARK_BLUE = new Color(153, 153, 204);
    public static final Color LIGHT_BLUE = new Color(204, 204, 255);

    public static GradientPaint makeBluePaint(double width, double height) {
        return new GradientPaint(0.0f, 0.0f, DARK_BLUE, (float)width / 2.0f, (float)height / 2.0f, LIGHT_BLUE, true);
    }

    public static GradientPaint makeYellowPaint(double width, double height) {
        return new GradientPaint(0.0f, 0.0f, DARK_YELLOW, (float)width / 2.0f, (float)height / 2.0f, LIGHT_YELLOW, true);
    }

    public static void showVerySimpleErrorMessage(String message) {
        JOptionPane.showMessageDialog(YaleGUI.getMainFrame(), message, "Exception", 0);
    }

    public static void showSimpleErrorMessage(String message, Throwable e) {
        JOptionPane.showMessageDialog(YaleGUI.getMainFrame(), message + "\n" + Tools.classNameWOPackage(e.getClass()) + " caught:\n" + e.getMessage(), "Exception", 0);
    }

    public static void showErrorMessage(String message, Throwable e) {
        ErrorDialog dialog = ErrorDialog.create(message, e);
        dialog.setLocationRelativeTo(YaleGUI.getMainFrame());
        dialog.setVisible(true);
    }

    public static File chooseFile(Component parent, File file, boolean open) {
        return SwingTools.chooseFile(parent, file, open, false);
    }

    public static File chooseFile(Component parent, File file, boolean open, boolean onlyDirs) {
        return SwingTools.chooseFile(parent, file, open, onlyDirs, null);
    }

    public static File chooseFile(Component parent, File file, boolean open, boolean onlyDirs, FileFilter[] fileFilters) {
        if (parent == null) {
            parent = YaleGUI.getMainFrame();
        }
        JFileChooser fileChooser = SwingTools.createFileChooser(file, onlyDirs, fileFilters);
        int returnValue = open ? fileChooser.showOpenDialog(parent) : fileChooser.showSaveDialog(parent);
        switch (returnValue) {
            case 0: {
                return fileChooser.getSelectedFile();
            }
        }
        return null;
    }

    public static JFileChooser createFileChooser(File file, boolean onlyDirs, FileFilter[] fileFilters) {
        File directory = null;
        if (file != null) {
            directory = file.isDirectory() ? file : file.getAbsoluteFile().getParentFile();
        } else {
            File experimentFile = Yale.getExperiment() != null ? Yale.getExperiment().getExperimentFile() : null;
            directory = experimentFile != null ? experimentFile.getAbsoluteFile().getParentFile() : new File(System.getProperty("user.dir"));
        }
        JFileChooser fileChooser = new JFileChooser(directory);
        if (onlyDirs) {
            fileChooser.setFileSelectionMode(1);
        }
        if (fileFilters != null) {
            fileChooser.setAcceptAllFileFilterUsed(false);
            for (int i = 0; i < fileFilters.length; ++i) {
                fileChooser.addChoosableFileFilter(fileFilters[i]);
            }
        }
        if (file != null) {
            fileChooser.setSelectedFile(file);
        }
        return fileChooser;
    }

    public static JPanel createTextPanel(String title, String text) {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel("<html><h2>" + title + "</h2><p>" + text + "</p></html>");
        label.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        label.setFont(label.getFont().deriveFont(0));
        panel.add((Component)label, "North");
        return panel;
    }

    public static String html2YaleText(String html) {
        if (html == null) {
            return null;
        }
        String result = html.replaceAll("<", "#ylt#");
        result = result.replaceAll(">", "#ygt#");
        result = result.replaceAll("\"", "#yquot#");
        return result;
    }

    public static String text2DisplayHtml(String text) {
        String result = "<html><head><style type=text/css>body { font-family:sans-serif; font-size:12pt; }</style></head><body>" + text + "</body></html>";
        result = SwingTools.text2SimpleHtml(result);
        result = result.replaceAll("#yquot#", "&quot;");
        while (result.indexOf("<icon>") != -1) {
            int startIndex = result.indexOf("<icon>");
            int endIndex = result.indexOf("</icon>");
            String start = result.substring(0, startIndex);
            String end = result.substring(endIndex + 7);
            String icon = result.substring(startIndex + 6, endIndex).trim();
            URL url = Tools.getResource("icons/" + icon + ".gif");
            result = start + "<img src=\"" + url + "\">" + end;
        }
        return result;
    }

    public static String text2SimpleHtml(String text) {
        if (text == null) {
            return null;
        }
        String result = text.replaceAll("#ygt#", ">");
        result = result.replaceAll("#ylt#", "<");
        return result;
    }
}

