/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class SearchDialog
extends JDialog {
    private JTextField patternField = new JTextField(20);
    private JCheckBox caseSensitive = new JCheckBox("Case sensitive");
    private JCheckBox regExp = new JCheckBox("Regular expression");
    private JRadioButton up = new JRadioButton("Up");
    private JRadioButton down = new JRadioButton("Down");
    private JTextComponent textComponent;

    public SearchDialog(Component owner, JTextComponent textComponent) {
        this.textComponent = textComponent;
        this.setTitle("Find");
        this.setModal(false);
        this.getContentPane().setLayout(new BorderLayout());
        Box mainBox = new Box(1);
        mainBox.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 5));
        JPanel searchPanel = new JPanel();
        searchPanel.add(new JLabel("Find:"));
        searchPanel.add(this.patternField);
        mainBox.add(searchPanel);
        Box optionBox = new Box(0);
        JPanel directionPanel = new JPanel();
        directionPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(11, 0, 0, 11), BorderFactory.createTitledBorder("Direction")));
        ButtonGroup directionGroup = new ButtonGroup();
        this.up.setMnemonic(85);
        directionGroup.add(this.up);
        directionPanel.add(this.up);
        this.down.setMnemonic(68);
        directionGroup.add(this.down);
        this.down.setSelected(true);
        directionPanel.add(this.down);
        directionPanel.setAlignmentY(0.5f);
        optionBox.add(directionPanel);
        Box checkBoxBox = new Box(1);
        checkBoxBox.add(this.caseSensitive);
        checkBoxBox.add(this.regExp);
        checkBoxBox.setAlignmentY(0.5f);
        optionBox.add(checkBoxBox);
        mainBox.add(optionBox);
        this.getContentPane().add((Component)mainBox, "Center");
        Box buttonBox = new Box(1);
        buttonBox.setBorder(BorderFactory.createEmptyBorder(11, 6, 11, 11));
        JButton find = new JButton("Find");
        this.getRootPane().setDefaultButton(find);
        find.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.find();
            }
        });
        buttonBox.add(find);
        JButton cancel = new JButton("Close");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.dispose();
            }
        });
        buttonBox.add(cancel);
        this.getContentPane().add((Component)buttonBox, "East");
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    private void find() {
        String text;
        String pattern = this.patternField.getText().trim();
        if (pattern.length() == 0) {
            return;
        }
        int startPos = this.textComponent.getCaretPosition();
        if (startPos == (text = this.textComponent.getText()).length()) {
            startPos = 0;
        }
        if (this.down.isSelected()) {
            Result result = this.search(startPos, pattern, text);
            if (result == null) {
                this.noMoreHits();
                return;
            }
            this.textComponent.setCaretPosition(result.start);
            this.textComponent.moveCaretPosition(result.end);
        } else {
            Result result;
            Result lastResult = null;
            int pos = 0;
            while ((result = this.search(pos, pattern, text)) != null && result.end < startPos) {
                pos = result.start + 1;
                lastResult = result;
            }
            if (lastResult == null) {
                this.noMoreHits();
            } else {
                this.textComponent.setCaretPosition(lastResult.start);
                this.textComponent.moveCaretPosition(lastResult.end);
            }
        }
    }

    private Result search(int start, String pattern, String text) {
        int result;
        if (this.regExp.isSelected()) {
            Matcher matcher = Pattern.compile(pattern, this.caseSensitive.isSelected() ? 0 : 2).matcher(text.subSequence(start, text.length()));
            if (matcher.find()) {
                return new Result(start + matcher.start(), start + matcher.end());
            }
            return null;
        }
        if (!this.caseSensitive.isSelected()) {
            text = text.toLowerCase();
            pattern = pattern.toLowerCase();
        }
        if ((result = text.indexOf(pattern, start)) == -1) {
            return null;
        }
        return new Result(result, result + pattern.length());
    }

    private void noMoreHits() {
        String restartAt = this.up.isSelected() ? "end" : "beginning";
        switch (JOptionPane.showConfirmDialog(this, "Search string not found. Search from " + restartAt + "?", "String not found", 0)) {
            case 0: {
                this.textComponent.setCaretPosition(this.up.isSelected() ? this.textComponent.getText().length() - 1 : 0);
                this.find();
                break;
            }
            default: {
                return;
            }
        }
    }

    private class Result {
        private int start;
        private int end;

        private Result(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

