/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.gui.MainFrame;
import edu.udo.cs.yale.gui.SwingTools;
import edu.udo.cs.yale.gui.Template;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.tools.ParameterService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;

public class SaveAsTemplateDialog
extends JDialog {
    private boolean ok = false;
    private JTextField nameField = new JTextField();
    private JTextField descriptionField = new JTextField();
    private TemplateParameterTableModel tableModel = null;

    public SaveAsTemplateDialog(MainFrame mainFrame, Operator operator) {
        super(mainFrame, "Save as Template", true);
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagLayout layout = new GridBagLayout();
        JPanel mainPanel = new JPanel(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        JPanel textPanel = SwingTools.createTextPanel("Save this experiment as Template...", "Please specify a name and short description of this template. The selected parameters can be determined by the user in addition to the mandatory parameters.");
        c.gridwidth = 0;
        layout.setConstraints(textPanel, c);
        mainPanel.add(textPanel);
        Component sep = Box.createVerticalStrut(10);
        c.gridwidth = 0;
        layout.setConstraints(sep, c);
        mainPanel.add(sep);
        JLabel label = new JLabel("Name");
        label.setToolTipText("The name of the template.");
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        this.nameField.setToolTipText("The name of the template.");
        c.gridwidth = 0;
        layout.setConstraints(this.nameField, c);
        mainPanel.add(this.nameField);
        label = new JLabel("Description");
        label.setToolTipText("A short description of this template.");
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        this.descriptionField.setToolTipText("A short description of this template.");
        c.gridwidth = 0;
        layout.setConstraints(this.descriptionField, c);
        mainPanel.add(this.descriptionField);
        sep = Box.createVerticalStrut(10);
        c.gridwidth = 0;
        layout.setConstraints(sep, c);
        mainPanel.add(sep);
        this.tableModel = new TemplateParameterTableModel(this.getParameters(operator));
        JTable table = new JTable(this.tableModel);
        JScrollPane tablePane = new JScrollPane(table);
        table.setPreferredScrollableViewportSize(new Dimension(600, 200));
        table.getTableHeader().setToolTipText("Select the parameters which could be defined by the user.");
        table.setRowHeight(table.getRowHeight() + 8);
        table.getTableHeader().setReorderingAllowed(false);
        c.weighty = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(tablePane, c);
        mainPanel.add(tablePane);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SaveAsTemplateDialog.this.ok();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SaveAsTemplateDialog.this.cancel();
            }
        });
        buttonPanel.add(cancelButton);
        rootPanel.add((Component)mainPanel, "Center");
        rootPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add(rootPanel);
        this.pack();
        this.setSize(700, 500);
        this.setLocationRelativeTo(mainFrame);
    }

    private OperatorParameterPair[] getParameters(Operator operator) {
        LinkedList parameters = new LinkedList();
        this.addParameters(operator, parameters);
        Collections.sort(parameters);
        OperatorParameterPair[] result = new OperatorParameterPair[parameters.size()];
        parameters.toArray(result);
        return result;
    }

    private void addParameters(Operator operator, List parameters) {
        Iterator i = operator.getParameterTypes().iterator();
        while (i.hasNext()) {
            ParameterType type = (ParameterType)i.next();
            Object value = operator.getParameters().getParameter(type.getKey());
            if (!type.isOptional()) continue;
            parameters.add(new OperatorParameterPair(new String[]{operator.getName(), type.getKey()}));
        }
        if (operator instanceof OperatorChain) {
            OperatorChain chain = (OperatorChain)operator;
            for (int n = 0; n < chain.getNumberOfOperators(); ++n) {
                this.addParameters(chain.getOperator(n), parameters);
            }
        }
    }

    private void addMandatoryParameters(Operator operator, List parameters) {
        Iterator i = operator.getParameterTypes().iterator();
        while (i.hasNext()) {
            ParameterType type = (ParameterType)i.next();
            Object value = operator.getParameters().getParameter(type.getKey());
            if (type.isOptional()) continue;
            parameters.add(new String[]{operator.getName(), type.getKey()});
        }
        if (operator instanceof OperatorChain) {
            OperatorChain chain = (OperatorChain)operator;
            for (int n = 0; n < chain.getNumberOfOperators(); ++n) {
                this.addMandatoryParameters(chain.getOperator(n), parameters);
            }
        }
    }

    public boolean isOk() {
        return this.ok;
    }

    public Template getTemplate(Operator operator) {
        String name = this.nameField.getText();
        List selectedOptional = this.tableModel.getSelectedParameters();
        this.addMandatoryParameters(operator, selectedOptional);
        return new Template(name, this.descriptionField.getText(), name + ".xml", selectedOptional);
    }

    private boolean checkIfNameOk() {
        String name = this.nameField.getText();
        if (name == null || name.length() == 0) {
            SwingTools.showVerySimpleErrorMessage("Please specify a name for this template!");
            return false;
        }
        File[] preDefinedTemplateFiles = ParameterService.getConfigFile("templates").listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".template");
            }
        });
        File[] userDefinedTemplateFiles = ParameterService.getUserYaleDir().listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".template");
            }
        });
        File[] templateFiles = new File[preDefinedTemplateFiles.length + userDefinedTemplateFiles.length];
        System.arraycopy(preDefinedTemplateFiles, 0, templateFiles, 0, preDefinedTemplateFiles.length);
        System.arraycopy(userDefinedTemplateFiles, 0, templateFiles, preDefinedTemplateFiles.length, userDefinedTemplateFiles.length);
        for (int i = 0; i < templateFiles.length; ++i) {
            String tempName = templateFiles[i].getName().substring(0, templateFiles[i].getName().lastIndexOf("."));
            if (!tempName.equals(name)) continue;
            SwingTools.showVerySimpleErrorMessage("Name '" + name + "' is already used.\nPlease change name or delete the old template!");
            return false;
        }
        return true;
    }

    private void ok() {
        if (this.checkIfNameOk()) {
            this.ok = true;
            this.dispose();
        }
    }

    private void cancel() {
        this.ok = false;
        this.dispose();
    }

    private class TemplateParameterTableModel
    extends AbstractTableModel {
        private OperatorParameterPair[] parameters;
        private boolean[] selection;

        public TemplateParameterTableModel(OperatorParameterPair[] parameters) {
            this.parameters = parameters;
            this.selection = new boolean[parameters.length];
        }

        public String getColumnName(int column) {
            if (column == 0) {
                return "Parameter name";
            }
            return "Selected for Template";
        }

        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return this.parameters[row].toString();
            }
            return new Boolean(this.selection[row]);
        }

        public void setValueAt(Object o, int row, int column) {
            if (column == 1) {
                this.selection[row] = (Boolean)o;
                this.fireTableCellUpdated(row, column);
            }
        }

        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }

        public int getRowCount() {
            return this.parameters.length;
        }

        public int getColumnCount() {
            return 2;
        }

        public Class getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }

        public List getSelectedParameters() {
            LinkedList<String[]> selected = new LinkedList<String[]>();
            for (int i = 0; i < this.parameters.length; ++i) {
                if (!this.selection[i]) continue;
                selected.add(this.parameters[i].getStringPair());
            }
            return selected;
        }
    }

    private class OperatorParameterPair
    implements Comparable {
        private String[] pair;

        public OperatorParameterPair(String[] pair) {
            this.pair = pair;
        }

        public int compareTo(Object o) {
            OperatorParameterPair opp = (OperatorParameterPair)o;
            return (this.pair[0] + "." + this.pair[1]).compareTo(opp.pair[0] + "." + opp.pair[1]);
        }

        public String toString() {
            return this.pair[0] + "." + this.pair[1];
        }

        public String[] getStringPair() {
            return this.pair;
        }
    }
}

