/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.ObjectVisualizer;
import edu.udo.cs.yale.Statistics;
import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.gui.Plotter;
import edu.udo.cs.yale.gui.SwingTools;
import edu.udo.cs.yale.tools.LogService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PlotterPanel
extends JPanel
implements MouseMotionListener,
MouseListener {
    public static final String[] PLOTTER_NAMES = new String[]{"Yale Plotter", "Scatter Plot", "GnuPlot", "Distribution"};
    private static final Class[] PLOTTERS = new Class[]{class$edu$udo$cs$yale$gui$ColorPlotter == null ? (class$edu$udo$cs$yale$gui$ColorPlotter = PlotterPanel.class$("edu.udo.cs.yale.gui.ColorPlotter")) : class$edu$udo$cs$yale$gui$ColorPlotter, class$edu$udo$cs$yale$gui$ScatterPlotter == null ? (class$edu$udo$cs$yale$gui$ScatterPlotter = PlotterPanel.class$("edu.udo.cs.yale.gui.ScatterPlotter")) : class$edu$udo$cs$yale$gui$ScatterPlotter, class$edu$udo$cs$yale$gui$GnuPlotPlotter == null ? (class$edu$udo$cs$yale$gui$GnuPlotPlotter = PlotterPanel.class$("edu.udo.cs.yale.gui.GnuPlotPlotter")) : class$edu$udo$cs$yale$gui$GnuPlotPlotter, class$edu$udo$cs$yale$gui$DistributionPlotter == null ? (class$edu$udo$cs$yale$gui$DistributionPlotter = PlotterPanel.class$("edu.udo.cs.yale.gui.DistributionPlotter")) : class$edu$udo$cs$yale$gui$DistributionPlotter};
    private Plotter plotter = null;
    private Statistics statistics;
    private JLabel coordinatesLabel = new JLabel("                      ");
    private Point pressStart = null;
    private int selectedPlotter = 0;
    static /* synthetic */ Class class$edu$udo$cs$yale$gui$ColorPlotter;
    static /* synthetic */ Class class$edu$udo$cs$yale$gui$ScatterPlotter;
    static /* synthetic */ Class class$edu$udo$cs$yale$gui$GnuPlotPlotter;
    static /* synthetic */ Class class$edu$udo$cs$yale$gui$DistributionPlotter;

    public PlotterPanel(JLabel component) {
        super(new BorderLayout());
        component.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        component.setFont(component.getFont().deriveFont(0));
        this.add(component);
    }

    public PlotterPanel(Statistics statistics) {
        super(new BorderLayout());
        this.statistics = statistics;
        String plotterProperty = System.getProperty("yale.gui.plotter.default");
        this.selectedPlotter = PlotterPanel.getPlotterIndex(plotterProperty);
        if (this.selectedPlotter < 0) {
            LogService.logMessage("Default plotter '" + plotterProperty + "' unknown, using " + PLOTTER_NAMES[0], 6);
            this.selectedPlotter = 0;
        }
        this.update();
    }

    private static int getPlotterIndex(String name) {
        for (int i = 0; i < PLOTTER_NAMES.length; ++i) {
            if (!PLOTTER_NAMES[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    private void setSelectedPlotter(int index) {
        this.selectedPlotter = index;
    }

    private void update() {
        int i;
        int[] axis = null;
        LinkedList<Integer> valuesList = new LinkedList<Integer>();
        if (this.plotter != null) {
            int i2;
            axis = new int[this.plotter.getNumberOfAxes()];
            for (i2 = 0; i2 < axis.length; ++i2) {
                axis[i2] = this.plotter.getAxis(i2);
            }
            for (i2 = 0; i2 < this.statistics.getNumberOfColumns(); ++i2) {
                if (!this.plotter.getPlotColumn(i2)) continue;
                valuesList.add(new Integer(i2));
            }
        }
        int[] selectedIndices = new int[valuesList.size()];
        int k = 0;
        Iterator v = valuesList.iterator();
        while (v.hasNext()) {
            selectedIndices[k++] = (Integer)v.next();
        }
        try {
            this.plotter = (Plotter)PLOTTERS[this.selectedPlotter].newInstance();
            this.plotter.setStatistics(this.statistics);
        }
        catch (Exception e) {
            SwingTools.showErrorMessage("Cannot instantiate plotter '" + PLOTTER_NAMES[this.selectedPlotter] + "':", e);
            return;
        }
        this.removeAll();
        this.plotter.addMouseMotionListener(this);
        this.plotter.addMouseListener(this);
        this.add(this.plotter.getPlotter(), "Center");
        this.coordinatesLabel = new JLabel("                      ");
        this.coordinatesLabel.setBorder(BorderFactory.createEtchedBorder());
        this.coordinatesLabel.setFont(new Font("Monospaced", 0, this.coordinatesLabel.getFont().getSize()));
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        c.insets = new Insets(2, 2, 2, 2);
        JPanel axesSelectionPanel = new JPanel(gridBag);
        JLabel label = new JLabel("Plotter");
        gridBag.setConstraints(label, c);
        axesSelectionPanel.add(label);
        final JComboBox<String> plotterCombo = new JComboBox<String>();
        for (i = 0; i < PLOTTER_NAMES.length; ++i) {
            plotterCombo.addItem(PLOTTER_NAMES[i]);
        }
        plotterCombo.setSelectedIndex(this.selectedPlotter);
        plotterCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PlotterPanel.this.setSelectedPlotter(plotterCombo.getSelectedIndex());
                PlotterPanel.this.update();
            }
        });
        gridBag.setConstraints(plotterCombo, c);
        axesSelectionPanel.add(plotterCombo);
        for (i = 0; i < this.plotter.getNumberOfAxes(); ++i) {
            label = new JLabel(this.plotter.getAxisName(i));
            gridBag.setConstraints(label, c);
            axesSelectionPanel.add(label);
            final JComboBox<String> axisCombo = new JComboBox<String>();
            axisCombo.addItem("None");
            for (int j = 0; j < this.statistics.getNumberOfColumns(); ++j) {
                axisCombo.addItem(this.statistics.getColumnName(j));
            }
            final int index = i;
            axisCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    PlotterPanel.this.plotter.setAxis(index, axisCombo.getSelectedIndex() - 1);
                }
            });
            if (axis != null && axis.length > i) {
                axisCombo.setSelectedIndex(Math.max(0, axis[i] + 1));
            }
            gridBag.setConstraints(axisCombo, c);
            axesSelectionPanel.add(axisCombo);
        }
        JLabel plotLabel = new JLabel("Plots");
        gridBag.setConstraints(plotLabel, c);
        axesSelectionPanel.add(plotLabel);
        switch (this.plotter.getValuePlotSelectionType()) {
            case 1: {
                final JList<String> plotList = new JList<String>(this.statistics.getColumnNames());
                plotList.setBorder(BorderFactory.createLoweredBevelBorder());
                plotList.setCellRenderer(new LineStyleCellRenderer(this.plotter));
                plotList.addListSelectionListener(new ListSelectionListener(){

                    public void valueChanged(ListSelectionEvent e) {
                        for (int i = 0; i < plotList.getModel().getSize(); ++i) {
                            PlotterPanel.this.plotter.setPlotColumn(i, plotList.isSelectedIndex(i));
                        }
                    }
                });
                plotList.setSelectionMode(2);
                plotList.setSelectedIndices(selectedIndices);
                JScrollPane listScrollPane = new JScrollPane(plotList);
                c.weighty = 1.0;
                gridBag.setConstraints(listScrollPane, c);
                axesSelectionPanel.add(listScrollPane);
                c.weighty = 0.0;
                break;
            }
            default: {
                final JComboBox<String> plotCombo = new JComboBox<String>();
                plotCombo.addItem("None");
                for (int j = 0; j < this.statistics.getNumberOfColumns(); ++j) {
                    plotCombo.addItem(this.statistics.getColumnName(j));
                }
                plotCombo.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent e) {
                        PlotterPanel.this.plotter.setPlotColumn(plotCombo.getSelectedIndex() - 1, true);
                    }
                });
                if (selectedIndices.length > 0) {
                    plotCombo.setSelectedIndex(selectedIndices[0] + 1);
                }
                gridBag.setConstraints(plotCombo, c);
                axesSelectionPanel.add(plotCombo);
            }
        }
        if (this.plotter.canHandleDrawAmount()) {
            label = new JLabel("Draw amount");
            gridBag.setConstraints(label, c);
            axesSelectionPanel.add(label);
            final JSlider drawAmountSlider = new JSlider(1, 100, 100);
            gridBag.setConstraints(drawAmountSlider, c);
            axesSelectionPanel.add(drawAmountSlider);
            drawAmountSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    PlotterPanel.this.plotter.setDrawAmount(drawAmountSlider.getValue());
                }
            });
        }
        if (this.plotter.hasOptionsDialog()) {
            JButton optionsButton = new JButton("Options");
            gridBag.setConstraints(optionsButton, c);
            axesSelectionPanel.add(optionsButton);
            optionsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PlotterPanel.this.plotter.showOptionsDialog();
                }
            });
        }
        if (this.plotter.isSaveable()) {
            JButton saveButton = new JButton("Save...");
            saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PlotterPanel.this.plotter.save();
                }
            });
            gridBag.setConstraints(saveButton, c);
            axesSelectionPanel.add(saveButton);
        }
        gridBag.setConstraints(this.coordinatesLabel, c);
        axesSelectionPanel.add(this.coordinatesLabel);
        if (this.plotter.getValuePlotSelectionType() == 0) {
            c.weighty = 1.0;
            JPanel fillPanel = new JPanel();
            gridBag.setConstraints(fillPanel, c);
            axesSelectionPanel.add(fillPanel);
            c.weighty = 0.0;
        }
        axesSelectionPanel.setAlignmentX(0.0f);
        this.add((Component)axesSelectionPanel, "West");
        this.revalidate();
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        Point2D p = this.plotter.getPositionInDataSpace(e.getPoint());
        if (p != null) {
            DecimalFormat format = new DecimalFormat(" 0.000E0;-0.000E0");
            this.coordinatesLabel.setText(format.format(p.getX()) + " , " + format.format(p.getY()));
        }
        this.plotter.setMousePosInDataSpace(e.getX(), e.getY());
    }

    public void mouseDragged(MouseEvent e) {
        if (this.pressStart != null && Math.abs((double)e.getX() - this.pressStart.getX()) > 5.0 && Math.abs((double)e.getY() - this.pressStart.getY()) > 5.0) {
            this.plotter.setDragBounds((int)Math.min(this.pressStart.getX(), (double)e.getX()), (int)Math.min(this.pressStart.getY(), (double)e.getY()), (int)Math.abs(this.pressStart.getX() - (double)e.getX()), (int)Math.abs(this.pressStart.getY() - (double)e.getY()));
        } else {
            this.plotter.setDragBounds(-1, -1, -1, -1);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            String id;
            if (e.getClickCount() > 1 && (id = this.plotter.getIdForPos(e.getX(), e.getY())) != null) {
                ObjectVisualizer visualizer = Yale.getExperiment().getVisualizerForObject(id);
                visualizer.startVisualization(id);
            }
        } else if (e.getButton() == 3) {
            this.plotter.setDrawRange(-1.0, -1.0, -1.0, -1.0);
            this.pressStart = null;
            this.plotter.setDragBounds(-1, -1, -1, -1);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1 && Math.abs((double)e.getX() - this.pressStart.getX()) > 5.0 && Math.abs((double)e.getY() - this.pressStart.getY()) > 5.0 && this.pressStart != null) {
            Point2D pressPoint = this.plotter.getPositionInDataSpace(this.pressStart);
            Point2D releasePoint = this.plotter.getPositionInDataSpace(e.getPoint());
            if (pressPoint != null) {
                this.plotter.setDrawRange(Math.min(pressPoint.getX(), releasePoint.getX()), Math.max(pressPoint.getX(), releasePoint.getX()), Math.min(pressPoint.getY(), releasePoint.getY()), Math.max(pressPoint.getY(), releasePoint.getY()));
            }
        }
        this.plotter.setDragBounds(-1, -1, -1, -1);
        this.pressStart = null;
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.pressStart = e.getPoint();
        }
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LineStyleCellRenderer
    extends JLabel
    implements ListCellRenderer {
        Plotter plotter;

        public LineStyleCellRenderer(Plotter plotter) {
            this.plotter = plotter;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.toString();
            this.setText(s);
            Icon icon = this.plotter.getIcon(index);
            if (icon != null) {
                this.setIcon(icon);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

