/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class OperatorTreeModel
implements TreeModel {
    private Operator root;
    private List treeModelListeners = new LinkedList();

    public OperatorTreeModel(Operator root) {
        this.root = root;
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object parent, int index) {
        if (parent instanceof OperatorChain) {
            return ((OperatorChain)parent).getOperatorFromAll(index);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (parent instanceof OperatorChain) {
            return ((OperatorChain)parent).getNumberOfAllOperators();
        }
        return 0;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof OperatorChain) {
            return ((OperatorChain)parent).getIndexOfOperator((Operator)child);
        }
        return -1;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void valueForPathChanged(TreePath path, Object node) {
        Operator op = (Operator)path.getLastPathComponent();
        op.rename(((String)node).trim());
        YaleGUI.getMainFrame().experimentChanged();
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.add(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(l);
    }

    public void fireOperatorInserted(Object source, TreePath path, int index, Operator operator) {
        Iterator i = this.treeModelListeners.iterator();
        while (i.hasNext()) {
            ((TreeModelListener)i.next()).treeNodesInserted(new TreeModelEvent(source, path, new int[]{index}, new Object[]{operator}));
        }
    }

    public void fireOperatorRemoved(Object source, TreePath path, int index, Operator operator) {
        Iterator i = this.treeModelListeners.iterator();
        while (i.hasNext()) {
            ((TreeModelListener)i.next()).treeNodesRemoved(new TreeModelEvent(source, path, new int[]{index}, new Object[]{operator}));
        }
    }

    public void fireOperatorRenamed(Object source, TreePath path) {
        Iterator i = this.treeModelListeners.iterator();
        while (i.hasNext()) {
            ((TreeModelListener)i.next()).treeNodesChanged(new TreeModelEvent(source, path));
        }
    }

    public void fireOperatorChanged(Object source, TreePath path) {
        Iterator i = this.treeModelListeners.iterator();
        while (i.hasNext()) {
            ((TreeModelListener)i.next()).treeNodesChanged(new TreeModelEvent(source, path));
        }
    }

    public void fireStructureChanged(Object source, TreePath path) {
        Iterator i = this.treeModelListeners.iterator();
        while (i.hasNext()) {
            ((TreeModelListener)i.next()).treeStructureChanged(new TreeModelEvent(source, path));
        }
    }
}

