/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.BreakpointListener;
import edu.udo.cs.yale.gui.ConditionalAction;
import edu.udo.cs.yale.gui.MainFrame;
import edu.udo.cs.yale.gui.NewOperatorDialog;
import edu.udo.cs.yale.gui.OperatorInfoScreen;
import edu.udo.cs.yale.gui.OperatorMenu;
import edu.udo.cs.yale.gui.OperatorTreeCellEditor;
import edu.udo.cs.yale.gui.OperatorTreeCellRenderer;
import edu.udo.cs.yale.gui.OperatorTreeModel;
import edu.udo.cs.yale.gui.SwingTools;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.operator.ExperimentOperator;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class OperatorTree
extends JTree
implements TreeSelectionListener,
MouseListener {
    private static int CLIPBOARD_MODE_EMPTY = 0;
    private static int CLIPBOARD_MODE_CUT = 1;
    private static int CLIPBOARD_MODE_COPY = 2;
    private MainFrame mainFrame;
    private OperatorTreeModel treeModel;
    private Operator clipBoard = null;
    private int clipBoardMode = CLIPBOARD_MODE_EMPTY;
    public final Action NEW_OPERATOR_ACTION = new NewOperatorAction();
    public final Action CUT_ACTION = new CutAction();
    public final Action COPY_ACTION = new CopyAction();
    public final Action PASTE_ACTION = new PasteAction();
    public final Action DELETE_OPERATOR_ACTION = new DeleteOperatorAction();
    public final Action RENAME_OPERATOR_ACTION = new RenameOperatorAction();
    public final Action INFO_OPERATOR_ACTION = new InfoOperatorAction();
    public final ToggleBreakpointItem[] TOGGLE_BREAKPOINT = new ToggleBreakpointItem[]{new ToggleBreakpointItem(0), new ToggleBreakpointItem(1), new ToggleBreakpointItem(2)};

    public OperatorTree(MainFrame mainFrame) {
        this.getInputMap().put(KeyStroke.getKeyStroke(88, 2), this.CUT_ACTION);
        this.getInputMap().put(KeyStroke.getKeyStroke(67, 2), this.COPY_ACTION);
        this.getInputMap().put(KeyStroke.getKeyStroke(86, 2), this.PASTE_ACTION);
        this.setCellRenderer(new OperatorTreeCellRenderer());
        this.setCellEditor(new OperatorTreeCellEditor(this));
        this.mainFrame = mainFrame;
        this.setEditable(true);
        this.setShowsRootHandles(true);
        this.addTreeSelectionListener(this);
        this.addMouseListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setOperator(Operator root) {
        this.treeModel = new OperatorTreeModel(root);
        this.setModel(this.treeModel);
        this.mainFrame = this.mainFrame;
        this.setRootVisible(true);
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    public Operator getSelectedOperator() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        return (Operator)path.getLastPathComponent();
    }

    public void refresh() {
        this.refresh(new TreePath(this.treeModel.getRoot()));
    }

    private void refresh(TreePath path) {
        this.treeModel.fireOperatorChanged(this, path);
        Object object = path.getLastPathComponent();
        int numberOfChildren = this.treeModel.getChildCount(object);
        for (int i = 0; i < numberOfChildren; ++i) {
            Object child = this.treeModel.getChild(object, i);
            this.refresh(path.pathByAddingChild(child));
        }
    }

    public void moveDown() {
        Operator selectedOperator = this.getSelectedOperator();
        if (selectedOperator == null) {
            return;
        }
        OperatorChain parent = selectedOperator.getParent();
        if (parent == null) {
            return;
        }
        int oldPos = parent.getIndexOfOperator(selectedOperator);
        if (oldPos < parent.getNumberOfAllOperators() - 1) {
            selectedOperator.remove();
            parent.addOperator(selectedOperator, oldPos + 1);
            selectedOperator.register(selectedOperator.getExperiment(), selectedOperator.getName());
            TreePath path = this.getSelectionPath().getParentPath();
            this.treeModel.fireStructureChanged(this, path);
            this.setSelectionPath(path.pathByAddingChild(selectedOperator));
            this.mainFrame.experimentChanged();
        }
    }

    public void moveUp() {
        Operator selectedOperator = this.getSelectedOperator();
        if (selectedOperator == null) {
            return;
        }
        OperatorChain parent = selectedOperator.getParent();
        if (parent == null) {
            return;
        }
        int oldPos = parent.getIndexOfOperator(selectedOperator);
        if (oldPos > 0) {
            selectedOperator.remove();
            parent.addOperator(selectedOperator, oldPos - 1);
            selectedOperator.register(selectedOperator.getExperiment(), selectedOperator.getName());
            TreePath path = this.getSelectionPath().getParentPath();
            this.treeModel.fireStructureChanged(this, path);
            this.setSelectionPath(path.pathByAddingChild(selectedOperator));
            this.mainFrame.experimentChanged();
        }
    }

    private void delete() {
        Operator selectedOperator = this.getSelectedOperator();
        if (selectedOperator == null) {
            return;
        }
        int index = selectedOperator.getParent().getIndexOfOperator(selectedOperator);
        selectedOperator.remove();
        this.treeModel.fireOperatorRemoved(this, this.getSelectionPath().getParentPath(), index, selectedOperator);
        this.mainFrame.experimentChanged();
        this.mainFrame.enableActions();
    }

    public void insert(Operator newOperator) {
        Operator selectedOperator = this.getSelectedOperator();
        if (selectedOperator == null) {
            return;
        }
        if (selectedOperator instanceof OperatorChain) {
            int index = ((OperatorChain)selectedOperator).addOperator(newOperator);
            this.treeModel.fireOperatorInserted(this, this.getSelectionPath(), index, newOperator);
            this.scrollPathToVisible(this.getSelectionPath().pathByAddingChild(newOperator));
            this.mainFrame.experimentChanged();
        }
    }

    public void replace(Operator operator) {
        Operator selectedOperator = this.getSelectedOperator();
        if (selectedOperator == null) {
            return;
        }
        OperatorChain parent = selectedOperator.getParent();
        if (parent == null) {
            return;
        }
        int oldPos = parent.getIndexOfOperator(selectedOperator);
        if (selectedOperator instanceof OperatorChain && operator instanceof OperatorChain) {
            OperatorChain chain = (OperatorChain)selectedOperator;
            OperatorChain newChain = (OperatorChain)operator;
            while (chain.getNumberOfAllOperators() > 0) {
                Operator child = chain.getOperatorFromAll(0);
                chain.removeOperator(child);
                newChain.addOperator(child);
            }
        }
        selectedOperator.remove();
        parent.addOperator(operator, oldPos);
        TreePath path = this.getSelectionPath().getParentPath();
        this.treeModel.fireStructureChanged(this, path);
        this.setSelectionPath(path.pathByAddingChild(selectedOperator));
        this.mainFrame.experimentChanged();
    }

    public void valueChanged(TreeSelectionEvent e) {
        Operator selectedOperator = this.getSelectedOperator();
        this.mainFrame.getPropertyTable().setOperator(selectedOperator);
        if (selectedOperator == null) {
            return;
        }
        this.mainFrame.enableActions();
        for (int i = 0; i < this.TOGGLE_BREAKPOINT.length; ++i) {
            this.TOGGLE_BREAKPOINT[i].setState(selectedOperator.hasBreakpoint(i));
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.setSelectionPath(this.getClosestPathForLocation(e.getX(), e.getY()));
        if (e.getModifiers() == 4) {
            this.createPopupMenu().show(this, e.getX(), e.getY());
        }
    }

    public void createOperatorMenu(JMenu menu) {
        menu.add(this.RENAME_OPERATOR_ACTION);
        menu.add(this.COPY_ACTION);
        menu.add(this.CUT_ACTION);
        menu.add(this.PASTE_ACTION);
        menu.add(this.DELETE_OPERATOR_ACTION);
    }

    public JPopupMenu createPopupMenu() {
        Operator op = this.getSelectedOperator();
        JPopupMenu menu = new JPopupMenu();
        if (op != null && op instanceof OperatorChain) {
            menu.add(OperatorMenu.NEW_OPERATOR_MENU);
        }
        if (op != null && !(op instanceof ExperimentOperator)) {
            if (op instanceof OperatorChain && ((OperatorChain)op).getNumberOfAllOperators() > 0) {
                menu.add(OperatorMenu.REPLACE_OPERATORCHAIN_MENU);
            } else {
                menu.add(OperatorMenu.REPLACE_OPERATOR_MENU);
            }
        }
        menu.addSeparator();
        menu.add(this.RENAME_OPERATOR_ACTION);
        menu.add(this.COPY_ACTION);
        menu.add(this.CUT_ACTION);
        menu.add(this.PASTE_ACTION);
        menu.add(this.DELETE_OPERATOR_ACTION);
        menu.addSeparator();
        menu.add(this.INFO_OPERATOR_ACTION);
        menu.addSeparator();
        if (op != null && !(op instanceof ExperimentOperator)) {
            ToggleActivationItem activationItem = new ToggleActivationItem(op.isEnabled());
            if (op.getParent() != null && !op.getParent().isEnabled()) {
                activationItem.setEnabled(false);
            }
            menu.add(activationItem);
        }
        for (int i = 0; i < this.TOGGLE_BREAKPOINT.length; ++i) {
            menu.add(this.TOGGLE_BREAKPOINT[i]);
        }
        return menu;
    }

    public Operator getClipBoard() {
        return this.clipBoard;
    }

    private class ToggleActivationItem
    extends JCheckBoxMenuItem
    implements ActionListener {
        private ToggleActivationItem(boolean state) {
            super("Enable operator", state);
            this.setMnemonic(69);
            this.addActionListener(this);
            this.setToolTipText("Enable or disable selected operator");
        }

        public void actionPerformed(ActionEvent e) {
            Operator selectedOperator = OperatorTree.this.getSelectedOperator();
            if (selectedOperator != null) {
                selectedOperator.setEnabled(this.getState());
                OperatorTree.this.refresh();
                OperatorTree.this.mainFrame.experimentChanged();
            }
        }
    }

    private class ToggleBreakpointItem
    extends JCheckBoxMenuItem
    implements ActionListener {
        private int position;

        private ToggleBreakpointItem(int position) {
            super("Breakpoint " + BreakpointListener.BREAKPOINT_POS_NAME[position]);
            this.position = position;
            this.addActionListener(this);
            this.setToolTipText("Toggle breakpoint " + BreakpointListener.BREAKPOINT_POS_NAME[position] + " selected operator");
            switch (position) {
                case 0: {
                    this.setMnemonic(66);
                    break;
                }
                case 1: {
                    this.setMnemonic(87);
                    break;
                }
                case 2: {
                    this.setMnemonic(65);
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            Operator selectedOperator = OperatorTree.this.getSelectedOperator();
            if (selectedOperator != null) {
                selectedOperator.setBreakpoint(this.position, this.getState());
                OperatorTree.this.refresh();
                OperatorTree.this.mainFrame.experimentChanged();
            }
        }
    }

    private class InfoOperatorAction
    extends ConditionalAction {
        private InfoOperatorAction() {
            super("Operator Info", new ImageIcon(Tools.getResource("icons/icon_info.gif")));
            this.putValue("ShortDescription", "Shows information about selected operator");
            this.putValue("MnemonicKey", new Integer(73));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(112, 0));
            this.setCondition(0, 1);
        }

        public void actionPerformed(ActionEvent e) {
            Operator selectedOperator = OperatorTree.this.getSelectedOperator();
            if (selectedOperator != null) {
                OperatorInfoScreen infoScreen = new OperatorInfoScreen((Frame)OperatorTree.this.mainFrame, selectedOperator);
                infoScreen.setVisible(true);
                if (infoScreen.isOk()) {
                    selectedOperator.setUserDescription(infoScreen.getUserDescription());
                    OperatorTree.this.mainFrame.experimentChanged();
                }
            }
        }
    }

    private class RenameOperatorAction
    extends ConditionalAction {
        private RenameOperatorAction() {
            super("Rename operator", new ImageIcon(Tools.getResource("icons/icon_rename.gif")));
            this.putValue("ShortDescription", "Rename selected operator");
            this.putValue("MnemonicKey", new Integer(82));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(113, 0));
            this.setCondition(0, 1);
        }

        public void actionPerformed(ActionEvent e) {
            TreePath path = OperatorTree.this.getSelectionPath();
            if (path != null) {
                OperatorTree.this.startEditingAtPath(path);
            }
        }
    }

    private class DeleteOperatorAction
    extends ConditionalAction {
        private DeleteOperatorAction() {
            super("Delete operator", new ImageIcon(Tools.getResource("icons/icon_delete_operator.gif")));
            this.putValue("ShortDescription", "Delete selected operator");
            this.putValue("MnemonicKey", new Integer(68));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
            this.setCondition(0, 1);
            this.setCondition(2, -1);
        }

        public void actionPerformed(ActionEvent e) {
            OperatorTree.this.delete();
        }
    }

    private class PasteAction
    extends ConditionalAction {
        private PasteAction() {
            super("Paste", new ImageIcon(Tools.getResource("icons/icon_paste.gif")));
            this.putValue("ShortDescription", "Paste operator");
            this.putValue("MnemonicKey", new Integer(80));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 2));
            this.setCondition(3, 1);
            this.setCondition(1, 1);
        }

        public void actionPerformed(ActionEvent e) {
            if (OperatorTree.this.clipBoard != null) {
                if (OperatorTree.this.clipBoardMode == CLIPBOARD_MODE_CUT) {
                    OperatorTree.this.clipBoard.register(YaleGUI.getExperiment(), OperatorTree.this.clipBoard.getName());
                }
                OperatorTree.this.insert(OperatorTree.this.clipBoard);
            }
            OperatorTree.this.clipBoard = null;
            OperatorTree.this.clipBoardMode = CLIPBOARD_MODE_EMPTY;
            OperatorTree.this.mainFrame.enableActions();
        }
    }

    private class CopyAction
    extends ConditionalAction {
        private CopyAction() {
            super("Copy", new ImageIcon(Tools.getResource("icons/icon_copy.gif")));
            this.putValue("ShortDescription", "Copy selected operator");
            this.putValue("MnemonicKey", new Integer(67));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 2));
            this.setCondition(0, 1);
            this.setCondition(2, -1);
        }

        public void actionPerformed(ActionEvent e) {
            Operator selectedOperator = OperatorTree.this.getSelectedOperator();
            if (selectedOperator != null) {
                OperatorTree.this.clipBoard = selectedOperator.cloneOperator(selectedOperator.getName());
                OperatorTree.this.clipBoardMode = CLIPBOARD_MODE_COPY;
                OperatorTree.this.mainFrame.enableActions();
            }
        }
    }

    private class CutAction
    extends ConditionalAction {
        private CutAction() {
            super("Cut", new ImageIcon(Tools.getResource("icons/icon_cut.gif")));
            this.putValue("ShortDescription", "Cut selected operator");
            this.putValue("MnemonicKey", new Integer(84));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 2));
            this.setCondition(0, 1);
            this.setCondition(2, -1);
        }

        public void actionPerformed(ActionEvent e) {
            Operator selectedOperator = OperatorTree.this.getSelectedOperator();
            if (selectedOperator != null) {
                OperatorTree.this.clipBoard = selectedOperator;
                OperatorTree.this.clipBoardMode = CLIPBOARD_MODE_CUT;
                OperatorTree.this.delete();
                OperatorTree.this.mainFrame.enableActions();
            }
        }
    }

    private class NewOperatorAction
    extends ConditionalAction {
        private NewOperatorAction() {
            super("New operator...", new ImageIcon(Tools.getResource("icons/icon_insert_operator.gif")));
            this.putValue("ShortDescription", "Add new operator");
            this.putValue("MnemonicKey", new Integer(78));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, 2));
            this.setCondition(1, 1);
        }

        public void actionPerformed(ActionEvent e) {
            Operator selectedOperator = OperatorTree.this.getSelectedOperator();
            if (selectedOperator != null) {
                NewOperatorDialog dialog = new NewOperatorDialog();
                dialog.setVisible(true);
                if (dialog.isOk()) {
                    try {
                        Operator operator = dialog.getOperator();
                        if (operator != null) {
                            YaleGUI.getMainFrame().getOperatorTree().insert(operator);
                        }
                    }
                    catch (Exception ex) {
                        SwingTools.showSimpleErrorMessage("Cannot create operator:", ex);
                    }
                }
            }
        }
    }
}

