/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.gui.SwingTools;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class OperatorInfoScreen
extends JDialog {
    private JTextArea userDescription = null;
    private boolean ok = false;

    public OperatorInfoScreen(Frame owner, Operator operator) {
        super(owner, "Operator Info", true);
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagLayout layout = new GridBagLayout();
        JPanel mainPanel = new JPanel(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.ipadx = 10;
        c.weightx = 1.0;
        JLabel label = null;
        Image img = operator.getOperatorDescription().getIcon();
        if (img != null) {
            label = new JLabel(new ImageIcon(img));
            c.gridwidth = 0;
            layout.setConstraints(label, c);
            mainPanel.add(label);
        }
        Component sep = Box.createVerticalStrut(10);
        c.gridwidth = 0;
        layout.setConstraints(sep, c);
        mainPanel.add(sep);
        label = new JLabel("Name");
        label.setToolTipText("The name of the operator");
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        label = new JLabel(operator.getName());
        label.setToolTipText("The name of the operator");
        c.gridwidth = 0;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        label = new JLabel("Group");
        label.setToolTipText("The group of the operator");
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        label = new JLabel(operator.getOperatorDescription().getGroup());
        label.setToolTipText("The group of the operator");
        c.gridwidth = 0;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        label = new JLabel("Class");
        label.setToolTipText("The type of the operator");
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        label = new JLabel(operator.getOperatorDescription().getName());
        label.setToolTipText("The type of the operator");
        c.gridwidth = 0;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        sep = Box.createVerticalStrut(10);
        c.gridwidth = 0;
        layout.setConstraints(sep, c);
        mainPanel.add(sep);
        label = new JLabel("Input");
        label.setToolTipText("Expected input");
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        Class[] input = operator.getInputClasses();
        String inputString = "";
        if (input == null) {
            inputString = "none";
        } else {
            for (int i = 0; i < input.length; ++i) {
                if (i != 0) {
                    inputString = inputString + ", ";
                }
                inputString = inputString + Tools.classNameWOPackage(input[i]);
            }
        }
        if (inputString.length() == 0) {
            inputString = "none";
        }
        label = new JLabel(inputString);
        label.setToolTipText("Expected input");
        c.gridwidth = 0;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        label = new JLabel("Output");
        label.setToolTipText("Delivered output");
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        Class[] output = operator.getOutputClasses();
        String outputString = "";
        if (output == null) {
            outputString = "none";
        } else {
            for (int i = 0; i < output.length; ++i) {
                if (i != 0) {
                    outputString = outputString + ", ";
                }
                outputString = outputString + Tools.classNameWOPackage(output[i]);
            }
        }
        if (outputString.length() == 0) {
            outputString = "none";
        }
        label = new JLabel(outputString);
        label.setToolTipText("Delivered output");
        c.gridwidth = 0;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        if (operator instanceof OperatorChain) {
            OperatorChain chain = (OperatorChain)operator;
            sep = Box.createVerticalStrut(10);
            c.gridwidth = 0;
            layout.setConstraints(sep, c);
            mainPanel.add(sep);
            if (chain.getMinNumberOfInnerOperators() == chain.getMaxNumberOfInnerOperators()) {
                label = new JLabel("Inner Operators");
                label.setToolTipText("Number of inner operators");
                c.gridwidth = -1;
                layout.setConstraints(label, c);
                mainPanel.add(label);
                label = new JLabel(((OperatorChain)operator).getMinNumberOfInnerOperators() + "");
                label.setToolTipText("Number of inner operators");
                c.gridwidth = 0;
                layout.setConstraints(label, c);
                mainPanel.add(label);
            } else {
                label = new JLabel("Min Inner");
                label.setToolTipText("Minimum number of inner operators");
                c.gridwidth = -1;
                layout.setConstraints(label, c);
                mainPanel.add(label);
                label = new JLabel(((OperatorChain)operator).getMinNumberOfInnerOperators() + "");
                label.setToolTipText("Minimum number of inner operators");
                c.gridwidth = 0;
                layout.setConstraints(label, c);
                mainPanel.add(label);
                label = new JLabel("Max Inner");
                label.setToolTipText("Maximum number of inner operators");
                c.gridwidth = -1;
                layout.setConstraints(label, c);
                mainPanel.add(label);
                int maxInner = ((OperatorChain)operator).getMaxNumberOfInnerOperators();
                label = new JLabel(maxInner == Integer.MAX_VALUE ? "Max" : maxInner + "");
                label.setToolTipText("Maximum number of inner operators");
                c.gridwidth = 0;
                layout.setConstraints(label, c);
                mainPanel.add(label);
            }
        }
        JTextArea description = new JTextArea("", 4, 20);
        description.setToolTipText("A short description of this operator");
        description.setEditable(false);
        description.setLineWrap(true);
        description.setWrapStyleWord(true);
        description.setBackground(this.getBackground());
        description.setText(operator.getOperatorDescription().getDescription());
        JScrollPane textScrollPane = new JScrollPane(description);
        textScrollPane.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        c.gridwidth = 0;
        layout.setConstraints(textScrollPane, c);
        mainPanel.add(textScrollPane);
        List errorList = operator.getErrorList();
        if (errorList.size() > 0) {
            JEditorPane errors = new JEditorPane("text/html", "");
            errors.setToolTipText("Errors of this operator");
            errors.setEditable(false);
            errors.setBackground(this.getBackground());
            errors.setForeground(Color.red);
            String errorText = "<h3>Errors:</h3><ul>";
            Iterator i = errorList.iterator();
            while (i.hasNext()) {
                errorText = errorText + "<li>" + (String)i.next() + "</li>";
            }
            errorText = errorText + "</ul>";
            errors.setText(SwingTools.text2DisplayHtml(errorText));
            JScrollPane errorsScrollPane = new JScrollPane(errors);
            errorsScrollPane.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
            c.gridwidth = 0;
            layout.setConstraints(errorsScrollPane, c);
            mainPanel.add(errorsScrollPane);
        }
        this.userDescription = new JTextArea("", 4, 20);
        this.userDescription.setToolTipText("User defined description of this operator");
        this.userDescription.setEditable(true);
        this.userDescription.setLineWrap(true);
        this.userDescription.setWrapStyleWord(true);
        this.userDescription.setText(SwingTools.text2SimpleHtml(operator.getUserDescription()));
        JScrollPane userDescriptionScrollPane = new JScrollPane(this.userDescription);
        userDescriptionScrollPane.setBorder(BorderFactory.createTitledBorder("User description"));
        c.gridwidth = 0;
        c.weighty = 1.0;
        layout.setConstraints(userDescriptionScrollPane, c);
        mainPanel.add(userDescriptionScrollPane);
        rootPanel.add((Component)mainPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OperatorInfoScreen.this.ok();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OperatorInfoScreen.this.cancel();
            }
        });
        buttonPanel.add(cancelButton);
        rootPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add(rootPanel);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    public boolean isOk() {
        return this.ok;
    }

    public String getUserDescription() {
        return SwingTools.html2YaleText(this.userDescription.getText());
    }

    private void ok() {
        this.ok = true;
        this.dispose();
    }

    private void cancel() {
        this.ok = false;
        this.dispose();
    }
}

