/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.ExperimentListener;
import edu.udo.cs.yale.gui.ExperimentEditor;
import edu.udo.cs.yale.gui.SystemMonitor;
import edu.udo.cs.yale.operator.ExperimentOperator;
import edu.udo.cs.yale.operator.Operator;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class MonitorPanel
extends JPanel
implements ExperimentEditor,
ExperimentListener {
    private JProgressBar progressBar = new JProgressBar();
    private SystemMonitor monitor = new SystemMonitor();

    public MonitorPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.monitor, "Center");
        this.add((Component)this.progressBar, "South");
        this.progressBar.setMinimum(0);
        this.progressBar.setBorderPainted(true);
        this.progressBar.setStringPainted(true);
        this.progressBar.setBorder(BorderFactory.createTitledBorder("Experiment progress"));
    }

    public void experimentStep(ExperimentOperator operator) {
        int max = operator.getNumberOfSteps();
        int step = operator.getCurrentStep();
        this.progressBar.setMaximum(max);
        this.progressBar.setValue(step);
    }

    public void experimentEnded() {
        this.progressBar.setMaximum(1);
        this.progressBar.setValue(1);
    }

    public void setSystemMonitor(SystemMonitor mon) {
        this.remove(this.monitor);
        this.monitor = mon;
        this.add((Component)mon, "Center");
    }

    public void experimentChanged(Operator op) {
    }

    public void validateExperiment() {
    }

    public Component getMainComponent() {
        return this;
    }
}

