/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.gui.SimpleFileFilter;
import edu.udo.cs.yale.gui.SwingTools;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.tools.BugReport;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Date;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;

public class BugAssistant
extends JDialog {
    private static final String INSTRUCTIONS = "<html><h4>Send Bug Report</h4>This dialog will help you to file a bug report. It will automatically collect most of the data necessary to examine the problem. The assistant will create a zip file containing your experiment setup (xml file), parameter settings, log file, and information about the runtime environment. Yale does <i>not</i> automatically add data files or any other files since these may contain confidential data and may be large. You can attach them using the \"Add file...\" button. When you are done, save the bug report to disc and send it by email to</p><center><b><tt>yale-team@lists.sourceforge.net</tt></b></center>";
    private static final String TEXT_INSTRUCTIONS = "Enter a brief description of what happened into this text field. Please also describe the purpose of your experiment because this cannot always be concluded trivially from the experiment setup.";
    private JTextArea message = new JTextArea("Enter a brief description of what happened into this text field. Please also describe the purpose of your experiment because this cannot always be concluded trivially from the experiment setup.", 5, 20);
    private JTextComponent name = new JTextField(15);
    private JList attachments = new JList(new DefaultListModel());

    public BugAssistant(final Throwable exception) {
        super(YaleGUI.getMainFrame(), "Bug Report Assistant", true);
        GridBagLayout gbl = new GridBagLayout();
        this.getContentPane().setLayout(gbl);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridwidth = 0;
        JLabel instructions = new JLabel(INSTRUCTIONS);
        instructions.setFont(instructions.getFont().deriveFont(0));
        gbl.setConstraints(instructions, c);
        this.getContentPane().add(instructions);
        JLabel nameLabel = new JLabel("Your email address");
        c.gridwidth = 1;
        gbl.setConstraints(nameLabel, c);
        this.getContentPane().add(nameLabel);
        c.gridwidth = 0;
        gbl.setConstraints(this.name, c);
        this.getContentPane().add(this.name);
        this.message.setLineWrap(true);
        this.message.setWrapStyleWord(true);
        JScrollPane messagePane = new JScrollPane(this.message);
        c.gridwidth = 0;
        c.weighty = 5.0;
        gbl.setConstraints(messagePane, c);
        this.getContentPane().add(messagePane);
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 2;
        this.attachments.setSelectionMode(0);
        JScrollPane attachmentPane = new JScrollPane(this.attachments);
        gbl.setConstraints(attachmentPane, c);
        this.getContentPane().add(attachmentPane);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 1;
        c.gridy = 3;
        JButton add = new JButton("Add file...");
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File file = SwingTools.chooseFile(null, null, true);
                if (file != null) {
                    ((DefaultListModel)BugAssistant.this.attachments.getModel()).addElement(file);
                }
            }
        });
        gbl.setConstraints(add, c);
        this.getContentPane().add(add);
        c.gridx = 1;
        c.gridy = 4;
        JButton remove = new JButton("Remove file");
        remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object value = BugAssistant.this.attachments.getSelectedValue();
                if (BugAssistant.this.attachments.getSelectedIndex() >= 0) {
                    ((DefaultListModel)BugAssistant.this.attachments.getModel()).remove(BugAssistant.this.attachments.getSelectedIndex());
                }
            }
        });
        gbl.setConstraints(remove, c);
        this.getContentPane().add(remove);
        c.gridwidth = 0;
        c.gridheight = 1;
        c.gridx = 2;
        c.gridy = 3;
        JButton save = new JButton("Save Report...");
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String email = BugAssistant.this.name.getText().trim();
                if (email.length() == 0) {
                    JOptionPane.showMessageDialog(YaleGUI.getMainFrame(), "Please enter an email address.", "Form incomplete", 0);
                    return;
                }
                File file = SwingTools.chooseFile(null, new File("bugreport.zip"), false, false, new FileFilter[]{new SimpleFileFilter("zip archives", ".zip")});
                if (file != null) {
                    try {
                        DefaultListModel model = (DefaultListModel)BugAssistant.this.attachments.getModel();
                        File[] attachments = new File[model.getSize()];
                        for (int i = 0; i < attachments.length; ++i) {
                            attachments[i] = (File)model.getElementAt(i);
                        }
                        BugReport.createBugReport(file, exception, "From: " + BugAssistant.this.name.getText() + "\n" + "Date: " + new Date() + "\n\n" + BugAssistant.this.message.getText(), Yale.getExperiment(), YaleGUI.getMainFrame().getMessageViewer().getLogMessage(), attachments);
                        BugAssistant.this.dispose();
                    }
                    catch (Throwable t) {
                        SwingTools.showSimpleErrorMessage("Cannot create report file!", t);
                    }
                }
            }
        });
        gbl.setConstraints(save, c);
        this.getContentPane().add(save);
        c.gridx = 2;
        c.gridy = 4;
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BugAssistant.this.dispose();
            }
        });
        gbl.setConstraints(cancel, c);
        this.getContentPane().add(cancel);
        this.pack();
        this.message.setSelectionStart(0);
        this.message.setSelectionEnd(TEXT_INSTRUCTIONS.length() - 1);
        this.setLocationRelativeTo(YaleGUI.getMainFrame());
    }

    public Dimension getPreferredSize() {
        return new Dimension(YaleGUI.getMainFrame().getWidth() * 3 / 4, YaleGUI.getMainFrame().getHeight() * 3 / 4);
    }
}

