/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.gui.AttributeWeightCellEditor;
import edu.udo.cs.yale.gui.PropertyCellEditor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

public class AttributeWeightsTableModel
extends AbstractTableModel {
    public static final int VIEW_ALL = 0;
    public static final int VIEW_FILE = 1;
    public static final int VIEW_EXPERIMENT = 2;
    public static final int VIEW_UPDATED = 3;
    public static final int VIEW_SELECTED = 4;
    public static final String[] VIEW_MODES = new String[]{"Show all", "Show from file", "Show from experiment", "Show updated", "Show selected"};
    private AttributeWeights weights;
    private String[] attributeNames;
    private PropertyCellEditor[] editors;
    private Map updateMap = new HashMap();
    private int viewMode = 0;
    private boolean overwrite = false;
    private double minWeight = Double.NEGATIVE_INFINITY;
    private int selectionCount = 0;

    public AttributeWeightsTableModel(AttributeWeights weights) {
        this.weights = weights != null ? (AttributeWeights)weights.clone() : new AttributeWeights();
        Iterator i = this.weights.getAttributeNames().iterator();
        while (i.hasNext()) {
            String attributeName = (String)i.next();
            double oldWeight = this.weights.getWeight(attributeName);
            this.updateMap.put(attributeName, new State(1, oldWeight));
        }
        this.updateTable();
    }

    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return this.attributeNames[row];
        }
        if (column == 1) {
            return new Double(this.weights.getWeight(this.attributeNames[row]));
        }
        return null;
    }

    public void setValueAt(Object value, int row, int column) {
        double weight = this.weights.getWeight(this.attributeNames[row]);
        try {
            weight = Double.parseDouble((String)value);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.weights.setWeight(this.attributeNames[row], weight);
    }

    public boolean isCellEditable(int row, int column) {
        return column != 0;
    }

    public int getRowCount() {
        return this.attributeNames.length;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Attribute";
            }
            case 1: {
                return "Weight";
            }
        }
        return "?";
    }

    public AttributeWeights getAttributeWeights() {
        return this.weights;
    }

    public PropertyCellEditor getWeightEditor(int row) {
        return this.editors[row];
    }

    public void setViewMode(int mode) {
        this.viewMode = mode;
    }

    public void setOverwriteMode(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setMinWeight(double minWeight) {
        this.minWeight = minWeight;
    }

    public double getMinWeight() {
        return this.minWeight;
    }

    public void mergeWeights(AttributeWeights fileWeights) {
        Iterator i = fileWeights.getAttributeNames().iterator();
        while (i.hasNext()) {
            String attributeName = (String)i.next();
            double fileWeight = fileWeights.getWeight(attributeName);
            double experimentWeight = this.weights.getWeight(attributeName);
            if (fileWeight == 0.0) {
                this.weights.setWeight(attributeName, 0.0);
            } else if (this.overwrite) {
                this.weights.setWeight(attributeName, fileWeight);
            } else if (Double.isNaN(this.weights.getWeight(attributeName))) {
                this.weights.setWeight(attributeName, fileWeight);
            }
            State state = (State)this.updateMap.get(attributeName);
            if (state != null) {
                if (state.getSource() == 1) {
                    state.setSource(3);
                }
                if (fileWeight == experimentWeight) continue;
                state.setUpdated(true);
                continue;
            }
            this.updateMap.put(attributeName, new State(2, this.weights.getWeight(attributeName)));
        }
    }

    public void sortByColumn(int column, int direction) {
        if (column == 0) {
            Arrays.sort(this.attributeNames, new NameComparator(direction));
        } else {
            this.weights.sortByWeight(this.attributeNames, direction, 0);
        }
        super.fireTableChanged(new TableModelEvent(this));
    }

    public int getNumberOfSelected() {
        return this.selectionCount;
    }

    public int getTotalNumber() {
        return this.weights.size();
    }

    public void updateTable() {
        Iterator i = this.weights.getAttributeNames().iterator();
        LinkedList<String> names = new LinkedList<String>();
        this.selectionCount = 0;
        block6: while (i.hasNext()) {
            String attributeName = (String)i.next();
            double weight = this.weights.getWeight(attributeName);
            if (weight != 0.0) {
                ++this.selectionCount;
            }
            if (!(weight >= this.minWeight)) continue;
            State state = (State)this.updateMap.get(attributeName);
            switch (this.viewMode) {
                case 1: {
                    if (state.getSource() != 2) {
                        if (state.getSource() != 3) continue block6;
                    }
                    names.add(attributeName);
                    continue block6;
                }
                case 2: {
                    if (state.getSource() != 1) {
                        if (state.getSource() != 3) continue block6;
                    }
                    names.add(attributeName);
                    continue block6;
                }
                case 3: {
                    if (!state.isUpdated()) continue block6;
                    names.add(attributeName);
                    continue block6;
                }
                case 4: {
                    if (this.weights.getWeight(attributeName) == 0.0) continue block6;
                    names.add(attributeName);
                    continue block6;
                }
            }
            names.add(attributeName);
        }
        this.attributeNames = new String[names.size()];
        names.toArray(this.attributeNames);
        this.editors = new PropertyCellEditor[this.attributeNames.length];
        for (int k = 0; k < this.editors.length; ++k) {
            this.editors[k] = new AttributeWeightCellEditor(((State)this.updateMap.get(this.attributeNames[k])).getOldWeight());
        }
        super.fireTableChanged(new TableModelEvent(this));
    }

    public void addMouseListenerToHeaderInTable(final JTable table) {
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = table.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = table.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    int shiftPressed = e.getModifiers() & 1;
                    int direction = shiftPressed == 0 ? 1 : -1;
                    AttributeWeightsTableModel.this.sortByColumn(column, direction);
                }
            }
        };
        table.getTableHeader().addMouseListener(listMouseListener);
    }

    private class NameComparator
    implements Comparator {
        private int direction;

        public NameComparator(int direction) {
            this.direction = direction;
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                return ((String)o1).compareTo((String)o2) * this.direction;
            }
            return 0;
        }
    }

    private class State {
        public static final int SOURCE_EXPERIMENT = 1;
        public static final int SOURCE_FILE = 2;
        public static final int SOURCE_BOTH = 3;
        private int source = 1;
        private double oldWeight = 0.0;
        private boolean updated = false;

        public State(int source, double oldWeight) {
            this.source = source;
            this.oldWeight = oldWeight;
        }

        public int getSource() {
            return this.source;
        }

        public void setSource(int source) {
            this.source = source;
        }

        public boolean isUpdated() {
            return this.updated;
        }

        public void setUpdated(boolean updated) {
            this.updated = updated;
        }

        public double getOldWeight() {
            return this.oldWeight;
        }
    }
}

