/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.gui.AttributeEditor;
import edu.udo.cs.yale.gui.DataControl;
import edu.udo.cs.yale.gui.SwingTools;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class AttributeEditorDialog
extends JDialog {
    private AttributeEditor attributeEditor;
    public final Action OPEN_ATTRIBUTE_FILE_ACTION = new OpenAttributeFileAction();
    public final Action SAVE_ATTRIBUTE_FILE_ACTION = new SaveAttributeFileAction();
    public final Action LOAD_DATA_ACTION = new LoadDataAction();
    public final Action LOAD_SERIES_DATA_ACTION = new LoadSeriesDataAction();
    public final Action SAVE_DATA_ACTION = new SaveDataAction();
    public final Action CLEAR_ACTION = new ClearAction();

    public AttributeEditorDialog(JFrame owner, Operator exampleSource, File file) {
        this(owner, exampleSource);
        if (file != null) {
            this.attributeEditor.openAttributeFile(file);
        }
    }

    public AttributeEditorDialog(JFrame owner, Operator exampleSource) {
        super(owner, "Attribute Editor", true);
        DataControl control = new DataControl(0, 0, "Example", "Attribute", false);
        this.attributeEditor = new AttributeEditor(exampleSource, control);
        control.addViewChangeListener(this.attributeEditor);
        this.getContentPane().add((Component)control, "West");
        this.getContentPane().add((Component)new JScrollPane(this.attributeEditor), "Center");
        control.update();
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(this.OPEN_ATTRIBUTE_FILE_ACTION);
        fileMenu.add(this.SAVE_ATTRIBUTE_FILE_ACTION);
        fileMenu.add(this.LOAD_DATA_ACTION);
        fileMenu.add(this.LOAD_SERIES_DATA_ACTION);
        fileMenu.add(this.SAVE_DATA_ACTION);
        menuBar.add(fileMenu);
        JMenu tableMenu = new JMenu("Table");
        tableMenu.add(this.attributeEditor.GUESS_TYPE_ACTION);
        tableMenu.add(this.attributeEditor.REMOVE_COLUMN_ACTION);
        tableMenu.add(this.attributeEditor.REMOVE_ROW_ACTION);
        tableMenu.add(this.CLEAR_ACTION);
        menuBar.add(tableMenu);
        this.setJMenuBar(menuBar);
        JToolBar toolBar = new JToolBar();
        toolBar.setRollover(true);
        toolBar.removeNotify();
        toolBar.add(this.OPEN_ATTRIBUTE_FILE_ACTION);
        toolBar.add(this.SAVE_ATTRIBUTE_FILE_ACTION);
        toolBar.add(this.LOAD_DATA_ACTION);
        toolBar.add(this.SAVE_DATA_ACTION);
        toolBar.addSeparator();
        toolBar.add(this.CLEAR_ACTION);
        this.getContentPane().add((Component)toolBar, "North");
        this.setSize((int)Math.max(600.0, (double)owner.getWidth() * 2.0 / 3.0), (int)Math.max(400.0, (double)owner.getHeight() * 2.0 / 3.0));
        this.setLocationRelativeTo(owner);
    }

    private void loadData(int type) {
        File file = SwingTools.chooseFile(this, null, true);
        if (file != null) {
            try {
                this.attributeEditor.readData(file, type);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.toString(), "Error loading " + file, 0);
            }
        }
    }

    private void saveAttributes() {
        this.attributeEditor.saveAttributeFile();
    }

    private void saveData() {
        File file = SwingTools.chooseFile(this, null, false);
        if (file != null) {
            try {
                this.attributeEditor.writeData(file);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.toString(), "Error saving data file " + file, 0);
            }
        }
    }

    private void clear() {
        this.attributeEditor.clear();
    }

    public File getFile() {
        return this.attributeEditor.getFile();
    }

    private class ClearAction
    extends AbstractAction {
        private ClearAction() {
            super("Clear", new ImageIcon(Tools.getResource("icons/icon_new.gif")));
            this.putValue("ShortDescription", "Clear the table.");
            this.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent e) {
            AttributeEditorDialog.this.clear();
        }
    }

    private class SaveDataAction
    extends AbstractAction {
        private SaveDataAction() {
            super("Save data as...", new ImageIcon(Tools.getResource("icons/icon_save_data.gif")));
            this.putValue("ShortDescription", "Save the contents of the table to a single data file.");
            this.putValue("MnemonicKey", new Integer(86));
        }

        public void actionPerformed(ActionEvent e) {
            AttributeEditorDialog.this.saveData();
        }
    }

    private class LoadSeriesDataAction
    extends AbstractAction {
        private LoadSeriesDataAction() {
            super("Load series data...", new ImageIcon(Tools.getResource("icons/icon_load_series_data.gif")));
            this.putValue("ShortDescription", "Open series data file and append additional value series columns to table.");
            this.putValue("MnemonicKey", new Integer(69));
        }

        public void actionPerformed(ActionEvent e) {
            AttributeEditorDialog.this.loadData(1);
        }
    }

    private class LoadDataAction
    extends AbstractAction {
        private LoadDataAction() {
            super("Load data...", new ImageIcon(Tools.getResource("icons/icon_load_data.gif")));
            this.putValue("ShortDescription", "Open data file and append additional columns to table.");
            this.putValue("MnemonicKey", new Integer(68));
        }

        public void actionPerformed(ActionEvent e) {
            AttributeEditorDialog.this.loadData(0);
        }
    }

    private class SaveAttributeFileAction
    extends AbstractAction {
        private SaveAttributeFileAction() {
            super("Save attribute description file...", new ImageIcon(Tools.getResource("icons/icon_save_xml.gif")));
            this.putValue("ShortDescription", "Save current attribute meta data descriptions into an XML file.");
            this.putValue("MnemonicKey", new Integer(83));
        }

        public void actionPerformed(ActionEvent e) {
            AttributeEditorDialog.this.saveAttributes();
        }
    }

    private class OpenAttributeFileAction
    extends AbstractAction {
        private OpenAttributeFileAction() {
            super("Open attribute description file...", new ImageIcon(Tools.getResource("icons/icon_open_xml.gif")));
            this.putValue("ShortDescription", "Open an existing XML attribute description file.");
            this.putValue("MnemonicKey", new Integer(79));
        }

        public void actionPerformed(ActionEvent e) {
            AttributeEditorDialog.this.attributeEditor.openAttributeFile();
        }
    }
}

