/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.generator;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.generator.ConstantGenerator;
import edu.udo.cs.yale.generator.GenerationException;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class FeatureGenerator {
    private static final String[] FUNCTION_NAMES = new String[]{"+", "-", "*", "/", "1/", "norm", "sin", "cos", "tan", "atan", "exp", "log", "min", "max", "floor", "ceil", "round", "sqrt", "abs", "pow"};
    private static final Class[] GENERATOR_CLASSES = new Class[]{class$edu$udo$cs$yale$generator$BasicArithmeticOperationGenerator == null ? (class$edu$udo$cs$yale$generator$BasicArithmeticOperationGenerator = FeatureGenerator.class$("edu.udo.cs.yale.generator.BasicArithmeticOperationGenerator")) : class$edu$udo$cs$yale$generator$BasicArithmeticOperationGenerator, class$edu$udo$cs$yale$generator$BasicArithmeticOperationGenerator == null ? (class$edu$udo$cs$yale$generator$BasicArithmeticOperationGenerator = FeatureGenerator.class$("edu.udo.cs.yale.generator.BasicArithmeticOperationGenerator")) : class$edu$udo$cs$yale$generator$BasicArithmeticOperationGenerator, class$edu$udo$cs$yale$generator$BasicArithmeticOperationGenerator == null ? (class$edu$udo$cs$yale$generator$BasicArithmeticOperationGenerator = FeatureGenerator.class$("edu.udo.cs.yale.generator.BasicArithmeticOperationGenerator")) : class$edu$udo$cs$yale$generator$BasicArithmeticOperationGenerator, class$edu$udo$cs$yale$generator$BasicArithmeticOperationGenerator == null ? (class$edu$udo$cs$yale$generator$BasicArithmeticOperationGenerator = FeatureGenerator.class$("edu.udo.cs.yale.generator.BasicArithmeticOperationGenerator")) : class$edu$udo$cs$yale$generator$BasicArithmeticOperationGenerator, class$edu$udo$cs$yale$generator$ReciprocalValueGenerator == null ? (class$edu$udo$cs$yale$generator$ReciprocalValueGenerator = FeatureGenerator.class$("edu.udo.cs.yale.generator.ReciprocalValueGenerator")) : class$edu$udo$cs$yale$generator$ReciprocalValueGenerator, class$edu$udo$cs$yale$generator$NormalizationGenerator == null ? (class$edu$udo$cs$yale$generator$NormalizationGenerator = FeatureGenerator.class$("edu.udo.cs.yale.generator.NormalizationGenerator")) : class$edu$udo$cs$yale$generator$NormalizationGenerator, class$edu$udo$cs$yale$generator$TrigonometricFunctionGenerator == null ? (class$edu$udo$cs$yale$generator$TrigonometricFunctionGenerator = FeatureGenerator.class$("edu.udo.cs.yale.generator.TrigonometricFunctionGenerator")) : class$edu$udo$cs$yale$generator$TrigonometricFunctionGenerator, class$edu$udo$cs$yale$generator$TrigonometricFunctionGenerator == null ? (class$edu$udo$cs$yale$generator$TrigonometricFunctionGenerator = FeatureGenerator.class$("edu.udo.cs.yale.generator.TrigonometricFunctionGenerator")) : class$edu$udo$cs$yale$generator$TrigonometricFunctionGenerator, class$edu$udo$cs$yale$generator$TrigonometricFunctionGenerator == null ? (class$edu$udo$cs$yale$generator$TrigonometricFunctionGenerator = FeatureGenerator.class$("edu.udo.cs.yale.generator.TrigonometricFunctionGenerator")) : class$edu$udo$cs$yale$generator$TrigonometricFunctionGenerator, class$edu$udo$cs$yale$generator$TrigonometricFunctionGenerator == null ? (class$edu$udo$cs$yale$generator$TrigonometricFunctionGenerator = FeatureGenerator.class$("edu.udo.cs.yale.generator.TrigonometricFunctionGenerator")) : class$edu$udo$cs$yale$generator$TrigonometricFunctionGenerator, class$edu$udo$cs$yale$generator$ExponentialFunctionGenerator == null ? (class$edu$udo$cs$yale$generator$ExponentialFunctionGenerator = FeatureGenerator.class$("edu.udo.cs.yale.generator.ExponentialFunctionGenerator")) : class$edu$udo$cs$yale$generator$ExponentialFunctionGenerator, class$edu$udo$cs$yale$generator$ExponentialFunctionGenerator == null ? (class$edu$udo$cs$yale$generator$ExponentialFunctionGenerator = FeatureGenerator.class$("edu.udo.cs.yale.generator.ExponentialFunctionGenerator")) : class$edu$udo$cs$yale$generator$ExponentialFunctionGenerator, class$edu$udo$cs$yale$generator$MinMaxGenerator == null ? (class$edu$udo$cs$yale$generator$MinMaxGenerator = FeatureGenerator.class$("edu.udo.cs.yale.generator.MinMaxGenerator")) : class$edu$udo$cs$yale$generator$MinMaxGenerator, class$edu$udo$cs$yale$generator$MinMaxGenerator == null ? (class$edu$udo$cs$yale$generator$MinMaxGenerator = FeatureGenerator.class$("edu.udo.cs.yale.generator.MinMaxGenerator")) : class$edu$udo$cs$yale$generator$MinMaxGenerator, class$edu$udo$cs$yale$generator$FloorCeilGenerator == null ? (class$edu$udo$cs$yale$generator$FloorCeilGenerator = FeatureGenerator.class$("edu.udo.cs.yale.generator.FloorCeilGenerator")) : class$edu$udo$cs$yale$generator$FloorCeilGenerator, class$edu$udo$cs$yale$generator$FloorCeilGenerator == null ? (class$edu$udo$cs$yale$generator$FloorCeilGenerator = FeatureGenerator.class$("edu.udo.cs.yale.generator.FloorCeilGenerator")) : class$edu$udo$cs$yale$generator$FloorCeilGenerator, class$edu$udo$cs$yale$generator$FloorCeilGenerator == null ? (class$edu$udo$cs$yale$generator$FloorCeilGenerator = FeatureGenerator.class$("edu.udo.cs.yale.generator.FloorCeilGenerator")) : class$edu$udo$cs$yale$generator$FloorCeilGenerator, class$edu$udo$cs$yale$generator$SquareRootGenerator == null ? (class$edu$udo$cs$yale$generator$SquareRootGenerator = FeatureGenerator.class$("edu.udo.cs.yale.generator.SquareRootGenerator")) : class$edu$udo$cs$yale$generator$SquareRootGenerator, class$edu$udo$cs$yale$generator$AbsoluteValueGenerator == null ? (class$edu$udo$cs$yale$generator$AbsoluteValueGenerator = FeatureGenerator.class$("edu.udo.cs.yale.generator.AbsoluteValueGenerator")) : class$edu$udo$cs$yale$generator$AbsoluteValueGenerator, class$edu$udo$cs$yale$generator$PowerGenerator == null ? (class$edu$udo$cs$yale$generator$PowerGenerator = FeatureGenerator.class$("edu.udo.cs.yale.generator.PowerGenerator")) : class$edu$udo$cs$yale$generator$PowerGenerator};
    private static Map generatorMap = new Hashtable();
    public static int SELECTION_MODE_ALL;
    public static int SELECTION_MODE_RESTRICTIVE;
    private static int selectionMode;
    protected Attribute[] resultAttributes;
    private Attribute[] arguments = null;
    private ExampleTable exampleTable;
    static /* synthetic */ Class class$edu$udo$cs$yale$generator$BasicArithmeticOperationGenerator;
    static /* synthetic */ Class class$edu$udo$cs$yale$generator$ReciprocalValueGenerator;
    static /* synthetic */ Class class$edu$udo$cs$yale$generator$NormalizationGenerator;
    static /* synthetic */ Class class$edu$udo$cs$yale$generator$TrigonometricFunctionGenerator;
    static /* synthetic */ Class class$edu$udo$cs$yale$generator$ExponentialFunctionGenerator;
    static /* synthetic */ Class class$edu$udo$cs$yale$generator$MinMaxGenerator;
    static /* synthetic */ Class class$edu$udo$cs$yale$generator$FloorCeilGenerator;
    static /* synthetic */ Class class$edu$udo$cs$yale$generator$SquareRootGenerator;
    static /* synthetic */ Class class$edu$udo$cs$yale$generator$AbsoluteValueGenerator;
    static /* synthetic */ Class class$edu$udo$cs$yale$generator$PowerGenerator;

    public abstract void generate(DataRow var1) throws GenerationException;

    public abstract Attribute[] getInputAttributes();

    public abstract Attribute[] getOutputAttributes(ExampleTable var1);

    public abstract FeatureGenerator newInstance();

    public abstract void setFunction(String var1);

    public abstract String getFunction();

    public abstract List getInputCandidates(ExampleSet var1, int var2, String[] var3);

    protected boolean checkCompatibility(Attribute attribute, Attribute compatible, int maxDepth, String[] functions) {
        if (attribute.compatible(compatible) && (maxDepth == -1 || attribute.getConstructionDepth() <= maxDepth)) {
            for (int f = 0; f < functions.length; ++f) {
                if (attribute.getConstructionDescription().indexOf(functions[f]) == -1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void setExampleTable(ExampleTable et) {
        this.exampleTable = et;
    }

    protected ExampleTable getExampleTable() {
        return this.exampleTable;
    }

    public void setArguments(Attribute[] args) {
        this.arguments = args;
    }

    public boolean argumentsSet() {
        return this.getInputAttributes().length == 0 || this.arguments != null;
    }

    public Attribute getArgument(int i) {
        return this.arguments[i];
    }

    private boolean argumentsOk(ExampleTable input) {
        Attribute[] inputA = this.getInputAttributes();
        for (int i = 0; i < inputA.length; ++i) {
            if (this.arguments[i].compatible(inputA[i])) continue;
            return false;
        }
        return true;
    }

    public static FeatureGenerator createGeneratorForFunction(String functionName) {
        Class genClass = (Class)generatorMap.get(functionName);
        if (genClass == null) {
            if (functionName.startsWith("const")) {
                ConstantGenerator gen = new ConstantGenerator();
                ((FeatureGenerator)gen).setFunction(functionName);
                return gen;
            }
            LogService.logMessage("Unknown feature generator: '" + functionName + "'", 6);
            return null;
        }
        try {
            FeatureGenerator gen = (FeatureGenerator)genClass.newInstance();
            gen.setFunction(functionName);
            return gen;
        }
        catch (Exception e) {
            LogService.logMessage("Cannot instanciate '" + genClass.getName() + "'", 6);
            return null;
        }
    }

    public static FeatureGenerator selectGenerator(ExampleSet exampleSet, List generators, int maxDepth, String[] functions) {
        int combinationSum = 0;
        Iterator i = generators.iterator();
        double[] probs = new double[generators.size()];
        int k = 0;
        while (i.hasNext()) {
            FeatureGenerator generator = (FeatureGenerator)i.next();
            probs[k] = generator.getInputCandidates(exampleSet, maxDepth, functions).size();
            combinationSum = (int)((double)combinationSum + probs[k]);
            ++k;
        }
        if (combinationSum == 0) {
            return null;
        }
        k = 0;
        while (k < probs.length) {
            int n = k++;
            probs[n] = probs[n] / (double)combinationSum;
        }
        RandomGenerator.getGlobalRandomGenerator();
        int index = RandomGenerator.randomIndex(probs);
        FeatureGenerator selected = (FeatureGenerator)generators.get(index);
        return selected;
    }

    public static List generateAll(ExampleTable exampleTable, Collection generatorList) throws GenerationException {
        LogService.logMessage("Starting feature generation with " + generatorList.size() + " generators.", 2);
        Iterator gi = generatorList.iterator();
        while (gi.hasNext()) {
            ((FeatureGenerator)gi.next()).setExampleTable(exampleTable);
        }
        FeatureGenerator[] generators = new FeatureGenerator[generatorList.size()];
        generatorList.toArray(generators);
        List newAttributeList = FeatureGenerator.newAttributes(generators, exampleTable);
        exampleTable.addAttributes(newAttributeList);
        LogService.logMessage("Generator list: " + generatorList, 2);
        LogService.logMessage("Input set has " + exampleTable.getAttributeCount() + " features, " + exampleTable.getSize() + " examples.", 2);
        DataRowReader reader = exampleTable.getDataReader();
        while (reader.hasNext()) {
            DataRow dataRow = reader.next();
            for (int j = 0; j < generators.length; ++j) {
                generators[j].generate(dataRow);
            }
        }
        LogService.logMessage("Finished feature generation.", 2);
        LogService.logMessage("Generated set has " + exampleTable.getAttributeCount() + " features, " + exampleTable.getSize() + " examples.", 2);
        return newAttributeList;
    }

    private static List newAttributes(FeatureGenerator[] generators, ExampleTable exampleTable) {
        LinkedList<Attribute> newAttributeList = new LinkedList<Attribute>();
        for (int i = 0; i < generators.length; ++i) {
            Attribute[] outputAttribute = generators[i].getOutputAttributes(exampleTable);
            generators[i].resultAttributes = new Attribute[outputAttribute.length];
            for (int j = 0; j < outputAttribute.length; ++j) {
                Attribute newAttribute = exampleTable.getAttribute(outputAttribute[j]);
                if (newAttribute == null) {
                    newAttributeList.add(outputAttribute[j]);
                    generators[i].resultAttributes[j] = outputAttribute[j];
                    continue;
                }
                newAttributeList.add(newAttribute);
                generators[i].resultAttributes[j] = newAttribute;
                LogService.logMessage("Attribute '" + outputAttribute[j].getConstructionDescription() + "' already generated", 4);
            }
            if (!generators[i].argumentsSet()) {
                throw new RuntimeException("Catastrophic error: arguments not set for " + generators[i] + "!");
            }
            if (generators[i].argumentsOk(exampleTable)) continue;
            LogService.logMessage("Wrong argument types for " + generators[i] + ".", 4);
        }
        return newAttributeList;
    }

    public static int getSelectionMode() {
        return selectionMode;
    }

    public static void setSelectionMode(int mode) {
        selectionMode = mode;
    }

    public String toString() {
        return "FeatureGenerator (" + this.getClass().getName() + ")";
    }

    public boolean equals(Object o) {
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        FeatureGenerator fg = (FeatureGenerator)o;
        if (!this.getFunction().equals(fg.getFunction())) {
            return false;
        }
        if (this.arguments.length != fg.arguments.length) {
            return false;
        }
        for (int i = 0; i < this.arguments.length; ++i) {
            if (((Object)this.arguments[i]).equals(fg.arguments[i])) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        for (int i = 0; i < FUNCTION_NAMES.length; ++i) {
            generatorMap.put(FUNCTION_NAMES[i], GENERATOR_CLASSES[i]);
        }
        SELECTION_MODE_ALL = 0;
        SELECTION_MODE_RESTRICTIVE = 1;
        selectionMode = SELECTION_MODE_ALL;
    }
}

