/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.generator;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.GenerationException;
import java.util.ArrayList;
import java.util.List;

public class ConstantGenerator
extends FeatureGenerator {
    public static final String FUNCTION_NAME = "const";
    private double constant = 1.0;
    private String constantString = "1";

    public ConstantGenerator() {
    }

    public ConstantGenerator(double constant) {
        this.constant = constant;
        this.constantString = constant + "";
    }

    public void setArguments(Attribute[] args) {
    }

    public FeatureGenerator newInstance() {
        return new ConstantGenerator();
    }

    public String getFunction() {
        return "const[" + this.constantString + "]";
    }

    public void setFunction(String functionName) {
        int leftIndex = functionName.indexOf("[");
        int rightIndex = functionName.indexOf("]");
        if (leftIndex != -1 && rightIndex != -1) {
            this.constantString = functionName.substring(leftIndex + 1, rightIndex);
            this.constant = Double.parseDouble(this.constantString);
        }
    }

    public Attribute[] getInputAttributes() {
        return new Attribute[0];
    }

    public Attribute[] getOutputAttributes(ExampleTable input) {
        Attribute ao = AttributeFactory.createAttribute(2, 3, -1, this.getFunction(), new Attribute[0], null);
        return new Attribute[]{ao};
    }

    public List getInputCandidates(ExampleSet exampleSet, int maxDepth, String[] functions) {
        return new ArrayList();
    }

    public void generate(DataRow data) throws GenerationException {
        try {
            if (this.resultAttributes[0] != null) {
                data.set(this.resultAttributes[0], this.constant);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new GenerationException("a:" + this.getArgument(0), ex);
        }
    }

    public String toString() {
        return this.getFunction();
    }
}

