/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractExampleSet;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowReader;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.example.SimpleExampleReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SimpleExampleSet
extends AbstractExampleSet {
    private ArrayList attributes = new ArrayList();
    private Map userDataMap = new HashMap();
    private Map specialAttributeMap = new HashMap();
    private ExampleTable exampleTable;
    private Map idMap = new HashMap();

    public SimpleExampleSet(SimpleExampleSet exampleSet) {
        super(exampleSet);
        this.exampleTable = exampleSet.exampleTable;
        this.specialAttributeMap.putAll(exampleSet.specialAttributeMap);
        this.attributes.addAll(exampleSet.attributes);
        this.userDataMap.putAll(exampleSet.userDataMap);
        this.idMap.putAll(exampleSet.idMap);
    }

    public SimpleExampleSet(ExampleTable exampleTable, Collection regularAttributes) {
        this.exampleTable = exampleTable;
        this.addAllAttributes(regularAttributes);
        this.remapAllIds();
    }

    public SimpleExampleSet(ExampleTable exampleTable, Attribute label, Attribute predictedLabel, Attribute weight, Attribute idAttribute) {
        this.exampleTable = exampleTable;
        this.setLabel(label);
        this.setPredictedLabel(predictedLabel);
        this.setWeight(weight);
        this.setId(idAttribute);
        this.addRegularAttributesFromExampleTable(exampleTable);
        this.remapAllIds();
    }

    public SimpleExampleSet(ExampleTable exampleTable, Map specialAttributes) {
        this.exampleTable = exampleTable;
        Iterator i = specialAttributes.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            this.setSpecialAttribute(name, (Attribute)specialAttributes.get(name));
        }
        this.addRegularAttributesFromExampleTable(exampleTable);
        this.remapAllIds();
    }

    private void addRegularAttributesFromExampleTable(ExampleTable exampleTable) {
        for (int i = 0; i < exampleTable.getNumberOfAttributes(); ++i) {
            Attribute attribute = exampleTable.getAttribute(i);
            if (this.isSpecialAttribute(attribute)) continue;
            this.addAttribute(attribute);
        }
    }

    public boolean isSpecialAttribute(Attribute attribute) {
        Iterator i = this.specialAttributeMap.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (((Attribute)this.specialAttributeMap.get(name)).getTableIndex() != attribute.getTableIndex()) continue;
            return true;
        }
        return false;
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
        this.clearUserData();
    }

    public void removeAttribute(Attribute attribute) {
        Attribute candidate;
        boolean removed = false;
        Iterator<Object> i = this.attributes.iterator();
        while (i.hasNext() && !removed) {
            candidate = (Attribute)i.next();
            if (candidate.getTableIndex() != attribute.getTableIndex()) continue;
            i.remove();
            removed = true;
        }
        if (!removed) {
            i = this.specialAttributeMap.keySet().iterator();
            while (i.hasNext()) {
                candidate = (Attribute)this.specialAttributeMap.get(i.next());
                if (candidate.getTableIndex() != attribute.getTableIndex()) continue;
                i.remove();
                removed = true;
                break;
            }
        }
        if (!removed) {
            throw new NoSuchElementException("Attribute " + attribute.getName() + " is not in example set.");
        }
        this.clearUserData();
    }

    public Attribute replaceAttribute(Attribute first, Attribute second) {
        boolean replaced = false;
        int index = this.attributes.indexOf(first);
        if (index >= 0) {
            this.attributes.set(index, second);
            replaced = true;
        }
        if (!replaced) {
            String key = null;
            Iterator i = this.specialAttributeMap.keySet().iterator();
            while (i.hasNext()) {
                key = (String)i.next();
                Attribute candidate = (Attribute)this.specialAttributeMap.get(key);
                if (!((Object)candidate).equals(first)) continue;
                i.remove();
                replaced = true;
                break;
            }
            if (replaced) {
                this.setSpecialAttribute(key, second);
            }
        }
        if (!replaced) {
            throw new NoSuchElementException("Attribute " + first + " cannot be replaced by attribute " + second + ": " + first + " is not part of the example set!");
        }
        return second;
    }

    public ExampleReader getExampleReader() {
        return new SimpleExampleReader(this.getExampleTable().getDataReader(), this);
    }

    public ExampleTable getExampleTable() {
        return this.exampleTable;
    }

    public int getNumberOfAttributes() {
        return this.attributes.size();
    }

    public Attribute getAttribute(int index) {
        return (Attribute)this.attributes.get(index);
    }

    public Attribute getAttribute(String name) {
        Attribute attribute = null;
        Iterator i = this.attributes.iterator();
        while (i.hasNext()) {
            Attribute current = (Attribute)i.next();
            if (!current.getName().equals(name)) continue;
            attribute = current;
            break;
        }
        if (attribute == null) {
            attribute = (Attribute)this.specialAttributeMap.get(name);
        }
        return attribute;
    }

    public void setSpecialAttribute(String name, Attribute attribute) {
        if (attribute != null) {
            this.specialAttributeMap.put(name, attribute);
        } else {
            this.specialAttributeMap.remove(name);
        }
    }

    public Collection getSpecialAttributeNames() {
        return this.specialAttributeMap.keySet();
    }

    public Map getSpecialAttributes() {
        return this.specialAttributeMap;
    }

    public int getSize() {
        return this.exampleTable.getSize();
    }

    public Example getExample(int index) {
        return this.createExample(this.exampleTable.getDataRow(index));
    }

    public Example getExampleFromId(double id) {
        return this.createExample(this.getDataRowFromId(id));
    }

    private Example createExample(DataRow dataRow) {
        if (dataRow == null) {
            return null;
        }
        Attribute[] selectedAttributes = new Attribute[this.getNumberOfAttributes()];
        this.attributes.toArray(selectedAttributes);
        return new Example(dataRow, selectedAttributes, this.specialAttributeMap);
    }

    private DataRow getDataRowFromId(double id) {
        Integer indexObject = (Integer)this.idMap.get(new Double(id));
        if (indexObject != null) {
            return this.exampleTable.getDataRow(indexObject);
        }
        return null;
    }

    public void remapAllIds() {
        this.idMap.clear();
        Attribute idAttribute = this.getId();
        if (idAttribute != null) {
            DataRowReader reader = this.exampleTable.getDataReader();
            int index = 0;
            while (reader.hasNext()) {
                DataRow dataRow = reader.next();
                this.idMap.put(new Double(dataRow.get(idAttribute)), new Integer(index));
                ++index;
            }
        }
    }

    public void clearUserData() {
        this.userDataMap.clear();
    }

    public void setUserData(String key, Object data) {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null!");
        }
        this.userDataMap.put(key, data);
    }

    public Object getUserData(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null!");
        }
        Object data = this.userDataMap.get(key);
        return data;
    }

    public Set getUserDataKeys() {
        return this.userDataMap.keySet();
    }
}

