/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowReader;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.example.ListDataRowReader;
import edu.udo.cs.yale.example.SparseArrayDataRow;
import edu.udo.cs.yale.example.SparseMapDataRow;
import edu.udo.cs.yale.tools.LogService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MemoryExampleTable
extends ExampleTable {
    private ArrayList dataList = new ArrayList();
    private int columns;
    private static final int INCREMENT = 10;

    public MemoryExampleTable(List attributes) {
        super(attributes);
        this.columns = attributes.size();
    }

    public MemoryExampleTable(List attributes, int size) {
        this(attributes);
        this.dataList = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            double[] row = new double[this.columns];
            for (int j = 0; j < row.length; ++j) {
                row[j] = Double.NaN;
            }
            this.dataList.add(new DoubleArrayDataRow(row));
        }
    }

    public MemoryExampleTable(List attributes, DataRowReader i) {
        this(attributes);
        this.readExamples(i);
    }

    public void readExamples(DataRowReader i) {
        this.dataList.clear();
        boolean first = true;
        int numberOfAttributes = this.getNumberOfAttributes();
        while (i.hasNext()) {
            DataRow row = i.next();
            if (first && (row instanceof SparseMapDataRow || row instanceof SparseArrayDataRow)) {
                this.setSparse(true);
            }
            first = false;
            this.dataList.add(row);
        }
    }

    public DataRowReader getDataReader() {
        return new ListDataRowReader(this.dataList.iterator());
    }

    public DataRow getDataRow(int index) {
        return (DataRow)this.dataList.get(index);
    }

    public int getSize() {
        return this.dataList.size();
    }

    public void addDataRow(DataRow dataRow) {
        this.dataList.add(dataRow);
    }

    public int addAttribute(Attribute attribute) {
        int index = super.addAttribute(attribute);
        if (this.dataList == null) {
            return index;
        }
        int n = this.getNumberOfAttributes();
        if (n <= this.columns) {
            return index;
        }
        int newSize = n + 10;
        LogService.logMessage("Resizing example table from " + this.columns + " to " + newSize + " columns.", 2);
        this.columns = newSize;
        if (this.dataList != null) {
            Iterator i = this.dataList.iterator();
            while (i.hasNext()) {
                ((DataRow)i.next()).ensureNumberOfColumns(this.columns);
            }
        }
        return index;
    }
}

