/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractDataRowReader;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.YaleLineReader;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.att.AttributeDataSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FileDataRowReader
extends AbstractDataRowReader {
    private static final int FILE_NR = 0;
    private static final int COLUMN_NR = 1;
    private BufferedReader[] fileReader;
    private Attribute[] attributes;
    private boolean eof;
    private boolean lineRead;
    private int maxNumber;
    private int linesRead = 0;
    private String[][] currentData;
    private int[] expectedNumberOfColumns;
    private YaleLineReader yaleLineReader;
    private int[][] dataSourceIndex;

    public FileDataRowReader(DataRowFactory factory, List attributeDataSources, int sampleSize, String separatorsRegExpr, char[] commentChars, boolean useQuotes) throws IOException {
        super(factory);
        this.maxNumber = sampleSize;
        this.attributes = new Attribute[attributeDataSources.size()];
        this.dataSourceIndex = new int[attributeDataSources.size()][2];
        this.yaleLineReader = new YaleLineReader(separatorsRegExpr, commentChars, useQuotes);
        LinkedList<BufferedReader> readerList = new LinkedList<BufferedReader>();
        HashMap<File, Integer> fileMap = new HashMap<File, Integer>();
        Iterator i = attributeDataSources.iterator();
        int attribute = 0;
        int greatestFileIndex = -1;
        ArrayList<Integer> columnCounters = new ArrayList<Integer>();
        while (i.hasNext()) {
            AttributeDataSource ads = (AttributeDataSource)i.next();
            this.attributes[attribute] = ads.getAttribute();
            File file = ads.getFile();
            Integer fileIndex = (Integer)fileMap.get(file);
            if (fileIndex == null) {
                fileIndex = new Integer(++greatestFileIndex);
                fileMap.put(file, fileIndex);
                readerList.add(new BufferedReader(new FileReader(file)));
                columnCounters.add(new Integer(1));
            } else {
                Integer counter = (Integer)columnCounters.get(fileIndex);
                columnCounters.set(fileIndex, new Integer(counter + 1));
            }
            this.dataSourceIndex[attribute][0] = fileIndex;
            this.dataSourceIndex[attribute][1] = ads.getColumn();
            ++attribute;
        }
        this.fileReader = new BufferedReader[readerList.size()];
        readerList.toArray(this.fileReader);
        this.currentData = new String[this.fileReader.length][];
        this.expectedNumberOfColumns = new int[columnCounters.size()];
        Iterator j = columnCounters.iterator();
        int k = 0;
        while (j.hasNext()) {
            this.expectedNumberOfColumns[k++] = (Integer)j.next();
        }
    }

    private boolean readLine() throws IOException {
        int i;
        boolean eofReached = false;
        for (i = 0; i < this.fileReader.length; ++i) {
            this.currentData[i] = this.yaleLineReader.readLine(this.fileReader[i], this.expectedNumberOfColumns[i]);
            if (this.currentData[i] != null) continue;
            eofReached = true;
            break;
        }
        if (eofReached) {
            for (i = 0; i < this.fileReader.length; ++i) {
                this.fileReader[i].close();
            }
            return false;
        }
        return true;
    }

    public boolean hasNext() {
        if (this.maxNumber > -1 && this.linesRead >= this.maxNumber) {
            return false;
        }
        if (this.lineRead) {
            return !this.eof;
        }
        try {
            this.eof = !this.readLine();
        }
        catch (IOException e) {
            LogService.logMessage(e.getMessage(), 6);
            return false;
        }
        this.lineRead = true;
        return !this.eof;
    }

    public DataRow next() {
        if (this.eof) {
            return null;
        }
        if (!this.lineRead && !this.hasNext()) {
            return null;
        }
        String[] data = new String[this.attributes.length];
        for (int i = 0; i < this.attributes.length; ++i) {
            data[i] = this.dataSourceIndex[i][1] == -1 ? null : this.currentData[this.dataSourceIndex[i][0]][this.dataSourceIndex[i][1]];
        }
        DataRow dataRow = this.getFactory().create(data, this.attributes);
        ++this.linesRead;
        this.lineRead = false;
        return dataRow;
    }
}

