/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.SparseDataRow;
import java.util.Arrays;

public class FastExample2SparseTransform {
    private int[] mapping;

    public FastExample2SparseTransform(ExampleSet es) {
        this.mapping = new int[es.getExampleTable().getNumberOfAttributes()];
        Arrays.fill(this.mapping, -1);
        for (int pos = 0; pos < es.getNumberOfAttributes(); ++pos) {
            this.mapping[es.getAttribute((int)pos).getTableIndex()] = pos;
        }
    }

    public int[] getNonDefaultAttributeIndices(Example example) {
        int[] tempArray = new int[example.getNumberOfAttributes()];
        int numberNonDefaultAttributes = 0;
        DataRow data = example.getDataRow();
        if (data instanceof SparseDataRow) {
            int[] nonDefaultInd = ((SparseDataRow)((Object)data)).getNonDefaultIndices();
            Arrays.fill(tempArray, Integer.MAX_VALUE);
            for (int i = 0; i < nonDefaultInd.length; ++i) {
                int nextPos = this.mapping[nonDefaultInd[i]];
                if (nextPos == -1) continue;
                tempArray[numberNonDefaultAttributes++] = nextPos;
            }
            Arrays.sort(tempArray);
        } else {
            for (int i = 0; i < example.getNumberOfAttributes(); ++i) {
                double value;
                Attribute attribute = example.getAttribute(i);
                if (attribute.isDefault(value = example.getValue(attribute))) continue;
                tempArray[numberNonDefaultAttributes] = i;
                ++numberNonDefaultAttributes;
            }
        }
        int[] finalArray = new int[numberNonDefaultAttributes];
        System.arraycopy(tempArray, 0, finalArray, 0, numberNonDefaultAttributes);
        return finalArray;
    }

    public double[] getNonDefaultAttributeValues(Example example) {
        return this.getNonDefaultAttributeValues(example, this.getNonDefaultAttributeIndices(example));
    }

    public double[] getNonDefaultAttributeValues(Example example, int[] nonDefaultIndices) {
        double[] result = new double[nonDefaultIndices.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = example.getValue(nonDefaultIndices[i]);
        }
        return result;
    }
}

