/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ExampleFormatter {
    private FormatCommand[] formatCommands;

    public ExampleFormatter(FormatCommand[] formatCommands) {
        this.formatCommands = formatCommands;
    }

    public static ExampleFormatter compile(String formatString, ExampleSet exampleSet) {
        LinkedList commandList = new LinkedList();
        ExampleFormatter.compile(formatString, exampleSet, commandList);
        FormatCommand[] commands = new FormatCommand[commandList.size()];
        commandList.toArray(commands);
        return new ExampleFormatter(commands);
    }

    private static void compile(String formatString, ExampleSet exampleSet, List commandList) {
        int start = 0;
        block3: while (true) {
            int tagStart;
            if ((tagStart = formatString.indexOf("$", start)) == -1) break;
            if (tagStart == formatString.length() - 1) {
                throw new IllegalArgumentException("Format string ends in '$'.");
            }
            commandList.add(new TextCommand(formatString.substring(start, tagStart)));
            char command = formatString.charAt(tagStart + 1);
            if (command == '$' || command == '[' || command == ']') {
                commandList.add(new TextCommand("" + command));
                start = tagStart + 2;
                continue;
            }
            if (command == 'n') {
                commandList.add(new TextCommand("\n"));
                start = tagStart + 2;
                continue;
            }
            if (command == 't') {
                commandList.add(new TextCommand("\t"));
                start = tagStart + 2;
                continue;
            }
            start = tagStart + 2;
            LinkedList<String> argumentList = new LinkedList<String>();
            while (start < formatString.length() && formatString.charAt(start) == '[') {
                int end = formatString.indexOf(93, start);
                if (end == -1) {
                    throw new IllegalArgumentException("Unclosed '['!");
                }
                argumentList.add(formatString.substring(start + 1, end));
                start = end + 1;
            }
            String[] arguments = new String[argumentList.size()];
            argumentList.toArray(arguments);
            switch (command) {
                case 'k': 
                case 'v': {
                    commandList.add(new ValueCommand(command, arguments, exampleSet));
                    continue block3;
                }
            }
            commandList.add(new SimpleCommand(command, arguments));
        }
        commandList.add(new TextCommand(formatString.substring(start)));
    }

    public String format(Example example) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < this.formatCommands.length; ++i) {
            str.append(this.formatCommands[i].format(example));
        }
        return str.toString();
    }

    public static class TextCommand
    implements FormatCommand {
        private String text;

        private TextCommand(String text) {
            this.text = text;
        }

        public String format(Example example) {
            return this.text;
        }
    }

    public static class ValueCommand
    implements FormatCommand {
        private Attribute attribute;

        public ValueCommand(char command, String[] arguments, ExampleSet exampleSet) {
            if (arguments.length < 1) {
                throw new IllegalArgumentException("Command 'v' needs argument!");
            }
            switch (command) {
                case 'v': {
                    this.attribute = exampleSet.getAttribute(arguments[0]);
                    if (this.attribute != null) break;
                    throw new IllegalArgumentException("Unknown attribute: '" + arguments[0] + "'!");
                }
                case 'k': {
                    try {
                        this.attribute = exampleSet.getAttribute(Integer.parseInt(arguments[0]));
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Argument for 'k' must be an integer!");
                    }
                    catch (Throwable e) {
                        throw new IllegalArgumentException("Illegal column: '" + arguments[0] + "'!");
                    }
                }
                default: {
                    throw new IllegalArgumentException("Illegal command for ValueCommand: '" + command + "'");
                }
            }
        }

        public String format(Example example) {
            return example.getValueAsString(this.attribute);
        }
    }

    public static class SimpleCommand
    implements FormatCommand {
        private char command;
        private String[] arguments;

        private SimpleCommand(char command, String[] arguments) {
            this.command = command;
            if (command != 'a' && command != 's' && command != 'l' && command != 'p' && command != 'd' && command != 'i' && command != 'w' && command != 'c' && command != 'b') {
                throw new IllegalArgumentException("Unknown command: '" + command + "'");
            }
            switch (command) {
                case 'a': {
                    if (arguments.length != 0) break;
                    arguments = new String[]{" "};
                    break;
                }
                case 's': {
                    if (arguments.length == 0) {
                        arguments = new String[]{" ", ":"};
                    }
                    if (arguments.length != 1) break;
                    arguments = new String[]{arguments[0], ":"};
                }
            }
            this.arguments = arguments;
        }

        public String format(Example example) {
            switch (this.command) {
                case 'a': {
                    return example.getAttributesAsString(this.arguments[0]);
                }
                case 's': {
                    return example.getAttributesAsSparseString(this.arguments[0], this.arguments[1]);
                }
                case 'l': {
                    return example.getValueAsString(example.getAttribute("label"));
                }
                case 'p': {
                    return example.getValueAsString(example.getAttribute("prediction"));
                }
                case 'i': {
                    return example.getValueAsString(example.getAttribute("id"));
                }
                case 'w': {
                    return example.getValueAsString(example.getAttribute("weight"));
                }
                case 'c': {
                    return example.getValueAsString(example.getAttribute("cluster"));
                }
                case 'b': {
                    return example.getValueAsString(example.getAttribute("batch"));
                }
                case 'd': {
                    if (this.arguments.length == 0) {
                        Iterator i = example.getAttribute("prediction").getValues().iterator();
                        StringBuffer result = new StringBuffer();
                        int index = 0;
                        while (i.hasNext()) {
                            String value = (String)i.next();
                            if (index != 0) {
                                result.append(" ");
                            }
                            result.append("conf(" + value + ")=" + example.getConfidence(value));
                            ++index;
                        }
                        return result.toString();
                    }
                    return example.getConfidence(this.arguments[0]) + "";
                }
            }
            return this.command + "";
        }
    }

    public static interface FormatCommand {
        public String format(Example var1);
    }
}

