/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractAttribute;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.NominalAttribute;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class BinaryAttribute
extends AbstractAttribute {
    protected static final int FIRST_VALUE_INDEX = 0;
    protected static final int SECOND_VALUE_INDEX = 1;
    private String firstValue = null;
    private String secondValue = null;
    private int firstCounter = 0;
    private int secondCounter = 0;
    private String mode = null;

    protected BinaryAttribute(String name) {
        super(name, 8);
    }

    public Object clone() {
        BinaryAttribute attribute = new BinaryAttribute(this.getName());
        attribute.copyProperties(this);
        return attribute;
    }

    public void copyProperties(Attribute attribute) {
        NominalAttribute a;
        int numberOfValues;
        super.copyProperties(attribute);
        if (attribute instanceof BinaryAttribute) {
            BinaryAttribute a2 = (BinaryAttribute)attribute;
            this.mode = a2.mode;
            this.firstValue = a2.firstValue;
            this.secondValue = a2.secondValue;
            this.firstCounter = a2.firstCounter;
            this.secondCounter = a2.secondCounter;
        } else if (attribute instanceof NominalAttribute && (numberOfValues = (a = (NominalAttribute)attribute).getNumberOfValues()) <= 2) {
            this.mode = a.getMode();
            if (numberOfValues == 2) {
                this.firstValue = a.mapIndex(0);
                this.secondValue = a.mapIndex(1);
            } else if (numberOfValues == 1) {
                this.firstValue = a.mapIndex(0);
            }
        }
    }

    public void writeAttributeData(DataOutput out) throws IOException {
        super.writeAttributeData(out);
        out.writeInt(this.getNumberOfValues());
        Iterator i = this.getValues().iterator();
        while (i.hasNext()) {
            out.writeUTF((String)i.next());
        }
    }

    public void readAttributeData(DataInput in) throws IOException {
        super.readAttributeData(in);
        int num = in.readInt();
        for (int i = 0; i < num; ++i) {
            this.mapString(in.readUTF());
        }
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public double getAverage() {
        this.throwNonNumericalException("average cannot be used");
        return Double.NaN;
    }

    public void setAverage(double a) {
        this.throwNonNumericalException("average cannot be used");
    }

    public double getVariance() {
        this.throwNonNumericalException("variance cannot be used");
        return Double.NaN;
    }

    public void setVariance(double v) {
        this.throwNonNumericalException("variance cannot be used");
    }

    public double getMaximum() {
        this.throwNonNumericalException("maximum cannot be used");
        return Double.NaN;
    }

    public void setMaximum(double v) {
        this.throwNonNumericalException("maximum cannot be used");
    }

    public double getMinimum() {
        this.throwNonNumericalException("minimum cannot be used");
        return Double.NaN;
    }

    public void setMinimum(double v) {
        this.throwNonNumericalException("minimum cannot be used");
    }

    public boolean isNominal() {
        return true;
    }

    public boolean isNumerical() {
        return false;
    }

    public boolean isBooleanClassification() {
        return this.getValues().size() == 2;
    }

    public void clearMaps() {
        this.firstValue = null;
        this.secondValue = null;
    }

    public int mapString(String str) {
        if (str == null) {
            return -1;
        }
        int index = this.getIndex(str);
        if (index < 0) {
            if (this.firstValue == null) {
                this.firstValue = str;
                return 0;
            }
            if (this.secondValue == null) {
                this.secondValue = str;
                return 1;
            }
            throw new RuntimeException("Cannot map another string for binary attribute: already mapped two strings!");
        }
        return index;
    }

    public int getIndex(String str) {
        if (str.equals(this.firstValue)) {
            return 0;
        }
        if (str.equals(this.secondValue)) {
            return 1;
        }
        return -1;
    }

    public String mapIndex(int index) {
        switch (index) {
            case 0: {
                return this.firstValue;
            }
            case 1: {
                return this.secondValue;
            }
        }
        throw new RuntimeException("Cannot map index of binary attribute to nominal value: index " + index + " is out of bounds!");
    }

    public void replaceValue(String oldValue, String newValue) {
        int index = this.mapString(oldValue);
        switch (index) {
            case 0: {
                this.firstValue = newValue;
                break;
            }
            case 1: {
                this.secondValue = newValue;
                break;
            }
            default: {
                throw new RuntimeException("Cannot map index for binary attribute: " + index);
            }
        }
    }

    public int getValueCount(String value) {
        int index = this.mapString(value);
        switch (index) {
            case 0: {
                return this.firstCounter;
            }
            case 1: {
                return this.secondCounter;
            }
        }
        return 0;
    }

    public void setIndexToCounterMap(int[] indexToCounterMap) {
        this.firstCounter = indexToCounterMap[0];
        this.secondCounter = indexToCounterMap[1];
    }

    public String getAsString(double value, int digits) {
        if (Double.isNaN(value)) {
            return "?";
        }
        return this.mapIndex((int)value);
    }

    public int getNegativeIndex() {
        return 0;
    }

    public int getPositiveIndex() {
        return 1;
    }

    public Collection getValues() {
        if (this.firstValue == null) {
            return new LinkedList();
        }
        if (this.secondValue == null) {
            return Arrays.asList(this.firstValue);
        }
        return Arrays.asList(this.firstValue, this.secondValue);
    }

    public int getNumberOfValues() {
        if (this.firstValue == null) {
            return 0;
        }
        if (this.secondValue == null) {
            return 1;
        }
        return 2;
    }

    public boolean isDefault(double value) {
        return value == 0.0;
    }

    public void sortNominalMappings() {
        if (this.getNumberOfValues() == 2 && this.firstValue.compareTo(this.secondValue) > 0) {
            String dummy = this.secondValue;
            this.secondValue = this.firstValue;
            this.firstValue = dummy;
        }
    }

    public String getRangeString() {
        StringBuffer str = new StringBuffer();
        str.append("mode = " + this.mode + "; ");
        Collection allValues = this.getValues();
        Iterator i = allValues.iterator();
        int n = 0;
        while (i.hasNext()) {
            if (n > 0) {
                str.append(", ");
            }
            ++n;
            String value = (String)i.next();
            str.append(value);
            str.append(" (" + this.getValueCount(value) + ")");
        }
        int unknownCounter = this.getUnknownCounter();
        if (unknownCounter > 0) {
            str.append("; unknown values = " + unknownCounter);
        }
        return str.toString();
    }

    private void throwNonNumericalException(String message) {
        throw new RuntimeException("Attribute " + this.toString() + " is not a numerical attribute: " + message);
    }

    private void ensureClassification() {
        if (!this.isBooleanClassification()) {
            throw new RuntimeException("Attribute " + this.toString() + " is not a classification attribute!");
        }
    }
}

