/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.tools.Ontology;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class AbstractAttribute
implements Attribute {
    protected static int HIGHEST_BLOCK_NUMBER = -1;
    private String name;
    private String generatingFunctionName;
    private Attribute[] generatingFunctionArguments;
    private boolean generatingFunctionInfix = false;
    private int blockNumber = -1;
    private int valueType = 0;
    private int blockType = 0;
    private int index = -1;
    private int[] unit;
    private int unknownCounter;

    protected AbstractAttribute(String name, int valueType) {
        this(name, valueType, 3, -1, name, null, false, null);
    }

    protected AbstractAttribute(String name, int valueType, int blockType, int blockNumber, String functionName, Attribute[] arguments, boolean infix, int[] units) {
        this.name = name;
        this.valueType = valueType;
        this.blockType = blockType;
        this.blockNumber = blockNumber;
        HIGHEST_BLOCK_NUMBER = Math.max(HIGHEST_BLOCK_NUMBER, blockNumber);
        this.index = -1;
        if (Ontology.ATTRIBUTE_BLOCK_TYPE.isA(blockType, 3) && blockNumber != -1) {
            throw new RuntimeException("Cannot create an attribute '" + this.name + "' with block type 'single value' and blocknumber '" + blockNumber + "'. Blocknumbers should only be used for attributes which are part of a series.");
        }
        this.unit = this.unit == null ? new int[Attribute.UNIT_NAMES.length] : this.unit;
        this.generatingFunctionName = functionName;
        this.generatingFunctionArguments = arguments;
        this.generatingFunctionInfix = infix && arguments != null && arguments.length == 2;
    }

    public abstract Object clone();

    public void copyProperties(Attribute attribute) {
        AbstractAttribute a = (AbstractAttribute)attribute;
        this.blockType = a.blockType;
        this.name = new String(a.name);
        this.blockNumber = a.blockNumber;
        HIGHEST_BLOCK_NUMBER = Math.max(HIGHEST_BLOCK_NUMBER, this.blockNumber);
        this.index = a.index;
        this.unknownCounter = a.unknownCounter;
        this.generatingFunctionName = a.generatingFunctionName;
        this.generatingFunctionArguments = a.generatingFunctionArguments;
        this.generatingFunctionInfix = a.generatingFunctionInfix;
        this.unit = new int[a.unit.length];
        System.arraycopy(a.unit, 0, this.unit, 0, a.unit.length);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute a = (Attribute)o;
        if (!this.name.equals(a.getName())) {
            return false;
        }
        return this.index == a.getTableIndex();
    }

    public boolean equalConstructionDescription(Attribute a) {
        if (!this.generatingFunctionName.equals(a.getFunctionName())) {
            return false;
        }
        if (this.generatingFunctionArguments == null && a.getArguments() == null) {
            return true;
        }
        if (this.generatingFunctionArguments != null && a.getArguments() != null) {
            if (this.generatingFunctionArguments.length != a.getArguments().length) {
                return false;
            }
            for (int i = 0; i < this.generatingFunctionArguments.length; ++i) {
                if (this.generatingFunctionArguments[i].equalConstructionDescription(a.getArguments()[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String v) {
        this.name = v;
    }

    public int getTableIndex() {
        return this.index;
    }

    public void setTableIndex(int i) {
        this.index = i;
    }

    public boolean compatible(Attribute a) {
        return Ontology.ATTRIBUTE_VALUE_TYPE.isA(this.valueType, a.getValueType()) && Ontology.ATTRIBUTE_BLOCK_TYPE.isA(this.blockType, a.getBlockType());
    }

    public boolean compatibleUnit(Attribute a) {
        for (int i = 0; i < this.unit.length; ++i) {
            if (this.unit[i] == a.getUnit(i)) continue;
            return false;
        }
        return true;
    }

    public int getUnknownCounter() {
        return this.unknownCounter;
    }

    public void setUnknownCounter(int unknownCounter) {
        this.unknownCounter = unknownCounter;
    }

    public int getBlockType() {
        return this.blockType;
    }

    public void setBlockType(int b) {
        this.blockType = b;
    }

    public int getValueType() {
        return this.valueType;
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(int blockNumber) {
        this.blockNumber = blockNumber;
        HIGHEST_BLOCK_NUMBER = Math.max(HIGHEST_BLOCK_NUMBER, blockNumber);
    }

    public void setUnits(String unitString) {
        this.unit = AbstractAttribute.parseUnits(unitString);
    }

    public void setUnit(int index, int exponent) {
        this.unit[index] = exponent;
    }

    public int getUnit(int index) {
        return this.unit[index];
    }

    public boolean isSeries() {
        return Ontology.ATTRIBUTE_BLOCK_TYPE.isA(this.blockType, 1);
    }

    public boolean isInterval() {
        return Ontology.ATTRIBUTE_VALUE_TYPE.isA(this.blockType, 4);
    }

    public boolean isBlockStart() {
        return Ontology.ATTRIBUTE_BLOCK_TYPE.isA(this.blockType, 9) || Ontology.ATTRIBUTE_BLOCK_TYPE.isA(this.blockType, 7);
    }

    public void setFunctionName(String functionName) {
        this.generatingFunctionName = functionName;
    }

    public String getFunctionName() {
        return this.generatingFunctionName;
    }

    public void setArguments(Attribute[] arguments) {
        this.generatingFunctionArguments = arguments;
    }

    public Attribute[] getArguments() {
        return this.generatingFunctionArguments;
    }

    public void clearConstructionDescription() {
        this.generatingFunctionName = this.name;
        this.generatingFunctionArguments = null;
        this.generatingFunctionInfix = false;
    }

    public String getConstructionDescription() {
        return this.getConstructionDescription(true);
    }

    public String getConstructionDescription(boolean useInfix) {
        if (this.generatingFunctionArguments == null) {
            return this.generatingFunctionName;
        }
        if (this.generatingFunctionInfix && useInfix) {
            return "(" + this.generatingFunctionArguments[0].getConstructionDescription(useInfix) + this.generatingFunctionName + this.generatingFunctionArguments[1].getConstructionDescription(useInfix) + ")";
        }
        String cd = this.generatingFunctionName + "(";
        for (int i = 0; i < this.generatingFunctionArguments.length; ++i) {
            cd = cd + (i == 0 ? "" : ", ") + this.generatingFunctionArguments[i].getConstructionDescription(useInfix);
        }
        return cd + ")";
    }

    public int getConstructionDepth() {
        if (!this.isGenerated()) {
            return 0;
        }
        int max = -1;
        for (int i = 0; i < this.generatingFunctionArguments.length; ++i) {
            max = Math.max(max, this.generatingFunctionArguments[i].getConstructionDepth());
        }
        return max + 1;
    }

    public boolean isGenerated() {
        return this.generatingFunctionArguments != null;
    }

    public String toString() {
        String unitString = this.unitToString();
        String str = "#" + this.index + ": " + this.name + ":=" + this.getConstructionDescription() + (unitString.length() > 0 ? " [" + unitString + "]" : "") + ": " + Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(this.valueType) + "/" + Ontology.ATTRIBUTE_BLOCK_TYPE.mapIndex(this.blockType) + "/" + (this.blockNumber == -1 ? "no block" : "block=" + this.blockNumber);
        return str;
    }

    public String toHTML() {
        String str = "<tr><td>" + this.index + "</td>" + "<td>" + this.name + "</td>" + "<td>" + this.getConstructionDescription() + "</td>" + "<td>" + this.unitToString() + "</td>" + "<td>" + Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(this.valueType) + "</td>" + "<td>" + Ontology.ATTRIBUTE_BLOCK_TYPE.mapIndex(this.blockType) + "</td>" + "<td>" + (Ontology.ATTRIBUTE_BLOCK_TYPE.isA(this.blockType, 1) || Ontology.ATTRIBUTE_BLOCK_TYPE.isA(this.blockType, 4) ? "" + this.blockNumber : "-") + "</td>" + "<td>";
        str = str + this.getRangeString();
        str = str + "</td></tr>";
        return str;
    }

    public String unitToString() {
        String s = "";
        if (this.unit != null) {
            for (int i = 0; i < this.unit.length; ++i) {
                if (this.unit[i] == 0) continue;
                s = s + Attribute.UNIT_NAMES[i];
                if (this.unit[i] == 1) continue;
                s = s + this.unit[i];
            }
        }
        return s;
    }

    public static int[] parseUnits(String unitString) {
        int[] unit = new int[Attribute.UNIT_NAMES.length];
        if (unitString == null) {
            for (int i = 0; i < unit.length; ++i) {
                unit[i] = 0;
            }
            return unit;
        }
        for (int i = 0; i < Attribute.UNIT_NAMES.length; ++i) {
            int pos = unitString.indexOf(Attribute.UNIT_NAMES[i]);
            if (pos != -1) {
                int endPos;
                for (endPos = pos += Attribute.UNIT_NAMES[i].length(); endPos < unitString.length() && (Character.isDigit(unitString.charAt(endPos)) || unitString.charAt(endPos) == '-'); ++endPos) {
                }
                if (endPos == pos) {
                    unit[i] = 1;
                    continue;
                }
                unit[i] = Integer.parseInt(unitString.substring(pos, endPos));
                continue;
            }
            unit[i] = 0;
        }
        return unit;
    }

    public void writeAttributeData(DataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeInt(this.valueType);
        out.writeInt(this.blockType);
        out.writeInt(this.unit.length);
        for (int i = 0; i < this.unit.length; ++i) {
            out.writeInt(this.unit[i]);
        }
    }

    public void readAttributeData(DataInput in) throws IOException {
        this.setBlockType(in.readInt());
        int[] unit = new int[in.readInt()];
        for (int i = 0; i < unit.length; ++i) {
            this.setUnit(i, in.readInt());
        }
    }

    public static int[] multiplyUnits(int[] unit1, int[] unit2) {
        int[] unit = new int[unit1.length];
        for (int i = 0; i < unit1.length; ++i) {
            unit[i] = unit1[i] + unit2[i];
        }
        return unit;
    }

    public static int[] divideUnits(int[] unit1, int[] unit2) {
        int[] unit = new int[unit1.length];
        for (int i = 0; i < unit1.length; ++i) {
            unit[i] = unit1[i] - unit2[i];
        }
        return unit;
    }
}

