/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale;

import edu.udo.cs.yale.StatisticsListener;
import edu.udo.cs.yale.StatisticsRow;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.UIManager;

public class Statistics {
    private List data = new LinkedList();
    private String name;
    private List listenerList = new LinkedList();
    private String[] columns;
    private static final Comparator ROW_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            double[] row1 = (double[])o1;
            double[] row2 = (double[])o2;
            for (int i = 0; i < row1.length; ++i) {
                if (row1[i] < row2[i]) {
                    return -1;
                }
                if (!(row1[i] > row2[i])) continue;
                return 1;
            }
            return 0;
        }
    };

    public Statistics(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String[] columns) {
        List list = this.data;
        synchronized (list) {
            this.data.clear();
        }
        this.columns = columns;
        this.fireEvent();
    }

    public String getColumnName(int i) {
        return this.columns[i];
    }

    public int getColumnIndex(String name) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    public int getNumberOfColumns() {
        return this.columns.length;
    }

    public String[] getColumnNames() {
        return this.columns;
    }

    public String getName() {
        return this.name;
    }

    public void add(Object[] row) {
        this.add(null, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(String id, Object[] row) {
        List list = this.data;
        synchronized (list) {
            this.data.add(new StatisticsRow(id, row));
            this.fireEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Iterator iterator() {
        Iterator i = null;
        List list = this.data;
        synchronized (list) {
            i = this.data.iterator();
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfRows() {
        int result = 0;
        List list = this.data;
        synchronized (list) {
            result = this.data.size();
        }
        return result;
    }

    public void addStatisticsListener(StatisticsListener statisticsListener) {
        this.listenerList.add(statisticsListener);
    }

    public void removeStatisticsListener(StatisticsListener statisticsListener) {
        this.listenerList.remove(statisticsListener);
    }

    private void fireEvent() {
        Iterator i = this.listenerList.iterator();
        while (i.hasNext()) {
            ((StatisticsListener)i.next()).statisticsUpdated(this);
        }
    }

    public void write(PrintWriter out) throws IOException {
        out.println("# Generated by " + this.getName() + "[" + this.getClass().getName() + "]");
        for (int j = 0; j < this.getNumberOfColumns(); ++j) {
            out.print((j != 0 ? "\t" : "# ") + this.getColumnName(j));
        }
        out.println();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            StatisticsRow statRow = (StatisticsRow)i.next();
            Object[] row = statRow.getRow();
            for (int j = 0; j < row.length; ++j) {
                out.print((j != 0 ? "\t" : "") + row[j]);
            }
            out.println();
        }
        out.flush();
    }

    private void write2DGNUPlotData(PrintStream out, int x, int y) {
        Object[] row;
        TreeSet<double[]> plot = new TreeSet<double[]>(ROW_COMPARATOR);
        Iterator i = this.data.iterator();
        while (i.hasNext()) {
            StatisticsRow statRow = (StatisticsRow)i.next();
            row = statRow.getRow();
            if (!(row[x] instanceof Double) || !(row[y] instanceof Double)) continue;
            plot.add(new double[]{(Double)row[x], (Double)row[y]});
        }
        Iterator j = plot.iterator();
        while (j.hasNext()) {
            row = (double[])j.next();
            out.println((double)row[0] + "\t" + (double)row[1]);
        }
    }

    public void write3DGNUPlotData(PrintStream out, int x, int y, int z) {
        TreeSet<double[]> plot = new TreeSet<double[]>(ROW_COMPARATOR);
        Iterator i = this.data.iterator();
        while (i.hasNext()) {
            StatisticsRow statRow = (StatisticsRow)i.next();
            Object[] row = statRow.getRow();
            if (!(row[x] instanceof Double) || !(row[y] instanceof Double) || !(row[2] instanceof Double)) continue;
            plot.add(new double[]{(Double)row[x], (Double)row[y], (Double)row[z]});
        }
        double oldX = Double.NaN;
        Iterator j = plot.iterator();
        while (j.hasNext()) {
            double[] row = (double[])j.next();
            if (!Double.isNaN(oldX) && row[0] != oldX) {
                out.println();
            }
            out.println(row[0] + "\t" + row[1] + "\t" + row[2]);
            oldX = row[0];
        }
    }

    private void writeGNUPlotHeader(PrintStream out, String xAxis, String yAxis, String zAxis, String additionalCommands, String terminal) {
        out.println("#!" + System.getProperty("yale.tools.gnuplot.command"));
        out.println("# Generated by " + this.getClass() + " on " + DateFormat.getDateTimeInstance().format(new Date()));
        if (xAxis != null) {
            out.println("set xlabel \"" + xAxis + "\"");
        }
        if (yAxis != null) {
            out.println("set ylabel \"" + yAxis + "\"");
        }
        if (zAxis != null) {
            out.println("set zlabel \"" + zAxis + "\"");
        }
        if (additionalCommands != null) {
            out.println(additionalCommands);
        }
        if (terminal != null) {
            out.println("set terminal " + terminal);
        }
    }

    public void writeGNUPlot(PrintStream out, int x, int y, int[] z, String linetype, String additionalCommands, String terminal) {
        int i;
        this.writeGNUPlotHeader(out, this.columns[x], y != -1 ? this.columns[y] : this.columns[z[0]], this.columns[z[0]], additionalCommands, terminal);
        if (y != -1) {
            out.print("splot ");
        } else {
            out.print("plot ");
        }
        for (i = 0; i < z.length; ++i) {
            if (i > 0) {
                out.print(", ");
            }
            out.print("'-' title \"" + this.columns[z[i]] + "\" with " + linetype);
        }
        out.println();
        for (i = 0; i < z.length; ++i) {
            if (y != -1) {
                this.write3DGNUPlotData(out, x, y, z[i]);
            } else {
                this.write2DGNUPlotData(out, x, z[i]);
            }
            out.println("e");
        }
    }

    private static Image createMessageImage(String message) {
        String[] lines = message.split("\n");
        BufferedImage image = new BufferedImage(640, 480, 1);
        Graphics g = image.getGraphics();
        int lineHeight = g.getFont().getSize();
        g.setColor(Color.white);
        g.fillRect(0, 0, 640, 480);
        g.setColor(Color.black);
        Icon icon = UIManager.getIcon("OptionPane.errorIcon");
        if (icon != null) {
            icon.paintIcon(null, g, 100 - icon.getIconWidth() - 11, 50 - lineHeight);
        }
        for (int i = 0; i < lines.length; ++i) {
            g.drawString(lines[i], 100, 50 + i * lineHeight);
        }
        return image;
    }

    public Image createGNUPlot(int x, int y, int[] z, String linetype, String additionalCommands) {
        if (System.getProperty("yale.tools.gnuplot.command") == null) {
            return Statistics.createMessageImage("Property yale.tools.gnuplot.command is not set!");
        }
        try {
            Process process = Runtime.getRuntime().exec(System.getProperty("yale.tools.gnuplot.command"));
            PrintStream out = new PrintStream(process.getOutputStream());
            this.writeGNUPlot(out, x, y, z, linetype, additionalCommands, "png");
            out.close();
            BufferedImage image = ImageIO.read(process.getInputStream());
            process.getInputStream().close();
            return image;
        }
        catch (IOException e) {
            return Statistics.createMessageImage("GNUPlot caused exception:\n" + e);
        }
    }
}

