/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.mySVM.Examples;

import edu.udo.cs.mySVM.Examples.Example;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExampleSet {
    private int dim;
    private int train_size;
    public double[][] atts;
    public int[][] index;
    public String[] ids;
    private double[] alphas;
    private double[] ys;
    private double b;
    private Example x;
    private Map meanVarianceMap = new HashMap();

    public ExampleSet(int size, double b) {
        this.train_size = size;
        this.b = b;
        this.atts = new double[this.train_size][];
        this.index = new int[this.train_size][];
        this.ys = new double[this.train_size];
        this.alphas = new double[this.train_size];
        this.ids = new String[size];
        this.x = new Example();
    }

    private static Map createMeanVariances(edu.udo.cs.yale.example.ExampleSet exampleSet) {
        int a;
        double[] sum = new double[exampleSet.getNumberOfAttributes()];
        double[] squaredSum = new double[exampleSet.getNumberOfAttributes()];
        ExampleReader reader = exampleSet.getExampleReader();
        while (reader.hasNext()) {
            edu.udo.cs.yale.example.Example example = reader.next();
            a = 0;
            while (a < example.getNumberOfAttributes()) {
                double value = example.getValue(example.getAttribute(a));
                int n = a;
                sum[n] = sum[n] + value;
                int n2 = a++;
                squaredSum[n2] = squaredSum[n2] + value * value;
            }
        }
        HashMap<Integer, MeanVariance> meanVariances = new HashMap<Integer, MeanVariance>();
        for (a = 0; a < exampleSet.getNumberOfAttributes(); ++a) {
            int n = a;
            sum[n] = sum[n] / (double)exampleSet.getSize();
            int n3 = a;
            squaredSum[n3] = squaredSum[n3] / (double)exampleSet.getSize();
            meanVariances.put(new Integer(a), new MeanVariance(sum[a], squaredSum[a] - sum[a] * sum[a]));
        }
        return meanVariances;
    }

    public ExampleSet(edu.udo.cs.yale.example.ExampleSet exampleSet, Attribute labelAttribute, boolean scale) {
        this(exampleSet, labelAttribute, scale ? ExampleSet.createMeanVariances(exampleSet) : new HashMap());
    }

    public ExampleSet(edu.udo.cs.yale.example.ExampleSet exampleSet, Attribute labelAttribute, Map meanVariances) {
        this(exampleSet.getSize(), 0.0);
        this.meanVarianceMap = meanVariances;
        ExampleReader reader = exampleSet.getExampleReader();
        Attribute idAttribute = exampleSet.getId();
        int exampleCounter = 0;
        while (reader.hasNext()) {
            edu.udo.cs.yale.example.Example current = reader.next();
            LinkedHashMap<Integer, Double> attributeMap = new LinkedHashMap<Integer, Double>();
            for (int a = 0; a < current.getNumberOfAttributes(); ++a) {
                Attribute attribute = current.getAttribute(a);
                double value = current.getValue(attribute);
                if (!current.getAttribute(a).isDefault(value)) {
                    attributeMap.put(new Integer(a), new Double(value));
                }
                if (a + 1 <= this.dim) continue;
                this.dim = a + 1;
            }
            this.atts[exampleCounter] = new double[attributeMap.size()];
            this.index[exampleCounter] = new int[attributeMap.size()];
            Iterator i = attributeMap.keySet().iterator();
            int attributeCounter = 0;
            while (i.hasNext()) {
                Integer indexValue = (Integer)i.next();
                Double attributeValue = (Double)attributeMap.get(indexValue);
                this.index[exampleCounter][attributeCounter] = indexValue;
                double value = attributeValue;
                MeanVariance meanVariance = (MeanVariance)this.meanVarianceMap.get(new Integer(indexValue));
                if (meanVariance != null) {
                    value = meanVariance.getVariance() == 0.0 ? 0.0 : (value - meanVariance.getMean()) / Math.sqrt(meanVariance.getVariance());
                }
                this.atts[exampleCounter][attributeCounter] = value;
                ++attributeCounter;
            }
            if (labelAttribute != null) {
                double label = current.getLabel();
                this.ys[exampleCounter] = labelAttribute.isNominal() ? (double)(label == (double)labelAttribute.getPositiveIndex() ? 1 : -1) : label;
            }
            if (idAttribute != null) {
                this.ids[exampleCounter] = current.getValueAsString(idAttribute);
            }
            ++exampleCounter;
        }
    }

    public ExampleSet(ObjectInputStream in) throws IOException {
        this(in.readInt(), in.readDouble());
        this.dim = in.readInt();
        String scaleString = in.readUTF();
        if (scaleString.equals("scale")) {
            int numberOfAttributes = in.readInt();
            this.meanVarianceMap = new HashMap();
            for (int i = 0; i < numberOfAttributes; ++i) {
                int index = in.readInt();
                double mean = in.readDouble();
                double variance = in.readDouble();
                this.meanVarianceMap.put(new Integer(index), new MeanVariance(mean, variance));
            }
        }
        for (int e = 0; e < this.train_size; ++e) {
            this.index[e] = new int[in.readInt()];
            this.atts[e] = new double[this.index[e].length];
            for (int a = 0; a < this.index[e].length; ++a) {
                this.index[e][a] = in.readInt();
                this.atts[e][a] = in.readDouble();
            }
            this.alphas[e] = in.readDouble();
            this.ys[e] = in.readDouble();
        }
    }

    public Map getMeanVariances() {
        return this.meanVarianceMap;
    }

    private int getNumberOfSupportVectors() {
        int result = 0;
        for (int i = 0; i < this.alphas.length; ++i) {
            if (this.alphas[i] == 0.0) continue;
            ++result;
        }
        return result;
    }

    public void writeSupportVectors(ObjectOutputStream out) throws IOException {
        out.writeInt(this.getNumberOfSupportVectors());
        out.writeDouble(this.b);
        out.writeInt(this.dim);
        if (this.meanVarianceMap == null || this.meanVarianceMap.size() == 0) {
            out.writeUTF("noscale");
        } else {
            out.writeUTF("scale");
            out.writeInt(this.meanVarianceMap.size());
            Iterator i = this.meanVarianceMap.keySet().iterator();
            while (i.hasNext()) {
                Integer index = (Integer)i.next();
                MeanVariance meanVariance = (MeanVariance)this.meanVarianceMap.get(index);
                out.writeInt(index);
                out.writeDouble(meanVariance.getMean());
                out.writeDouble(meanVariance.getVariance());
            }
        }
        for (int e = 0; e < this.train_size; ++e) {
            if (this.alphas[e] == 0.0) continue;
            out.writeInt(this.atts[e].length);
            for (int a = 0; a < this.atts[e].length; ++a) {
                out.writeInt(this.index[e][a]);
                out.writeDouble(this.atts[e][a]);
            }
            out.writeDouble(this.alphas[e]);
            out.writeDouble(this.ys[e]);
        }
    }

    public int count_examples() {
        return this.train_size;
    }

    public int count_pos_examples() {
        int result = 0;
        for (int i = 0; i < this.train_size; ++i) {
            if (!(this.ys[i] > 0.0)) continue;
            ++result;
        }
        return result;
    }

    public int get_dim() {
        return this.dim;
    }

    public Example get_example(int pos) {
        this.x.att = this.atts[pos];
        this.x.index = this.index[pos];
        return this.x;
    }

    public double get_y(int pos) {
        return this.ys[pos];
    }

    public void set_y(int pos, double y) {
        this.ys[pos] = y;
    }

    public double[] get_ys() {
        return this.ys;
    }

    public double get_alpha(int pos) {
        return this.alphas[pos];
    }

    public double[] get_alphas() {
        return this.alphas;
    }

    public void swap(int pos1, int pos2) {
        double[] dummyA = this.atts[pos1];
        this.atts[pos1] = this.atts[pos2];
        this.atts[pos2] = dummyA;
        int[] dummyI = this.index[pos1];
        this.index[pos1] = this.index[pos2];
        this.index[pos2] = dummyI;
        double dummyd = this.alphas[pos1];
        this.alphas[pos1] = this.alphas[pos2];
        this.alphas[pos2] = dummyd;
        dummyd = this.ys[pos1];
        this.ys[pos1] = this.ys[pos2];
        this.ys[pos2] = dummyd;
    }

    public double get_b() {
        return this.b;
    }

    public void set_b(double new_b) {
        this.b = new_b;
    }

    public void set_alpha(int pos, double alpha) {
        this.alphas[pos] = alpha;
    }

    public void clearAlphas() {
        for (int i = 0; i < this.alphas.length; ++i) {
            this.alphas[i] = 0.0;
        }
    }

    public String getId(int index) {
        return this.ids[index];
    }

    public String toString() {
        return this.toString(this.atts.length, false);
    }

    public String toString(boolean onlySV) {
        return this.toString(this.atts.length, onlySV);
    }

    public String toString(int numberOfExamples, boolean onlySV) {
        StringBuffer result = new StringBuffer("SVM Example Set (" + (onlySV ? this.getNumberOfSupportVectors() + " support vectors" : this.train_size + " examples") + "):\nb: " + this.b + "\n");
        for (int e = 0; e < numberOfExamples; ++e) {
            if (onlySV && this.alphas[e] == 0.0) continue;
            for (int a = 0; a < this.atts[e].length; ++a) {
                result.append(this.index[e][a] + ":");
                result.append(this.atts[e][a] + " ");
            }
            result.append(", alpha: " + this.alphas[e]);
            result.append(", y: " + this.ys[e] + "\n");
        }
        return result.toString();
    }

    public static class MeanVariance {
        private double mean = 0.0;
        private double variance = 0.0;

        public MeanVariance(double mean, double variance) {
            this.mean = mean;
            this.variance = variance;
        }

        public double getMean() {
            return this.mean;
        }

        public double getVariance() {
            return this.variance;
        }
    }
}

