/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot.svm;

import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.jvito.parameter.ParameterTypeDynamicCategory;
import edu.udo.cs.jvito.plot.ColorPanel;
import edu.udo.cs.jvito.plot.MovingListener;
import edu.udo.cs.jvito.plot.SimplePlot;
import edu.udo.cs.jvito.plot.ZoomingListener;
import edu.udo.cs.jvito.plot.svm.AttributeFunctionValuePanel;
import edu.udo.cs.jvito.util.Logger;
import edu.udo.cs.jvito.util.Utils;
import edu.udo.cs.mySVM.SVM.SVMInterface;
import edu.udo.cs.yale.example.AbstractAttribute;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.Model;
import edu.udo.cs.yale.operator.learner.kernel.JMySVMModel;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;

public class HyperplaneProjection2D
extends SimplePlot {
    private int number_atts = 0;
    private int number_of_samples = 0;
    private int x_attr = 0;
    private int y_attr = 0;
    private int c_attr;
    private Attribute x_attribute;
    private Attribute y_attribute;
    private Attribute colorattribute;
    private double[][] samples;
    private double[] x_samples;
    private double[] y_samples;
    private double[] datacenter;
    private double[] planecenter;
    private float[] labelvalues;
    private float[] colorsamples;
    private JPanel mainpane;
    private JMySVMModel jmysvmmodel;
    private double[] weights;
    private double bias;
    private static final String[] DISTANCE = new String[]{"distance_planecenter", "distance_plane", "angle"};
    private static final String[] CENTER = new String[]{"average", "plane_average"};

    public HyperplaneProjection2D() {
    }

    public HyperplaneProjection2D(String name) {
        this.setName(name);
    }

    public JPanel getPlotPanel() {
        return this.mainpane;
    }

    private void initComponents() {
        this.initDisplay();
        this.mainpane = new JPanel();
        this.mainpane.setLayout(new BorderLayout());
        if (!this.source.isCompiled()) {
            return;
        }
        ExampleSet set = this.source.getExampleSet();
        this.mainpane.add((Component)this.plotpanel, "Center");
        if (this.getParameterAsInt("color_attribute") != 0) {
            JPanel colorpanel = this.plotpanel.getColorPanel();
            if (this.getParameterAsInt("color_attribute") > set.getNumberOfAttributes()) {
                if (set.getLabel() != null && set.getLabel().isNominal() && this.getParameterAsInt("color_attribute") == set.getNumberOfAttributes() + 1) {
                    Color[] colors = new Color[set.getLabel().getValues().size()];
                    Collection values = set.getLabel().getValues();
                    Object[] valuesstr = values.toArray();
                    for (int i = 0; i < valuesstr.length; ++i) {
                        colors[i] = this.source.getExampleColoring().getColorOfLabelValue(set.getLabel(), (String)valuesstr[i]);
                    }
                    colorpanel = new ColorPanel(set.getLabel(), colors, this.getParameterAsColor("foreground"), this.getParameterAsColor("background"));
                } else if (set.getPredictedLabel() != null && set.getPredictedLabel().isNominal()) {
                    Collection values = set.getPredictedLabel().getValues();
                    Object[] valuesstr = values.toArray();
                    Color[] colors = new Color[set.getPredictedLabel().getValues().size() * set.getPredictedLabel().getValues().size()];
                    String[] valuestring = new String[valuesstr.length * valuesstr.length];
                    for (int i = 0; i < valuesstr.length; ++i) {
                        for (int j = 0; j < valuesstr.length; ++j) {
                            valuestring[i * valuesstr.length + j] = new String((String)valuesstr[i] + " - " + (String)valuesstr[j]);
                            colors[i * valuesstr.length + j] = this.source.getExampleColoring().getColorOfLabelvsPred(set.getLabel(), set.getPredictedLabel(), (String)valuesstr[i], (String)valuesstr[j]);
                        }
                    }
                    colorpanel = new ColorPanel(set.getPredictedLabel(), valuestring, colors, this.getParameterAsColor("foreground"), this.getParameterAsColor("background"));
                }
            }
            colorpanel.setPreferredSize(new Dimension(125, colorpanel.getHeight()));
            this.mainpane.add((Component)colorpanel, "East");
        }
    }

    private void initDisplay() {
        ExampleSet set = this.source.getExampleSet();
        boolean haslabel = this.source.getExampleSet().getLabel() != null;
        boolean haspredlabel = this.source.getExampleSet().getPredictedLabel() != null;
        this.plotpanel = new AttributeFunctionValuePanel(this.source.getExampleSet(), this.source.getExampleColoring(), this.x_attribute, this.y_attribute, this.x_samples, this.y_samples, this.getParameterAsDouble("point_size"));
        this.plotpanel.setTitle(this.getParameterAsString("title"));
        this.plotpanel.setDrawTitle(this.getParameterAsBoolean("show title"));
        this.plotpanel.setForegroundColor(this.getParameterAsColor("foreground"));
        this.plotpanel.setBackgroundColor(this.getParameterAsColor("background"));
        MovingListener movinglistener = new MovingListener(this.plotpanel);
        ZoomingListener zoominlistener = new ZoomingListener(this.plotpanel);
        this.plotpanel.addMouseListener(movinglistener);
        this.plotpanel.addMouseMotionListener(movinglistener);
        this.plotpanel.addMouseListener(zoominlistener);
        this.plotpanel.addMouseMotionListener(zoominlistener);
        String color_attribute = ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).getValues()[this.getParameterAsInt("color_attribute")];
        if (!color_attribute.equals("<None>")) {
            if (haslabel && color_attribute.equals(set.getLabel().getName())) {
                this.plotpanel.colorByAttribute(this.colorattribute, this.colorsamples);
                this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfLabel(this.colorattribute));
                this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfLabel(this.colorattribute));
                this.plotpanel.initColorTable();
            } else if (haspredlabel && color_attribute.equals(this.source.getExampleSet().getPredictedLabel().getName()) && this.colorattribute.isNominal()) {
                Collection values = set.getPredictedLabel().getValues();
                Object[] valuesstr = values.toArray();
                Color[] colors = new Color[set.getPredictedLabel().getValues().size() * set.getPredictedLabel().getValues().size()];
                for (int i = 0; i < valuesstr.length; ++i) {
                    for (int j = 0; j < valuesstr.length; ++j) {
                        colors[i * valuesstr.length + j] = this.source.getExampleColoring().getColorOfLabelvsPred(set.getLabel(), set.getPredictedLabel(), (String)valuesstr[i], (String)valuesstr[j]);
                    }
                }
                float[] pvalues = new float[this.number_of_samples];
                for (int i = 0; i < this.colorsamples.length; ++i) {
                    pvalues[i] = this.labelvalues[i] * (float)valuesstr.length + this.colorsamples[i];
                }
                this.plotpanel.colorByAttribute(this.colorattribute, pvalues, colors);
                this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfPredLabel(this.colorattribute));
                this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfPredLabel(this.colorattribute));
            } else if (haspredlabel && color_attribute.equals(this.source.getExampleSet().getPredictedLabel().getName()) && this.colorattribute.isNumerical()) {
                this.plotpanel.colorByAttribute(this.colorattribute, this.colorsamples);
                this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfPredLabel(this.colorattribute));
                this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfPredLabel(this.colorattribute));
                this.plotpanel.initColorTable();
            } else {
                this.plotpanel.colorByAttribute(this.colorattribute, this.colorsamples);
                this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfAttribute(this.colorattribute));
                this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfAttribute(this.colorattribute));
                this.plotpanel.initColorTable();
            }
        }
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeFile("model_file", "The JMySVMModel-File.", "");
        types.add(type);
        type = new ParameterTypeStringCategory("center", "The center-type.", CENTER, CENTER[0]);
        types.add(type);
        type = new ParameterTypeStringCategory("distance", "The distance-type.", DISTANCE, DISTANCE[0]);
        types.add(type);
        type = new ParameterTypeDynamicCategory("color_attribute", "This attribute is the color-dimension.", this.getColorAttributes(), 0);
        types.add(type);
        type = new ParameterTypeDouble("point_size", "Size of the points.", 0.0, 100.0, 5.0);
        types.add(type);
        return types;
    }

    public void compile() throws CompilerException {
        this.iscompiling = true;
        if (this.source == null) {
            throw new CompilerException("Cannot compile ScatterPlot2D. This operator must be achild of a data-operator.");
        }
        ExampleSet set = this.source.getExampleSet();
        this.number_of_samples = set.getSize();
        this.number_atts = set.getNumberOfAttributes();
        this.samples = new double[this.number_atts][this.number_of_samples];
        this.x_samples = new double[this.number_of_samples];
        this.y_samples = new double[this.number_of_samples];
        this.labelvalues = new float[this.number_of_samples];
        this.datacenter = new double[this.number_atts];
        this.readModel();
        if (set.getPredictedLabel() == null) {
            try {
                this.jmysvmmodel.setPredictionParameter("function_value", "true");
                Attribute predictedLabel = this.jmysvmmodel.createPredictedLabel(set);
                this.jmysvmmodel.apply(set);
                set.recalculateAllAttributeStatistics();
            }
            catch (OperatorException e) {
                throw new CompilerException(e.getMessage(), e);
            }
        }
        if (this.getParameterAsInt("color_attribute") != 0) {
            this.colorsamples = new float[this.number_of_samples];
        }
        this.c_attr = this.getParameterAsInt("color_attribute") - 1;
        this.y_attribute = set.getPredictedLabel();
        if (this.c_attr >= 0) {
            this.colorattribute = this.c_attr < this.number_atts ? set.getAttribute(this.c_attr) : (this.c_attr == this.number_atts && set.getLabel() != null ? set.getLabel() : set.getPredictedLabel());
        }
        for (int i = 0; i < this.number_atts; ++i) {
            this.datacenter[i] = set.getAttribute(i).getAverage();
        }
        boolean haslabel = set.getLabel() != null;
        ExampleReader reader = set.getExampleReader();
        for (int sample = 0; sample < this.number_of_samples; ++sample) {
            Example example = reader.next();
            for (int i = 0; i < this.number_atts; ++i) {
                this.samples[i][sample] = example.getValue(i);
            }
            this.y_samples[sample] = example.getPredictedLabel();
            if (haslabel) {
                this.labelvalues[sample] = (float)example.getLabel();
            }
            if (this.c_attr < 0) continue;
            this.colorsamples[sample] = this.c_attr < this.number_atts ? (float)example.getValue(this.colorattribute) : (this.c_attr == this.number_atts && set.getLabel() != null ? (float)example.getLabel() : (float)example.getPredictedLabel());
        }
        if (this.getParameterAsString("center").equals(CENTER[0])) {
            this.calculatePlaneCenter();
        }
        if (this.getParameterAsString("center").equals(CENTER[1])) {
            this.calculateDataCenter();
            this.planecenter = new double[this.number_atts];
            for (int i = 0; i < this.number_atts; ++i) {
                this.planecenter[i] = this.datacenter[i];
            }
        }
        this.calculateXAttribute();
        this.initComponents();
        this.iscompiling = false;
        this.iscompiled = true;
    }

    private void logDataCenter(ExampleSet set) {
        String props = new String("\n");
        props = props + Utils.getString("Attribute", 25, 0) + "| " + Utils.getString("DataCenter", 25, 0) + "\n";
        props = props + Utils.duplicateString("-", 25) + "+ " + Utils.duplicateString("-", 25) + "\n";
        for (int i = 0; i < 100 && i < this.number_atts; ++i) {
            props = props + Utils.getString(set.getAttribute(i).getName(), 25, 0) + "| " + Utils.getString(Double.toString(this.datacenter[i]), 25, 1) + "\n";
        }
        Logger.logMessage(props, 3);
    }

    private void readModel() throws CompilerException {
        String filename = this.getParameterAsString("model_file");
        File modelFile = new File(filename);
        Model model = null;
        try {
            model = Model.readModel(modelFile);
        }
        catch (IOException e) {
            throw new CompilerException(e.getMessage(), e);
        }
        catch (OperatorException e) {
            throw new CompilerException(e.getMessage(), e);
        }
        if (!(model instanceof JMySVMModel)) {
            throw new CompilerException("");
        }
        this.jmysvmmodel = (JMySVMModel)model;
        SVMInterface svm2 = this.jmysvmmodel.createSVM();
        svm2.init(this.jmysvmmodel.getKernel(), this.jmysvmmodel.getExampleSet());
        this.weights = svm2.getWeights();
        this.bias = svm2.getB();
    }

    private void calculateDataCenter() {
        int i;
        double ww = 0.0;
        for (i = 0; i < this.weights.length; ++i) {
            ww += this.weights[i] * this.weights[i];
        }
        for (i = 0; i < this.number_atts; ++i) {
            this.datacenter[i] = 0.0;
        }
        for (int s = 0; s < this.number_of_samples; ++s) {
            int i2;
            double wm = 0.0;
            for (i2 = 0; i2 < this.number_atts; ++i2) {
                wm += this.weights[i2] * this.samples[i2][s];
            }
            double t = (-1.0 * this.bias - wm) / ww;
            i2 = 0;
            while (i2 < this.number_atts) {
                double planepoint = this.samples[i2][s] + t * this.weights[i2];
                int n = i2++;
                this.datacenter[n] = this.datacenter[n] + planepoint;
            }
        }
        for (int i3 = 0; i3 < this.number_atts; ++i3) {
            this.datacenter[i3] = this.datacenter[i3] / (double)this.number_of_samples;
        }
    }

    private void calculatePlaneCenter() {
        this.planecenter = new double[this.number_atts];
        double ww = 0.0;
        double ws = 0.0;
        for (int i = 0; i < this.weights.length; ++i) {
            ww += this.weights[i] * this.weights[i];
            ws += this.weights[i] * this.datacenter[i];
        }
        double t = (-1.0 * this.bias - ws) / ww;
        for (int i = 0; i < this.number_atts; ++i) {
            this.planecenter[i] = this.datacenter[i] + t * this.weights[i];
        }
    }

    private void calculateXAttribute() {
        int i;
        this.x_samples = new double[this.number_of_samples];
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        if (this.getParameterAsString("distance").equals(DISTANCE[0])) {
            for (int s = 0; s < this.number_of_samples; ++s) {
                this.x_samples[s] = 0.0;
                for (int i2 = 0; i2 < this.number_atts; ++i2) {
                    int n = s;
                    this.x_samples[n] = this.x_samples[n] + (this.samples[i2][s] - this.planecenter[i2]) * (this.samples[i2][s] - this.planecenter[i2]);
                }
                this.x_samples[s] = Math.sqrt(this.x_samples[s]);
                min = Math.min(min, this.x_samples[s]);
                max = Math.max(max, this.x_samples[s]);
            }
        }
        if (this.getParameterAsString("distance").equals(DISTANCE[1])) {
            double ww = 0.0;
            for (i = 0; i < this.weights.length; ++i) {
                ww += this.weights[i] * this.weights[i];
            }
            for (int s = 0; s < this.number_of_samples; ++s) {
                int i3;
                this.x_samples[s] = 0.0;
                double wm = 0.0;
                for (i3 = 0; i3 < this.number_atts; ++i3) {
                    wm += this.weights[i3] * this.samples[i3][s];
                }
                double t = (-1.0 * this.bias - wm) / ww;
                for (i3 = 0; i3 < this.number_atts; ++i3) {
                    double planepoint = this.samples[i3][s] + t * this.weights[i3];
                    int n = s;
                    this.x_samples[n] = this.x_samples[n] + (planepoint - this.planecenter[i3]) * (planepoint - this.planecenter[i3]);
                }
                this.x_samples[s] = Math.sqrt(this.x_samples[s]);
                min = Math.min(min, this.x_samples[s]);
                max = Math.max(max, this.x_samples[s]);
            }
        }
        if (this.getParameterAsString("distance").equals(DISTANCE[2])) {
            double weightslength = 0.0;
            for (i = 0; i < this.number_atts; ++i) {
                weightslength += this.weights[i] * this.weights[i];
            }
            weightslength = Math.sqrt(weightslength);
            for (int s = 0; s < this.number_of_samples; ++s) {
                int i4;
                double samplelength = 0.0;
                double[] planesample = new double[this.weights.length];
                for (i4 = 0; i4 < planesample.length; ++i4) {
                    planesample[i4] = this.planecenter[i4] - this.samples[i4][s];
                    samplelength += planesample[i4] * planesample[i4];
                }
                samplelength = Math.sqrt(samplelength);
                this.x_samples[s] = 0.0;
                for (i4 = 0; i4 < this.number_atts; ++i4) {
                    int n = s;
                    this.x_samples[n] = this.x_samples[n] + this.weights[i4] * planesample[i4];
                }
                this.x_samples[s] = this.x_samples[s] / (samplelength * weightslength);
                this.x_samples[s] = (this.x_samples[s] + 1.0) / 2.0 * 180.0;
                min = Math.min(min, this.x_samples[s]);
                max = Math.max(max, this.x_samples[s]);
            }
        }
        this.x_attribute = new XAttribute(this.getParameterAsString("distance"), min, max);
    }

    public void parentIsCompiled() {
        ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).setValues(this.getColorAttributes());
    }

    public void refreshParameter() {
        ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).setValues(this.getColorAttributes());
    }

    public String[] getAttributes() {
        if (this.source == null) {
            return new String[]{""};
        }
        ExampleSet set = this.source.getExampleSet();
        if (set == null) {
            return new String[]{""};
        }
        int count = 0;
        count += set.getNumberOfAttributes();
        if (set.getLabel() != null) {
            ++count;
        }
        if (set.getPredictedLabel() != null) {
            ++count;
        }
        String[] categories = new String[count];
        for (int i = 0; i < set.getNumberOfAttributes(); ++i) {
            categories[i] = set.getAttribute(i).getName();
        }
        int index = set.getNumberOfAttributes();
        if (set.getLabel() != null) {
            categories[index] = set.getLabel().getName();
            ++index;
        }
        if (set.getPredictedLabel() != null) {
            categories[index] = set.getPredictedLabel().getName();
        }
        return categories;
    }

    public String[] getColorAttributes() {
        if (this.source == null) {
            return new String[]{"<None>"};
        }
        if (!this.source.isCompiled()) {
            return new String[]{"<None>"};
        }
        ExampleSet set = this.source.getExampleSet();
        if (set == null) {
            return new String[]{"<None>"};
        }
        int count = 1;
        count += set.getNumberOfAttributes();
        if (set.getLabel() != null) {
            ++count;
        }
        if (set.getPredictedLabel() != null) {
            ++count;
        }
        String[] categories = new String[count];
        categories[0] = "<None>";
        for (int i = 1; i <= set.getNumberOfAttributes(); ++i) {
            categories[i] = set.getAttribute(i - 1).getName();
        }
        int index = set.getNumberOfAttributes() + 1;
        if (set.getLabel() != null) {
            categories[index] = set.getLabel().getName();
            ++index;
        }
        if (set.getPredictedLabel() != null) {
            categories[index] = set.getPredictedLabel().getName();
            ++index;
        }
        return categories;
    }

    private class XAttribute
    extends AbstractAttribute {
        private String name;
        private double min;
        private double max;

        public XAttribute(String name, double min, double max) {
            super(name, 4);
            this.name = name;
            this.min = min;
            this.max = max;
        }

        public double getMaximum() {
            return this.max;
        }

        public double getMinimum() {
            return this.min;
        }

        public String getName() {
            return this.name;
        }

        public Object clone() {
            return null;
        }

        public void clearMaps() {
        }

        public String getAsString(double value, int digits) {
            return null;
        }

        public double getAverage() {
            return 0.0;
        }

        public String getMode() {
            return null;
        }

        public int getNegativeIndex() {
            return 0;
        }

        public int getNumberOfValues() {
            return 0;
        }

        public int getPositiveIndex() {
            return 0;
        }

        public String getRangeString() {
            return null;
        }

        public int getValueCount(String value) {
            return 0;
        }

        public Collection getValues() {
            return null;
        }

        public double getVariance() {
            return 0.0;
        }

        public boolean isBooleanClassification() {
            return false;
        }

        public boolean isDefault(double value) {
            return false;
        }

        public boolean isNominal() {
            return false;
        }

        public boolean isNumerical() {
            return false;
        }

        public String mapIndex(int index) {
            return null;
        }

        public int getIndex(String str) {
            return 0;
        }

        public int mapString(String str) {
            return 0;
        }

        public void replaceValue(String oldValue, String newValue) {
        }

        public void setAverage(double a) {
        }

        public void setIndexToCounterMap(int[] indexToCounterMap) {
        }

        public void setMaximum(double m) {
        }

        public void setMinimum(double m) {
        }

        public void setMode(String mode) {
        }

        public void setVariance(double v) {
        }

        public void sortNominalMappings() {
        }
    }
}

