/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot.svm;

import edu.udo.cs.jvito.JViTo;
import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.jvito.parameter.ParameterTypeDynamicCategory;
import edu.udo.cs.jvito.plot.ColorPanel;
import edu.udo.cs.jvito.plot.HistogramNumeric;
import edu.udo.cs.jvito.plot.MovingListener;
import edu.udo.cs.jvito.plot.SimplePlot;
import edu.udo.cs.jvito.plot.ZoomingListener;
import edu.udo.cs.jvito.plot.svm.AttributeFunctionValuePanel;
import edu.udo.cs.jvito.plot.svm.FuncValueHistPanel;
import edu.udo.cs.jvito.util.Logger;
import edu.udo.cs.jvito.util.Utils;
import edu.udo.cs.mySVM.Examples.Example;
import edu.udo.cs.mySVM.Examples.ExampleSet;
import edu.udo.cs.mySVM.SVM.SVMInterface;
import edu.udo.cs.yale.Statistics;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.gui.ColorPlotter;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.Model;
import edu.udo.cs.yale.operator.learner.kernel.JMySVMModel;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import edu.udo.cs.yale.operator.performance.EstimatedPerformance;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class FunctionValueAnimation
extends SimplePlot
implements ActionListener {
    private JPanel display;
    private JScrollPane scrollpane;
    private Attribute attribut;
    private Attribute label;
    private String[] attr_names = new String[0];
    private int number_atts = 0;
    private int number_of_samples = 0;
    private float[] labelvalues;
    private float[] orig_labelvalues;
    private float[] predvalues;
    private float[] old_fvalues;
    private float[] fvalues;
    private float[] colorsamples;
    private String[] classes;
    private JTextField nextField;
    private int[] attribute_index;
    private double[] weights;
    private float[][] samples;
    private Attribute[] attributes;
    private int nr_atts;
    private JMySVMModel jmysvmmodel;
    private ExampleSet trainSet;
    private ExampleSet modelSet;
    private JList attlist;
    private PerformanceVector aucPerformanceVector;
    private Component rocplot;
    private Component perfplot;
    private JPanel rocpanel;
    private JPanel aucpanel;
    private JPanel perfpanel;
    private JTabbedPane tabbedpane;
    private static final String[] performance = new String[]{"AUC", "accuracy", "precision", "recall", "fallout", "f_measure"};
    private static final String[] animationplot = new String[]{"FunctionValueHistogram", "Histogram", "FunctionValue2DPlot", "AttributeFunctionValuePlot"};
    private int anzahl_perf;
    private List perf_data;
    private int c_attr;
    private Attribute colorattribute;
    private Color startcolor;
    private Color endcolor;

    public FunctionValueAnimation() {
    }

    public FunctionValueAnimation(String name) {
        this.setName(name);
    }

    private void initComponents() {
        JButton saveButton;
        JPanel buttonPanel;
        JPanel colorpanel;
        this.display = new JPanel();
        this.display.setLayout(new BorderLayout(10, 10));
        JPanel settings = new JPanel();
        settings.setPreferredSize(new Dimension(125, settings.getHeight()));
        settings.setLayout(new BorderLayout());
        if (!this.source.isCompiled()) {
            return;
        }
        edu.udo.cs.yale.example.ExampleSet set = this.source.getExampleSet();
        this.initPlotPanel();
        this.display.add((Component)settings, "East");
        JPanel settings2 = new JPanel();
        settings2.setLayout(new GridLayout(2, 1, 5, 5));
        settings.add((Component)settings2, "Center");
        this.initClassNames();
        String plottype = this.getParameterAsString("plot_type");
        if (plottype.equals(animationplot[0])) {
            Color[] colors = new Color[set.getLabel().getValues().size()];
            Collection values = set.getLabel().getValues();
            Object[] valuesstr = values.toArray();
            for (int i = 0; i < valuesstr.length; ++i) {
                colors[i] = this.source.getExampleColoring().getColorOfLabelValue(set.getLabel(), (String)valuesstr[i]);
            }
            colorpanel = new ColorPanel(this.colorattribute, colors, this.getParameterAsColor("foreground"), this.getParameterAsColor("background"));
        } else {
            colorpanel = this.plotpanel.getColorPanel();
        }
        settings2.add(colorpanel);
        this.attlist = new JList();
        this.attlist.setListData(this.createAttributeList());
        this.attlist.setSelectedIndex(0);
        JScrollPane scroll = new JScrollPane(this.attlist);
        settings2.add(scroll);
        JPanel nextpanel = new JPanel();
        nextpanel.setLayout(new GridLayout(1, 2, 5, 5));
        this.nextField = new JTextField();
        this.nextField.setText(Integer.toString(this.nr_atts));
        nextpanel.add(this.nextField);
        JButton nextbutton = new JButton("Next");
        nextbutton.addActionListener(this);
        nextpanel.add(nextbutton);
        settings.add((Component)nextpanel, "South");
        JPanel display2 = new JPanel();
        display2.setLayout(new BorderLayout());
        this.tabbedpane = new JTabbedPane();
        this.tabbedpane.addTab("HistogramNumeric", this.plotpanel);
        String perf_index = this.getParameterAsString("performance");
        if (perf_index.equals(performance[0])) {
            this.rocpanel = new JPanel();
            this.rocpanel.setLayout(new BorderLayout());
            buttonPanel = new JPanel();
            buttonPanel.setLayout(new BorderLayout());
            this.rocpanel.add((Component)buttonPanel, "South");
            saveButton = new JButton("Save");
            saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (FunctionValueAnimation.this.rocplot != null) {
                        JViTo.getApplication().saveComponent(null, "Save ROCPlot...", FunctionValueAnimation.this.rocplot, FunctionValueAnimation.this.getName() + "_ROCPlot");
                    }
                }
            });
            buttonPanel.add((Component)saveButton, "East");
            this.tabbedpane.addTab("ROCPlot", this.rocpanel);
        }
        this.aucpanel = new JPanel();
        this.aucpanel.setLayout(new BorderLayout());
        this.tabbedpane.addTab("PerformanceVector", this.aucpanel);
        this.perfpanel = new JPanel();
        this.perfpanel.setLayout(new BorderLayout());
        buttonPanel = new JPanel();
        buttonPanel.setLayout(new BorderLayout());
        this.perfpanel.add((Component)buttonPanel, "South");
        saveButton = new JButton("Save");
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (FunctionValueAnimation.this.perfplot != null) {
                    JViTo.getApplication().saveComponent(null, "Save PerformancePlot...", FunctionValueAnimation.this.perfplot, FunctionValueAnimation.this.getName() + "_PerformancePlot");
                }
            }
        });
        buttonPanel.add((Component)saveButton, "East");
        this.tabbedpane.addTab("PerformancePlot", this.perfpanel);
        display2.add((Component)this.tabbedpane, "Center");
        this.display.add((Component)display2, "Center");
    }

    private void initClassNames() {
        this.classes = new String[this.source.getExampleSet().getLabel().getNumberOfValues()];
        Collection col = this.source.getExampleSet().getLabel().getValues();
        Iterator iter = col.iterator();
        int index = 0;
        while (iter.hasNext()) {
            this.classes[index] = (String)iter.next();
            ++index;
        }
    }

    protected void initPlotPanel() {
        edu.udo.cs.yale.example.ExampleSet set = this.source.getExampleSet();
        String plottype = this.getParameterAsString("plot_type");
        if (set.getPredictedLabel().isNumerical()) {
            if (plottype.equals(animationplot[0])) {
                this.plotpanel = new FuncValueHistPanel(this.source.getExampleColoring(), set.getLabel(), set.getPredictedLabel(), this.labelvalues, this.fvalues);
                if (this.nr_atts < this.number_atts) {
                    ((FuncValueHistPanel)this.plotpanel).setDrawBounds(false);
                }
            } else if (plottype.equals(animationplot[2])) {
                float min = Float.POSITIVE_INFINITY;
                float max = Float.NEGATIVE_INFINITY;
                float oldmin = Float.POSITIVE_INFINITY;
                float oldmax = Float.NEGATIVE_INFINITY;
                for (int i = 0; i < this.number_of_samples; ++i) {
                    min = Math.min(min, this.fvalues[i]);
                    max = Math.max(max, this.fvalues[i]);
                    oldmin = Math.min(oldmin, this.old_fvalues[i]);
                    oldmax = Math.max(oldmax, this.old_fvalues[i]);
                }
                if (oldmin == oldmax) {
                    oldmax += 1.0f;
                }
                double[] x = new double[this.number_of_samples];
                double[] y = new double[this.number_of_samples];
                for (int i = 0; i < this.number_of_samples; ++i) {
                    y[i] = this.fvalues[i];
                    x[i] = this.old_fvalues[i];
                }
                Attribute y_attribute = AttributeFactory.createAttribute("functionvalue(" + this.nr_atts + ")", 4);
                Attribute x_attribute = AttributeFactory.createAttribute("functionvalue(" + (this.nr_atts - 1) + ")", 4);
                y_attribute.setMinimum(min);
                y_attribute.setMaximum(max);
                x_attribute.setMinimum(oldmin);
                x_attribute.setMaximum(oldmax);
                this.plotpanel = new AttributeFunctionValuePanel(this.source.getExampleSet(), this.source.getExampleColoring(), x_attribute, y_attribute, x, y, this.getParameterAsDouble("point_size"));
                System.out.println("colorattribute: " + this.colorattribute.getName());
                for (int i = 0; i < this.number_of_samples; ++i) {
                    System.out.println(this.colorsamples[i]);
                }
                this.plotpanel.colorByAttribute(this.colorattribute, this.colorsamples);
                this.plotpanel.setStartColor(this.startcolor);
                this.plotpanel.setEndColor(this.endcolor);
                this.plotpanel.initColorTable();
                if (this.nr_atts < this.number_atts) {
                    ((AttributeFunctionValuePanel)this.plotpanel).setDrawBounds(false);
                }
            } else if (plottype.equals(animationplot[3])) {
                float min = Float.POSITIVE_INFINITY;
                float max = Float.NEGATIVE_INFINITY;
                float oldmin = Float.POSITIVE_INFINITY;
                float oldmax = Float.NEGATIVE_INFINITY;
                for (int i = 0; i < this.number_of_samples; ++i) {
                    min = Math.min(min, this.fvalues[i]);
                    max = Math.max(max, this.fvalues[i]);
                    oldmin = Math.min(oldmin, this.samples[this.attribute_index[this.nr_atts]][i]);
                    oldmax = Math.max(oldmax, this.samples[this.attribute_index[this.nr_atts]][i]);
                }
                if (oldmin == oldmax) {
                    oldmax += 1.0f;
                }
                double[] x = new double[this.number_of_samples];
                double[] y = new double[this.number_of_samples];
                for (int i = 0; i < this.number_of_samples; ++i) {
                    y[i] = this.fvalues[i];
                    x[i] = this.samples[this.attribute_index[this.nr_atts]][i];
                }
                Attribute y_attribute = AttributeFactory.createAttribute("functionvalue(" + this.nr_atts + ")", 4);
                Attribute x_attribute = AttributeFactory.createAttribute(this.attributes[this.attribute_index[this.nr_atts]].getName(), 4);
                y_attribute.setMinimum(min);
                y_attribute.setMaximum(max);
                x_attribute.setMinimum(oldmin);
                x_attribute.setMaximum(oldmax);
                this.plotpanel = new AttributeFunctionValuePanel(this.source.getExampleSet(), this.source.getExampleColoring(), x_attribute, y_attribute, x, y, this.getParameterAsDouble("point_size"));
                this.plotpanel.colorByAttribute(this.colorattribute, this.colorsamples);
                this.plotpanel.setStartColor(this.startcolor);
                this.plotpanel.setEndColor(this.endcolor);
                this.plotpanel.initColorTable();
                if (this.nr_atts < this.number_atts) {
                    ((AttributeFunctionValuePanel)this.plotpanel).setDrawBounds(false);
                }
            } else {
                this.plotpanel = new HistogramNumeric(this.source.getExampleSet(), this.source.getExampleColoring(), set.getPredictedLabel(), this.fvalues);
                this.plotpanel.colorByAttribute(set.getLabel(), this.labelvalues);
                Color start_color = this.source.getExampleColoring().getStartColorOfLabel(set.getLabel());
                Color end_color = this.source.getExampleColoring().getEndColorOfLabel(set.getLabel());
                this.plotpanel.setStartColor(start_color);
                this.plotpanel.setEndColor(end_color);
                this.plotpanel.initColorTable();
                ((HistogramNumeric)this.plotpanel).setIntervalsManually(this.getParameterAsBoolean("interval_manual"));
                ((HistogramNumeric)this.plotpanel).setNumberOfIntervals(this.getParameterAsInt("intervals"));
            }
            this.plotpanel.setTitle(this.getParameterAsString("title"));
            this.plotpanel.setDrawTitle(this.getParameterAsBoolean("show title"));
            this.plotpanel.setBackgroundColor(this.getParameterAsColor("background"));
            this.plotpanel.setForegroundColor(this.getParameterAsColor("foreground"));
            MovingListener movinglistener = new MovingListener(this.plotpanel);
            ZoomingListener zoominlistener = new ZoomingListener(this.plotpanel);
            this.plotpanel.addMouseListener(movinglistener);
            this.plotpanel.addMouseMotionListener(movinglistener);
            this.plotpanel.addMouseListener(zoominlistener);
            this.plotpanel.addMouseMotionListener(zoominlistener);
        }
    }

    public JPanel getPlotPanel() {
        return this.display;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeStringCategory("plot_type", "The plot to be animated.", animationplot, animationplot[0]));
        ParameterTypeSingle type = new ParameterTypeBoolean("interval_manual", "Calculate the histogram with the specified number of imtervals, else calculate number of intervals.", false);
        types.add(type);
        type = new ParameterTypeInt("intervals", "Number of intervals.", 1, 1000, 5);
        types.add(type);
        type = new ParameterTypeDouble("point_size", "Size of the points.", 0.0, 100.0, 5.0);
        types.add(type);
        type = new ParameterTypeDynamicCategory("color_attribute", "This attribute is the color-dimension.", this.getColorAttributes(), 0);
        types.add(type);
        type = new ParameterTypeBoolean("iterate_automatic", "Iterates over all attributes and displayes then the result.", false);
        types.add(type);
        type = new ParameterTypeInt("nr_attributes", "The number of attributes added in each iteration.", 0, Integer.MAX_VALUE, 1);
        types.add(type);
        type = new ParameterTypeFile("model_file", "The file-location of the svm_model.", true);
        types.add(type);
        types.add(new ParameterTypeStringCategory("performance", "The performance used to find the threshold.", performance, performance[0]));
        types.add(new ParameterTypeDouble("C_neg", "The costs assigned when an example of the negative class is classified as positive.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeDouble("C_pos", "The costs assigned when an example of the positive class is classified as negative", 0.0, Double.POSITIVE_INFINITY, 1.0));
        return types;
    }

    public void compile() throws CompilerException {
        boolean haspredlabel;
        this.iscompiling = true;
        if (this.source == null) {
            throw new CompilerException("Cannot compile FunctionValueHistogram.");
        }
        edu.udo.cs.yale.example.ExampleSet set = this.source.getExampleSet();
        this.number_of_samples = set.getSize();
        this.number_atts = set.getNumberOfAttributes();
        this.attr_names = new String[this.number_atts];
        for (int att = 0; att < set.getNumberOfAttributes(); ++att) {
            this.attr_names[att] = set.getAttribute(att).getName();
        }
        this.labelvalues = new float[this.number_of_samples];
        this.predvalues = new float[this.number_of_samples];
        this.old_fvalues = new float[this.number_of_samples];
        this.fvalues = new float[this.number_of_samples];
        this.samples = new float[this.number_atts][this.number_of_samples];
        boolean haslabel = set.getLabel() != null;
        boolean bl = haspredlabel = set.getPredictedLabel() != null;
        if (!haslabel || !haspredlabel) {
            throw new CompilerException("The ExampleSet must have a label and a prediction. The prediction must be a numerical attribute!");
        }
        if (!set.getPredictedLabel().isNumerical()) {
            throw new CompilerException("The prediction must be numeric!");
        }
        this.label = set.getLabel();
        this.attributes = new Attribute[set.getNumberOfAttributes()];
        for (int a = 0; a < set.getNumberOfAttributes(); ++a) {
            this.attributes[a] = set.getAttribute(a);
        }
        if (this.getParameterAsInt("color_attribute") != 0) {
            this.colorsamples = new float[this.number_of_samples];
        }
        this.c_attr = this.getParameterAsInt("color_attribute") - 1;
        if (this.c_attr >= 0) {
            this.colorattribute = this.c_attr < this.number_atts ? set.getAttribute(this.c_attr) : (this.c_attr == this.number_atts && set.getLabel() != null ? set.getLabel() : set.getPredictedLabel());
        }
        ExampleReader reader = set.getExampleReader();
        for (int sample = 0; sample < this.number_of_samples; ++sample) {
            edu.udo.cs.yale.example.Example example = reader.next();
            this.old_fvalues[sample] = 0.0f;
            this.fvalues[sample] = 0.0f;
            for (int d = 0; d < this.number_atts; ++d) {
                this.samples[d][sample] = (float)example.getValue(d);
            }
            if (haslabel) {
                this.labelvalues[sample] = (float)example.getLabel();
            }
            if (haspredlabel) {
                this.predvalues[sample] = (float)example.getPredictedLabel();
            }
            if (this.c_attr < 0) continue;
            this.colorsamples[sample] = this.c_attr < this.number_atts ? (float)example.getValue(this.c_attr) : (this.c_attr == this.number_atts && set.getLabel() != null ? (float)example.getLabel() : (float)example.getPredictedLabel());
        }
        this.orig_labelvalues = new float[this.number_of_samples];
        System.arraycopy(this.labelvalues, 0, this.orig_labelvalues, 0, this.labelvalues.length);
        String color_attribute = ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).getValues()[this.getParameterAsInt("color_attribute")];
        if (!color_attribute.equals("<None>")) {
            if (haslabel && color_attribute.equals(set.getLabel().getName())) {
                this.startcolor = this.source.getExampleColoring().getStartColorOfLabel(this.colorattribute);
                this.endcolor = this.source.getExampleColoring().getEndColorOfLabel(this.colorattribute);
            } else if (haspredlabel && color_attribute.equals(this.source.getExampleSet().getPredictedLabel().getName()) && this.colorattribute.isNumerical()) {
                this.startcolor = this.source.getExampleColoring().getStartColorOfPredLabel(this.colorattribute);
                this.endcolor = this.source.getExampleColoring().getEndColorOfPredLabel(this.colorattribute);
            } else {
                this.startcolor = this.source.getExampleColoring().getStartColorOfAttribute(this.colorattribute);
                this.endcolor = this.source.getExampleColoring().getEndColorOfAttribute(this.colorattribute);
            }
        }
        this.attribute_index = new int[this.number_atts];
        for (int i = 0; i < this.attribute_index.length; ++i) {
            this.attribute_index[i] = i;
        }
        this.readModel();
        this.modelSet = this.jmysvmmodel.getExampleSet();
        this.trainSet = new ExampleSet(set, set.getLabel(), this.modelSet.getMeanVariances());
        SVMInterface svm2 = this.jmysvmmodel.createSVM();
        svm2.init(this.jmysvmmodel.getKernel(), this.jmysvmmodel.getExampleSet());
        this.weights = svm2.getWeights();
        this.orderWeights(this.weights);
        String props = new String("\n");
        props = props + Utils.getString("Attribute", 25, 0) + "| " + Utils.getString("Weight", 25, 0) + "\n";
        props = props + Utils.duplicateString("-", 25) + "+ " + Utils.duplicateString("-", 25) + "\n";
        for (int i = 0; i < 100 && i < this.weights.length; ++i) {
            props = props + Utils.getString(this.attributes[this.attribute_index[i]].getName(), 25, 0) + "| " + Utils.getString(Double.toString(this.weights[i]), 25, 1) + "\n";
        }
        Logger.logMessage(props, 3);
        this.nr_atts = this.getParameterAsInt("nr_attributes");
        this.calculateFunctionValues();
        this.initComponents();
        this.anzahl_perf = 0;
        this.perf_data = new LinkedList();
        String perf_index = this.getParameterAsString("performance");
        if (perf_index.equals(performance[0])) {
            this.findThresholdROC();
        } else {
            this.findThreshold();
        }
        if (this.getParameterAsBoolean("iterate_automatic")) {
            while (this.nr_atts < this.number_atts) {
                this.actionPerformed(null);
            }
        }
        this.iscompiling = false;
        this.iscompiled = true;
    }

    private void readModel() throws CompilerException {
        String filename = this.getParameterAsString("model_file");
        File modelFile = new File(filename);
        Model model = null;
        try {
            model = Model.readModel(modelFile);
        }
        catch (IOException e) {
            throw new CompilerException(e.getMessage(), e);
        }
        catch (OperatorException e) {
            throw new CompilerException(e.getMessage(), e);
        }
        if (!(model instanceof JMySVMModel)) {
            throw new CompilerException("Only JMySVMModels can be loaded!");
        }
        this.jmysvmmodel = (JMySVMModel)model;
    }

    private void calculateFunctionValues() {
        int i;
        System.arraycopy(this.fvalues, 0, this.old_fvalues, 0, this.number_of_samples);
        boolean[] att_isindexed = new boolean[this.number_atts];
        for (i = 0; i < this.number_atts; ++i) {
            att_isindexed[i] = false;
        }
        for (i = 0; i < this.nr_atts; ++i) {
            att_isindexed[this.attribute_index[i]] = true;
        }
        this.fvalues = new float[this.number_of_samples];
        for (i = 0; i < this.number_of_samples; ++i) {
            this.fvalues[i] = 0.0f;
            double[] atts = new double[this.number_atts];
            int[] index = new int[this.number_atts];
            Example example = this.trainSet.get_example(i);
            atts = example.toDense(this.number_atts);
            for (int d = 0; d < this.number_atts; ++d) {
                if (!att_isindexed[d]) {
                    atts[d] = 0.0;
                }
                index[d] = d;
            }
            example = new Example(index, atts);
            double the_sum = this.modelSet.get_b();
            double[] alphas = this.modelSet.get_alphas();
            for (int j = 0; j < this.modelSet.count_examples(); ++j) {
                double alpha = alphas[j];
                if (alpha == 0.0) continue;
                int[] sv_index = new int[this.number_atts];
                double[] sv_att = this.modelSet.get_example(j).toDense(this.number_atts);
                double[] sv_atts = new double[this.number_atts];
                for (int d = 0; d < this.number_atts; ++d) {
                    sv_atts[d] = att_isindexed[d] ? sv_att[d] : 0.0;
                    sv_index[d] = d;
                }
                the_sum += alpha * this.jmysvmmodel.getKernel().calculate_K(sv_index, sv_att, example.index, example.att);
            }
            this.fvalues[i] = (float)the_sum;
        }
    }

    public void orderWeights(double[] array, int links, int rechts) {
        int left = links;
        int right = rechts;
        double pivot = array[(links + rechts) / 2];
        pivot = Math.abs(pivot);
        while (true) {
            if (Math.abs(array[left]) > pivot) {
                ++left;
                continue;
            }
            while (Math.abs(array[right]) < pivot) {
                --right;
            }
            if (left <= right) {
                double temp = array[left];
                array[left] = array[right];
                array[right] = temp;
                temp = this.attribute_index[left];
                this.attribute_index[left] = this.attribute_index[right];
                this.attribute_index[right] = (int)temp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (links < right) {
            this.orderWeights(array, links, right);
        }
        if (left < rechts) {
            this.orderWeights(array, left, rechts);
        }
    }

    public void orderWeights(double[] weights) {
        this.orderWeights(weights, 0, weights.length - 1);
    }

    private void getLabelValues() {
        System.arraycopy(this.orig_labelvalues, 0, this.labelvalues, 0, this.orig_labelvalues.length);
    }

    private String[] createAttributeList() {
        String[] list = new String[this.nr_atts];
        for (int i = 0; i < this.nr_atts; ++i) {
            list[this.nr_atts - 1 - i] = Integer.toString(i + 1) + ": " + this.attributes[this.attribute_index[i]].getName();
        }
        return list;
    }

    public void actionPerformed(ActionEvent arg0) {
        double[] x;
        int next_attributes = 1;
        try {
            next_attributes = Integer.parseInt(this.nextField.getText());
        }
        catch (NumberFormatException e) {
            next_attributes = 1;
        }
        this.nr_atts += next_attributes;
        this.nr_atts = Math.max(1, this.nr_atts);
        this.nr_atts = Math.min(this.nr_atts, this.number_atts);
        this.calculateFunctionValues();
        this.getLabelValues();
        this.attlist.setListData(this.createAttributeList());
        this.attlist.setSelectedIndex(0);
        String plottype = this.getParameterAsString("plot_type");
        if (plottype.equals(animationplot[0])) {
            if (this.nr_atts < this.number_atts) {
                ((FuncValueHistPanel)this.plotpanel).setDrawBounds(false);
            }
            ((FuncValueHistPanel)this.plotpanel).setValues(this.labelvalues, this.fvalues);
        } else if (plottype.equals(animationplot[2])) {
            if (this.nr_atts < this.number_atts) {
                ((AttributeFunctionValuePanel)this.plotpanel).setDrawBounds(false);
            }
            if (this.nr_atts == this.number_atts) {
                ((AttributeFunctionValuePanel)this.plotpanel).setDrawBounds(true);
            }
            x = new double[this.number_of_samples];
            double[] y = new double[this.number_of_samples];
            for (int i = 0; i < this.number_of_samples; ++i) {
                y[i] = this.fvalues[i];
                x[i] = this.old_fvalues[i];
            }
            Attribute y_attribute = AttributeFactory.createAttribute("functionvalue(" + this.nr_atts + ")", 4);
            Attribute x_attribute = AttributeFactory.createAttribute("functionvalue(" + (this.nr_atts - 1) + ")", 4);
            ((AttributeFunctionValuePanel)this.plotpanel).setXAttribute(x_attribute);
            ((AttributeFunctionValuePanel)this.plotpanel).setYAttribute(y_attribute);
            ((AttributeFunctionValuePanel)this.plotpanel).setValues(x, y);
        } else if (plottype.equals(animationplot[3])) {
            if (this.nr_atts < this.number_atts) {
                ((AttributeFunctionValuePanel)this.plotpanel).setDrawBounds(false);
            }
            if (this.nr_atts == this.number_atts) {
                ((AttributeFunctionValuePanel)this.plotpanel).setDrawBounds(true);
            }
            x = new double[this.number_of_samples];
            double[] y = new double[this.number_of_samples];
            for (int i = 0; i < this.number_of_samples; ++i) {
                y[i] = this.fvalues[i];
                x[i] = this.samples[this.attribute_index[this.nr_atts]][i];
            }
            Attribute x_attribute = AttributeFactory.createAttribute(this.attributes[this.attribute_index[this.nr_atts - 1]].getName(), 4);
            ((AttributeFunctionValuePanel)this.plotpanel).setXAttribute(x_attribute);
            ((AttributeFunctionValuePanel)this.plotpanel).setValues(x, y);
        } else {
            ((HistogramNumeric)this.plotpanel).setValues(this.fvalues);
            this.plotpanel.colorByAttribute(this.label, this.labelvalues);
        }
        String perf_index = this.getParameterAsString("performance");
        if (perf_index.equals(performance[0])) {
            this.findThresholdROC();
        } else {
            this.findThreshold();
        }
        this.plotpanel.repaint();
    }

    private void findThresholdROC() {
        double costRatio;
        Object[] calArray = new WeightedConfidenceAndLabel[this.number_of_samples];
        for (int s = 0; s < this.number_of_samples; ++s) {
            calArray[s] = new WeightedConfidenceAndLabel(this.fvalues[s], this.labelvalues[s]);
        }
        Arrays.sort(calArray);
        int negativeLabelIndex = this.label.getNegativeIndex();
        int positiveLabelIndex = this.label.getPositiveIndex();
        double cost_neg = this.getParameterAsDouble("C_neg");
        double cost_pos = this.getParameterAsDouble("C_pos");
        double slope = costRatio = cost_neg / cost_pos;
        double tp = 0.0;
        double sum = 0.0;
        double bestIsometricsTpValue = 0.0;
        double bestThreshold = 1.0;
        LinkedList<double[]> statsData = new LinkedList<double[]>();
        statsData.add(new double[]{0.0, 0.0});
        for (int i = 0; i < calArray.length; ++i) {
            Object wcl = calArray[i];
            double weight = ((WeightedConfidenceAndLabel)wcl).getWeight();
            double fp = sum - tp;
            double c = tp - fp * slope;
            if (((WeightedConfidenceAndLabel)wcl).getLabel() == (double)positiveLabelIndex) {
                tp += weight;
            } else if (c > bestIsometricsTpValue) {
                bestIsometricsTpValue = c;
                bestThreshold = ((WeightedConfidenceAndLabel)wcl).getConfidence();
            }
            statsData.add(new double[]{fp, tp});
            sum += weight;
        }
        double sumPos = tp;
        double sumNeg = sum - sumPos;
        bestIsometricsTpValue /= sumPos;
        statsData.add(new double[]{sumNeg, sumPos});
        double aucSum = 0.0;
        double[] last = null;
        Statistics stats = new Statistics("ROCplot");
        stats.init(new String[]{"FP/N", "TP/P", "Slope"});
        Iterator i = statsData.iterator();
        boolean first = true;
        int pointCounter = 0;
        int eachPoint = (int)Math.round((double)statsData.size() / 200.0);
        while (i.hasNext()) {
            double[] point = (double[])i.next();
            double fpDivN = point[0] / sumNeg;
            double tpDivP = point[1] / sumPos;
            if (eachPoint < 1 || pointCounter % eachPoint == 0) {
                stats.add(new Object[]{new Double(fpDivN), new Double(tpDivP), new Double(bestIsometricsTpValue + fpDivN * slope * (sumNeg / sumPos))});
            }
            if (last != null) {
                aucSum += (tpDivP - last[1]) * (fpDivN - last[0]) / 2.0 + last[1] * (fpDivN - last[0]);
            }
            last = new double[]{fpDivN, tpDivP};
            ++pointCounter;
        }
        if (this.rocpanel.getComponentCount() > 1) {
            this.rocpanel.remove(this.rocplot);
        }
        ColorPlotter plotter = new ColorPlotter(stats);
        plotter.setAxis(0, 0);
        plotter.setPlotColumn(1, true);
        plotter.setPlotColumn(2, true);
        plotter.setDrawRange(0.0, 1.0, 0.0, 1.0);
        this.rocplot = plotter.getPlotter();
        this.rocpanel.add(this.rocplot, "Center");
        this.rocpanel.repaint();
        if (this.aucpanel.getComponentCount() > 1) {
            this.aucpanel.remove(0);
        }
        this.aucPerformanceVector = new PerformanceVector();
        this.aucPerformanceVector.addCriterion(new EstimatedPerformance("AUC", aucSum, 1, false));
        this.aucPerformanceVector.addCriterion(new EstimatedPerformance("Threshold", bestThreshold, 1, false));
        this.aucPerformanceVector.setMainCriterionName("AUC");
        this.aucpanel.add(this.aucPerformanceVector.getVisualisationComponent(), "Center");
        this.aucpanel.repaint();
        this.addPerformance(this.nr_atts, aucSum);
        String plottype = this.getParameterAsString("plot_type");
        if (plottype.equals(animationplot[0])) {
            ((FuncValueHistPanel)this.plotpanel).setDrawLineForValue((float)bestThreshold);
        } else if (plottype.equals(animationplot[2])) {
            ((AttributeFunctionValuePanel)this.plotpanel).setDrawLineForValue(bestThreshold);
        } else {
            ((HistogramNumeric)this.plotpanel).setDrawLineForValue((float)bestThreshold);
        }
        this.tabbedpane.revalidate();
        this.tabbedpane.repaint();
    }

    private void findThreshold() {
        Object[] calArray = new WeightedConfidenceAndLabel[this.number_of_samples];
        for (int s = 0; s < this.number_of_samples; ++s) {
            calArray[s] = new WeightedConfidenceAndLabel(this.fvalues[s], this.labelvalues[s]);
        }
        Arrays.sort(calArray);
        int negativeLabelIndex = this.label.getNegativeIndex();
        int positiveLabelIndex = this.label.getPositiveIndex();
        int sumpos = 0;
        int sumneg = 0;
        String perf_index = this.getParameterAsString("performance");
        for (int i = 0; i < calArray.length; ++i) {
            Object wcl = calArray[i];
            if (((WeightedConfidenceAndLabel)wcl).getLabel() == (double)positiveLabelIndex) {
                ++sumpos;
                continue;
            }
            ++sumneg;
        }
        int tp = sumpos;
        int fp = sumneg;
        int tn = 0;
        int fn = 0;
        double bestThreshold = 0.0;
        double bestPerf = 0.0;
        int bestIndex = 0;
        double perf = 0.0;
        for (int i = calArray.length - 1; i >= 0; --i) {
            Object wcl = calArray[i];
            double labelvalue = ((WeightedConfidenceAndLabel)wcl).getLabel();
            double fvalue = ((WeightedConfidenceAndLabel)wcl).getConfidence();
            if (labelvalue == (double)negativeLabelIndex) {
                ++tn;
                --fp;
            } else {
                ++fn;
                --tp;
            }
            if (perf_index.equals(performance[1])) {
                perf = this.getAccuracy(tp, tn);
            } else if (perf_index.equals(performance[2])) {
                perf = this.getPrecision(tp, fp);
            } else if (perf_index.equals(performance[3])) {
                perf = this.getRecall(tp, fn);
            } else if (perf_index.equals(performance[4])) {
                perf = this.getFallOut(fp, tn);
            } else if (perf_index.equals(performance[5])) {
                perf = this.getFMesure(tp, fp, fn);
            }
            if (i == calArray.length - 1) {
                bestThreshold = fvalue;
                bestPerf = perf;
                bestIndex = 0;
                continue;
            }
            if (!perf_index.equals(performance[4]) && perf > bestPerf) {
                bestThreshold = fvalue;
                bestPerf = perf;
                bestIndex = i;
                continue;
            }
            if (!perf_index.equals(performance[4]) || !(perf < bestPerf)) continue;
            bestThreshold = fvalue;
            bestPerf = perf;
            bestIndex = i;
        }
        if (bestIndex < calArray.length - 1) {
            bestThreshold = (((WeightedConfidenceAndLabel)calArray[bestIndex]).getConfidence() + ((WeightedConfidenceAndLabel)calArray[bestIndex + 1]).getConfidence()) / 2.0;
        }
        if (this.aucpanel.getComponentCount() > 0) {
            this.aucpanel.remove(0);
        }
        this.aucPerformanceVector = new PerformanceVector();
        this.aucPerformanceVector.addCriterion(new EstimatedPerformance(perf_index, bestPerf, 1, false));
        this.aucPerformanceVector.addCriterion(new EstimatedPerformance("Threshold", bestThreshold, 1, false));
        this.aucPerformanceVector.setMainCriterionName(perf_index);
        this.aucpanel.add(this.aucPerformanceVector.getVisualisationComponent(), "Center");
        this.aucpanel.repaint();
        this.addPerformance(this.nr_atts, bestPerf);
        String plottype = this.getParameterAsString("plot_type");
        if (plottype.equals(animationplot[0])) {
            ((FuncValueHistPanel)this.plotpanel).setDrawLineForValue((float)bestThreshold);
        } else if (plottype.equals(animationplot[2])) {
            ((AttributeFunctionValuePanel)this.plotpanel).setDrawLineForValue((float)bestThreshold);
        } else if (plottype.equals(animationplot[3])) {
            ((AttributeFunctionValuePanel)this.plotpanel).setDrawLineForValue((float)bestThreshold);
        } else {
            ((HistogramNumeric)this.plotpanel).setDrawLineForValue((float)bestThreshold);
        }
        this.tabbedpane.revalidate();
        this.tabbedpane.repaint();
    }

    private double getAccuracy(int tp, int tn) {
        double acc = (double)(tp + tn) / (double)this.number_of_samples;
        return acc;
    }

    private double getPrecision(int tp, int fp) {
        double p = (double)tp / (double)(tp + fp);
        return p;
    }

    private double getRecall(int tp, int fn) {
        double r = (double)tp / (double)(tp + fn);
        return r;
    }

    private double getFallOut(int fp, int tn) {
        double f = (double)fp / (double)(fp + tn);
        return f;
    }

    private double getFMesure(int tp, int fp, int fn) {
        double f = tp;
        f *= f;
        f = 2.0 * f;
        f /= f + (double)(tp * fn) + (double)(tp * fp);
        return f;
    }

    private void addPerformance(double att, double perf) {
        ++this.anzahl_perf;
        this.perf_data.add(new double[]{att, perf});
        String perf_index = this.getParameterAsString("performance");
        Statistics stats = new Statistics("PerformancePlot");
        stats.init(new String[]{"Attribute", perf_index});
        Iterator iter = this.perf_data.iterator();
        while (iter.hasNext()) {
            double[] values = (double[])iter.next();
            stats.add(new Object[]{new Double(values[0]), new Double(values[1])});
        }
        if (this.perfpanel.getComponentCount() > 1) {
            this.perfpanel.remove(this.perfplot);
        }
        ColorPlotter plotter = new ColorPlotter(stats);
        plotter.setAxis(0, 0);
        plotter.setPlotColumn(1, true);
        plotter.setDrawRange(0.0, this.number_atts, 0.0, 1.0);
        this.perfplot = plotter.getPlotter();
        this.perfpanel.add(this.perfplot, "Center");
        this.perfpanel.repaint();
    }

    public void parentIsCompiled() {
        ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).setValues(this.getColorAttributes());
    }

    public void refreshParameter() {
        ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).setValues(this.getColorAttributes());
    }

    public String[] getColorAttributes() {
        if (this.source == null) {
            return new String[]{"<None>"};
        }
        if (!this.source.isCompiled()) {
            return new String[]{"<None>"};
        }
        edu.udo.cs.yale.example.ExampleSet set = this.source.getExampleSet();
        if (set == null) {
            return new String[]{"<None>"};
        }
        int count = 1;
        count += set.getNumberOfAttributes();
        if (set.getLabel() != null) {
            ++count;
        }
        if (set.getPredictedLabel() != null) {
            ++count;
        }
        String[] categories = new String[count];
        categories[0] = "<None>";
        for (int i = 1; i <= set.getNumberOfAttributes(); ++i) {
            categories[i] = set.getAttribute(i - 1).getName();
        }
        int index = set.getNumberOfAttributes() + 1;
        if (set.getLabel() != null) {
            categories[index] = set.getLabel().getName();
            ++index;
        }
        if (set.getPredictedLabel() != null) {
            categories[index] = set.getPredictedLabel().getName();
            ++index;
        }
        return categories;
    }

    private class WeightedConfidenceAndLabel
    implements Comparable {
        private double confidence;
        private double label;
        private double weight = 1.0;

        public WeightedConfidenceAndLabel(double confidence, double label) {
            this.confidence = confidence;
            this.label = label;
        }

        public WeightedConfidenceAndLabel(double confidence, double label, double weight) {
            this(confidence, label);
            this.weight = weight;
        }

        public int compareTo(Object obj) {
            return -1 * Double.compare(this.confidence, ((WeightedConfidenceAndLabel)obj).confidence);
        }

        public double getLabel() {
            return this.label;
        }

        public double getConfidence() {
            return this.confidence;
        }

        public double getWeight() {
            return this.weight;
        }

        public String toString() {
            return "conf: " + this.confidence + ", label: " + this.label + ", weight: " + this.weight;
        }
    }
}

