/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot;

import edu.udo.cs.jvito.data.ExampleColoring;
import edu.udo.cs.jvito.plot.PlotPanel;
import edu.udo.cs.jvito.util.Resources;
import edu.udo.cs.yale.example.ExampleSet;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class SurveyAttributePanel
extends PlotPanel
implements MouseListener {
    private float[] values;
    private float min;
    private float max;
    private float band;
    private boolean mousepressed;
    private JWindow mousewindow;
    private JLabel indexlabel;
    private JLabel valuelabel;
    private ExampleSet set;
    private ExampleColoring coloring;

    public SurveyAttributePanel(ExampleSet set, ExampleColoring coloring, float[] values) {
        this.set = set;
        this.coloring = coloring;
        this.values = values;
        this.min = values[0];
        this.max = values[0];
        for (int i = 0; i < values.length; ++i) {
            this.min = Math.min(this.min, values[i]);
            this.max = Math.max(this.max, values[i]);
        }
        this.band = this.max - this.min;
        this.mousepressed = false;
        this.initMouseWindow();
        this.addMouseListener(this);
        this.addMouseMotionListener(new MyMouseMotionListener());
    }

    public SurveyAttributePanel(ExampleSet set, ExampleColoring coloring, float[] values, float min, float max) {
        this.set = set;
        this.coloring = coloring;
        this.values = values;
        this.min = min;
        this.max = max;
        this.band = max - min;
        this.mousepressed = false;
        this.initMouseWindow();
        this.addMouseListener(this);
        this.addMouseMotionListener(new MyMouseMotionListener());
    }

    private void initMouseWindow() {
        this.mousewindow = new JWindow();
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 1, 5, 5));
        Border bd1 = BorderFactory.createBevelBorder(0);
        Border bd2 = BorderFactory.createEtchedBorder();
        CompoundBorder bd3 = BorderFactory.createCompoundBorder(bd1, bd2);
        panel.setBorder(bd3);
        this.mousewindow.getContentPane().add(panel);
        this.indexlabel = new JLabel();
        this.indexlabel.setBackground(Resources.getColor("MOUSE_BACKGROUND"));
        this.indexlabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        panel.add(this.indexlabel);
        this.valuelabel = new JLabel();
        this.valuelabel.setBackground(Resources.getColor("MOUSE_BACKGROUND"));
        this.valuelabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        panel.add(this.valuelabel);
        this.mousewindow.pack();
        this.mousewindow.setSize(100, 50);
        this.mousewindow.setLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 2.0 - (double)(this.mousewindow.getWidth() / 2)), (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 2.0 - (double)(this.mousewindow.getHeight() / 2)));
    }

    private void setLabelText(int index) {
        this.indexlabel.setText("Index: " + index);
        this.valuelabel.setText("Value: " + this.getValue(index));
        this.mousewindow.repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
        int width = this.getSize().width;
        g.setColor(this.background);
        g.fillRect(0, 0, width, this.values.length);
        float colormin = 0.0f;
        float colormax = 0.0f;
        if (this.colorbyattribute) {
            for (int c = 0; c < this.colorvalues.length; ++c) {
                if (c == 0) {
                    colormin = this.colorvalues[0];
                    colormax = this.colorvalues[0];
                    continue;
                }
                colormin = Math.min(colormin, this.colorvalues[c]);
                colormax = Math.max(colormax, this.colorvalues[c]);
            }
        }
        g.setColor(this.foreground);
        for (int v = 0; v < this.values.length; ++v) {
            if (this.colorbyattribute) {
                int index;
                if (this.set.getLabel() != null && this.set.getLabel().getName().equals(this.colorattr.getName())) {
                    g.setColor(this.coloring.getColorOfLabelValue(this.colorattr, this.colorvalues[v]));
                } else if (this.set.getPredictedLabel() != null && this.set.getPredictedLabel().getName().equals(this.colorattr.getName())) {
                    if (this.colorattr.isNominal()) {
                        g.setColor(this.colortable[(int)this.colorvalues[v]]);
                    } else {
                        index = (int)((this.colorvalues[v] - colormin) / (colormax - colormin) * 99.0f);
                        if (index < 0) {
                            index = 0;
                        }
                        if (index > 99) {
                            index = 99;
                        }
                        g.setColor(this.colortable[index]);
                    }
                } else {
                    if (this.colorattr.isNominal()) {
                        g.setColor(this.colortable[(int)this.colorvalues[v]]);
                    }
                    if (this.colorattr.isNumerical()) {
                        index = (int)((this.colorvalues[v] - colormin) / (colormax - colormin) * 99.0f);
                        if (index < 0) {
                            index = 0;
                        }
                        if (index > 99) {
                            index = 99;
                        }
                        g.setColor(this.colortable[index]);
                    }
                }
            }
            float length = (this.values[v] - this.min) / this.band * (float)width;
            g.drawLine(0, v + 1, (int)length, v + 1);
        }
    }

    public float getValue(int y) {
        if (--y < 0) {
            y = 0;
        }
        if (y >= this.values.length) {
            y = this.values.length - 1;
        }
        return this.values[y];
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        if (event.getButton() == 2) {
            this.mousepressed = true;
            this.setLabelText(event.getY());
            this.mousewindow.setVisible(true);
        }
    }

    public void mouseReleased(MouseEvent event) {
        this.mousepressed = false;
        this.mousewindow.setVisible(false);
    }

    private class MyMouseMotionListener
    extends MouseMotionAdapter {
        private MyMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent event) {
            SurveyAttributePanel.this.setLabelText(event.getY());
        }
    }
}

