/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot;

import edu.udo.cs.jvito.plot.PlotPanel;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MovingListener
implements MouseListener,
MouseMotionListener {
    private boolean mousepressed = false;
    private PlotPanel panel;
    private int startx;
    private int starty;
    private int endx;
    private int endy;

    public MovingListener(PlotPanel panel) {
        this.panel = panel;
        this.startx = 0;
        this.starty = 0;
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent event) {
        if (!event.isControlDown()) {
            return;
        }
        if (event.getButton() == 1) {
            this.mousepressed = true;
            this.startx = event.getX();
            this.starty = event.getY();
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (event.getButton() == 1) {
            this.mousepressed = false;
            this.startx = 0;
            this.starty = 0;
        }
    }

    public void mouseDragged(MouseEvent event) {
        if (event.isControlDown() && this.mousepressed) {
            this.endx = event.getX();
            this.endy = event.getY();
            int dx = this.endx - this.startx;
            int dy = this.endy - this.starty;
            Point p = this.panel.getOrigin();
            this.panel.setOrigin(new Point(p.x + dx, p.y + dy));
            this.panel.repaint();
            this.startx = this.endx;
            this.starty = this.endy;
        }
    }

    public void mouseMoved(MouseEvent event) {
    }
}

