/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot;

public class Matrix {
    public static final double EPSILON = 1.0E-8;
    private double[][] original;
    private double[][] matrix;

    public Matrix(double[][] m) {
        this.matrix = m;
        this.original = this.copyMatrix(m);
    }

    public double[][] copyMatrix(double[][] m) {
        double[][] back = new double[m.length][];
        for (int i = 0; i < m.length; ++i) {
            back[i] = new double[m[i].length];
            System.arraycopy(m[i], 0, back[i], 0, m[i].length);
        }
        return back;
    }

    public double[] solveGAUSS() {
        if (this.checkMatrix()) {
            for (int i = 0; i < this.matrix.length; ++i) {
                this.makeZeros(i);
            }
            double[] res = new double[this.matrix.length];
            for (int i = this.matrix.length - 1; i >= 0; --i) {
                this.fillResult(res, i);
            }
            return res;
        }
        return null;
    }

    private void fillResult(double[] res, int row) {
        if (this.close(this.matrix[row][row], 0.0)) {
            res[row] = -1.0;
        } else {
            double val = this.matrix[row][this.matrix[row].length - 1];
            for (int i = this.matrix[row].length - 2; i > row; --i) {
                val -= this.matrix[row][i] * res[i];
            }
            res[row] = val /= this.matrix[row][row];
        }
    }

    private void makeZeros(int row) {
        int nonZeroRow;
        if (this.close(this.matrix[row][row], 0.0) && (nonZeroRow = this.findNonZero(row)) > -1) {
            double[] temp = this.matrix[row];
            this.matrix[row] = this.matrix[nonZeroRow];
            this.matrix[nonZeroRow] = temp;
        }
        if (!this.close(this.matrix[row][row], 0.0)) {
            for (int i = row + 1; i < this.matrix.length; ++i) {
                double factor = -1.0 * this.matrix[i][row] / this.matrix[row][row];
                this.addRows(factor, row, i);
                this.matrix[i][row] = 0.0;
            }
        }
    }

    private void addRows(double factorRow1, int row1, int row2) {
        for (int i = 0; i < this.matrix[row1].length; ++i) {
            this.matrix[row2][i] = factorRow1 * this.matrix[row1][i] + this.matrix[row2][i];
        }
    }

    private int findNonZero(int row) {
        for (int i = row + 1; i < this.matrix.length; ++i) {
            if (this.matrix[i][row] == 0.0) continue;
            return i;
        }
        return -1;
    }

    private boolean checkMatrix() {
        int lines = this.matrix.length;
        for (int i = 0; i < this.matrix.length; ++i) {
            if (this.matrix[i].length == lines + 1) continue;
            return false;
        }
        return true;
    }

    private boolean checkSolution(double[] sol) {
        return this.checkSolution(this.original, sol);
    }

    private boolean checkSolution(double[][] lgs, double[] sol) {
        for (int row = 0; row < lgs.length; ++row) {
            double sum = 0.0;
            for (int col = 0; col < lgs[row].length - 1; ++col) {
                sum += lgs[row][col] * sol[col];
            }
            if (this.close(sum, lgs[row][lgs[row].length - 1])) continue;
            return false;
        }
        return true;
    }

    private boolean close(double a, double b) {
        return Math.abs(a - b) < 1.0E-8;
    }
}

