/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot;

import edu.udo.cs.yale.example.Attribute;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JPanel;

public class ColorPanel
extends JPanel {
    private Attribute attr;
    private String[] classes;
    private Color[] colortable;
    private Color foreground;
    private Color background;
    private float min;
    private float max;
    private boolean nominalcolor = false;

    public ColorPanel(Attribute attribute, Color[] colortable, Color foreground, Color background) {
        this.attr = attribute;
        this.colortable = colortable;
        this.foreground = foreground;
        this.background = background;
        this.initClasses(attribute);
    }

    public ColorPanel(Attribute attribute, String[] classes, Color[] colortable, Color foreground, Color background) {
        this.attr = attribute;
        this.colortable = colortable;
        this.classes = classes;
        this.foreground = foreground;
        this.background = background;
    }

    public ColorPanel(float min, float max, Color[] colortable, Color foreground, Color background) {
        this.min = min;
        this.max = max;
        this.attr = null;
        this.colortable = colortable;
        this.foreground = foreground;
        this.background = background;
    }

    private void initClasses(Attribute label) {
        if (!label.isNominal()) {
            return;
        }
        Collection col = label.getValues();
        Iterator iter = col.iterator();
        this.classes = new String[col.size()];
        for (int index = 0; index < this.classes.length; ++index) {
            this.classes[index] = (String)iter.next();
        }
        if (this.classes.length == this.colortable.length) {
            this.nominalcolor = true;
        }
    }

    public void paint(Graphics g) {
        block4: {
            block5: {
                block3: {
                    Dimension size = this.getSize();
                    g.setColor(this.background);
                    g.fillRect(0, 0, size.width, size.height);
                    g.setColor(this.foreground);
                    if (this.attr != null) break block3;
                    g.setColor(this.foreground);
                    g.drawRect(9, 9, 51, 201);
                    float delta = (this.max - this.min) / 4.0f;
                    g.drawLine(61, 10, 65, 10);
                    g.drawString(Float.toString(this.min), 65, 10);
                    for (int c = 0; c < this.colortable.length; ++c) {
                        g.setColor(this.colortable[c]);
                        g.fillRect(10, 10 + c * 2, 50, 2);
                        if ((c + 1) % 25 != 0) continue;
                        this.min += delta;
                        g.setColor(this.foreground);
                        g.drawLine(61, 10 + c * 2, 65, 10 + c * 2);
                        g.drawString(Float.toString(this.min), 67, 15 + c * 2);
                    }
                    break block4;
                }
                if (!this.attr.isNominal()) break block5;
                for (int i = 0; i < this.classes.length && i < this.colortable.length; ++i) {
                    g.setColor(this.foreground);
                    g.drawString(this.classes[i], 50, 30 + i * 35);
                    g.setColor(this.colortable[i]);
                    g.fillRect(10, 10 + i * 35, 25, 25);
                }
                break block4;
            }
            if (!this.attr.isNumerical()) break block4;
            g.setColor(this.foreground);
            g.drawRect(9, 9, 51, 201);
            float min = (float)this.attr.getMinimum();
            float max = (float)this.attr.getMaximum();
            float delta = (max - min) / 4.0f;
            g.drawLine(61, 10, 65, 10);
            g.drawString(Float.toString(min), 65, 10);
            for (int c = 0; c < this.colortable.length; ++c) {
                g.setColor(this.colortable[c]);
                g.fillRect(10, 10 + c * 2, 50, 2);
                if ((c + 1) % 25 != 0) continue;
                g.setColor(this.foreground);
                g.drawLine(61, 10 + c * 2, 65, 10 + c * 2);
                g.drawString(Float.toString(min += delta), 67, 15 + c * 2);
            }
        }
    }
}

