/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot;

import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.jvito.parameter.ParameterTypeDynamicCategory;
import edu.udo.cs.jvito.plot.CircularCoordinatesPanel;
import edu.udo.cs.jvito.plot.ColorPanel;
import edu.udo.cs.jvito.plot.MovingListener;
import edu.udo.cs.jvito.plot.SimplePlot;
import edu.udo.cs.jvito.plot.ZoomingListener;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CircularCoordinates
extends SimplePlot {
    private JPanel mainpane;
    private JPanel settings;
    private String[] attr_names = new String[0];
    private int number_atts = 0;
    private int number_of_samples = 0;
    private float[][] samples;
    private float[] minima;
    private float[] maxima;
    private float[] labelvalues;
    private float[] predvalues;
    private String[] classes;
    private String labelname;
    private int c_attr = 0;
    private JComboBox c_cbox;
    private JList attlist;

    public JPanel getPlotPanel() {
        if (!this.isCompiled()) {
            return null;
        }
        return this.mainpane;
    }

    private void initComponents() {
        this.initDisplay();
        this.mainpane = new JPanel();
        this.mainpane.setLayout(new BorderLayout(5, 5));
        this.settings = new JPanel();
        this.settings.setLayout(new BorderLayout(5, 5));
        this.mainpane.add((Component)this.settings, "East");
        JPanel settings2 = new JPanel();
        settings2.setLayout(new GridLayout(2, 1, 5, 5));
        this.settings.add((Component)settings2, "Center");
        ExampleSet set = this.source.getExampleSet();
        if (this.getParameterAsInt("color_attribute") != 0) {
            JPanel colorpanel = this.plotpanel.getColorPanel();
            if (this.getParameterAsInt("color_attribute") > set.getNumberOfAttributes()) {
                Object[] valuesstr;
                Collection values;
                Color[] colors;
                if (set.getLabel() != null && set.getLabel().isNominal() && this.getParameterAsInt("color_attribute") == set.getNumberOfAttributes() + 1) {
                    colors = new Color[set.getLabel().getValues().size()];
                    values = set.getLabel().getValues();
                    valuesstr = values.toArray();
                    for (int i = 0; i < valuesstr.length; ++i) {
                        colors[i] = this.source.getExampleColoring().getColorOfLabelValue(set.getLabel(), (String)valuesstr[i]);
                    }
                    colorpanel = new ColorPanel(set.getLabel(), colors, this.getParameterAsColor("foreground"), this.getParameterAsColor("background"));
                } else if (set.getPredictedLabel() != null && set.getPredictedLabel().isNominal()) {
                    values = set.getPredictedLabel().getValues();
                    valuesstr = values.toArray();
                    colors = new Color[set.getPredictedLabel().getValues().size() * set.getPredictedLabel().getValues().size()];
                    String[] valuestring = new String[valuesstr.length * valuesstr.length];
                    for (int i = 0; i < valuesstr.length; ++i) {
                        for (int j = 0; j < valuesstr.length; ++j) {
                            valuestring[i * valuesstr.length + j] = new String((String)valuesstr[i] + " - " + (String)valuesstr[j]);
                            colors[i * valuesstr.length + j] = this.source.getExampleColoring().getColorOfLabelvsPred(set.getLabel(), set.getPredictedLabel(), (String)valuesstr[i], (String)valuesstr[j]);
                        }
                    }
                    colorpanel = new ColorPanel(set.getPredictedLabel(), valuestring, colors, this.getParameterAsColor("foreground"), this.getParameterAsColor("background"));
                }
            }
            if (set.getPredictedLabel() != null) {
                colorpanel.setPreferredSize(new Dimension(125, colorpanel.getHeight()));
            }
            settings2.add(colorpanel);
        }
        if (this.getParameterAsBoolean("label_axis")) {
            int s = this.attr_names.length;
            if (this.source.getExampleSet().getLabel() != null) {
                ++s;
            }
            if (this.source.getExampleSet().getPredictedLabel() != null) {
                ++s;
            }
            String[] atts = new String[s];
            for (int i = 0; i < this.attr_names.length; ++i) {
                atts[i] = new String(Integer.toString(i + 1) + " " + this.attr_names[i]);
            }
            if (this.source.getExampleSet().getLabel() != null) {
                atts[this.attr_names.length] = new String("label: " + this.source.getExampleSet().getLabel().getName());
            }
            if (this.source.getExampleSet().getPredictedLabel() != null) {
                atts[s - 1] = new String("prediction: " + this.source.getExampleSet().getPredictedLabel().getName());
            }
            this.attlist = new JList<String>(atts);
            JScrollPane attscpane = new JScrollPane(this.attlist);
            settings2.add(attscpane);
        }
        this.mainpane.add((Component)this.plotpanel, "Center");
    }

    private void initDisplay() {
        ExampleSet set = this.source.getExampleSet();
        boolean haslabel = this.source.getExampleSet().getLabel() != null;
        boolean haspredlabel = this.source.getExampleSet().getPredictedLabel() != null;
        this.plotpanel = new CircularCoordinatesPanel(this.source.getExampleSet(), this.source.getExampleColoring(), this.samples, this.getParameterAsBoolean("label_axis"));
        this.plotpanel.setTitle(this.getParameterAsString("title"));
        this.plotpanel.setDrawTitle(this.getParameterAsBoolean("show title"));
        this.plotpanel.setForegroundColor(this.getParameterAsColor("foreground"));
        this.plotpanel.setBackgroundColor(this.getParameterAsColor("background"));
        this.plotpanel.setStartColor(this.getParameterAsColor("start_color"));
        this.plotpanel.setEndColor(this.getParameterAsColor("end_color"));
        MovingListener movinglistener = new MovingListener(this.plotpanel);
        ZoomingListener zoominlistener = new ZoomingListener(this.plotpanel);
        this.plotpanel.addMouseListener(movinglistener);
        this.plotpanel.addMouseMotionListener(movinglistener);
        this.plotpanel.addMouseListener(zoominlistener);
        this.plotpanel.addMouseMotionListener(zoominlistener);
        String color_attribute = ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).getValues()[this.getParameterAsInt("color_attribute")];
        Attribute prediction = set.getPredictedLabel();
        if (!color_attribute.equals("<None>")) {
            if (haslabel && color_attribute.equals(this.source.getExampleSet().getLabel().getName())) {
                this.plotpanel.colorByAttribute(this.source.getExampleSet().getLabel(), this.labelvalues);
                this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfAttribute(this.source.getExampleSet().getLabel()));
                this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfAttribute(this.source.getExampleSet().getLabel()));
                this.plotpanel.initColorTable();
            } else if (haspredlabel && color_attribute.equals(this.source.getExampleSet().getPredictedLabel().getName()) && prediction.isNominal()) {
                Collection values = set.getPredictedLabel().getValues();
                Object[] valuesstr = values.toArray();
                Color[] colors = new Color[set.getPredictedLabel().getValues().size() * set.getPredictedLabel().getValues().size()];
                for (int i = 0; i < valuesstr.length; ++i) {
                    for (int j = 0; j < valuesstr.length; ++j) {
                        colors[i * valuesstr.length + j] = this.source.getExampleColoring().getColorOfLabelvsPred(set.getLabel(), set.getPredictedLabel(), (String)valuesstr[i], (String)valuesstr[j]);
                    }
                }
                float[] pvalues = new float[this.number_of_samples];
                for (int i = 0; i < this.predvalues.length; ++i) {
                    pvalues[i] = this.labelvalues[i] * (float)valuesstr.length + this.predvalues[i];
                }
                this.plotpanel.colorByAttribute(prediction, pvalues, colors);
                this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfPredLabel(prediction));
                this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfPredLabel(prediction));
            } else if (haspredlabel && color_attribute.equals(this.source.getExampleSet().getPredictedLabel().getName()) && prediction.isNumerical()) {
                this.plotpanel.colorByAttribute(prediction, this.predvalues);
                this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfPredLabel(prediction));
                this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfPredLabel(prediction));
                this.plotpanel.initColorTable();
            } else if (!color_attribute.equals("")) {
                this.plotpanel.colorByAttribute(this.source.getExampleSet().getAttribute(color_attribute), this.samples[this.getParameterAsInt("color_attribute") - 1]);
                this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfAttribute(this.source.getExampleSet().getAttribute(color_attribute)));
                this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfAttribute(this.source.getExampleSet().getAttribute(color_attribute)));
                this.plotpanel.initColorTable();
            }
        }
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeBoolean("local_normalization", "The data have to be local normalized, otherwise global normalized.", false);
        types.add(type);
        type = new ParameterTypeDynamicCategory("color_attribute", "This attribute is the color-dimension.", this.getColorAttributes(), 0);
        types.add(type);
        type = new ParameterTypeBoolean("draw_axis", "Draw the radial axis.", true);
        types.add(type);
        type = new ParameterTypeBoolean("label_axis", "Label the axis.", true);
        types.add(type);
        return types;
    }

    public void compile() throws CompilerException {
        int d;
        if (!this.source.isCompiled()) {
            return;
        }
        this.iscompiling = true;
        ExampleSet set = this.source.getExampleSet();
        boolean haslabel = set.getLabel() != null;
        boolean haspredlabel = set.getPredictedLabel() != null;
        this.number_of_samples = set.getSize();
        this.number_atts = set.getNumberOfAttributes();
        this.attr_names = new String[this.number_atts];
        this.c_attr = Math.max(0, this.getParameterAsInt("color_attribute") - 1);
        for (int att = 0; att < this.number_atts; ++att) {
            this.attr_names[att] = set.getAttribute(att).getName();
        }
        if (haslabel || haspredlabel) {
            this.initClassNames();
        }
        this.samples = new float[this.number_atts][this.number_of_samples];
        this.labelvalues = new float[this.number_of_samples];
        this.predvalues = new float[this.number_of_samples];
        ExampleReader reader = set.getExampleReader();
        for (int sample = 0; sample < this.number_of_samples; ++sample) {
            Example example = reader.next();
            for (d = 0; d < this.number_atts; ++d) {
                this.samples[d][sample] = (float)example.getValue(d);
            }
            if (haslabel) {
                this.labelvalues[sample] = (float)example.getLabel();
            }
            if (!haspredlabel) continue;
            this.predvalues[sample] = (float)example.getPredictedLabel();
        }
        this.minima = new float[this.number_atts];
        this.maxima = new float[this.number_atts];
        for (d = 0; d < this.number_atts; ++d) {
            Attribute a = set.getAttribute(d);
            if (a.isNominal()) {
                this.minima[d] = 0.0f;
                this.maxima[d] = a.getNumberOfValues() - 1;
            }
            if (!a.isNumerical()) continue;
            this.minima[d] = (float)a.getMinimum();
            this.maxima[d] = (float)a.getMaximum();
        }
        this.normalizeSamples(set);
        this.initComponents();
        this.iscompiling = false;
        this.iscompiled = true;
    }

    private void normalizeSamples(ExampleSet set) {
        int d;
        boolean normlocal = this.getParameterAsBoolean("local_normalization");
        float max = 1.0f;
        float min = 0.0f;
        if (!normlocal) {
            max = this.maxima[0];
            min = this.minima[0];
            for (d = 0; d < this.number_atts; ++d) {
                max = Math.max(max, this.maxima[d]);
                min = Math.min(min, this.minima[d]);
            }
        }
        for (d = 0; d < this.number_atts; ++d) {
            Attribute a = set.getAttribute(d);
            if (normlocal) {
                max = this.maxima[d];
                min = this.minima[d];
            }
            for (int sample = 0; sample < this.number_of_samples; ++sample) {
                this.samples[d][sample] = (this.samples[d][sample] - min) / (max - min);
            }
        }
    }

    private void initClassNames() {
        Attribute att = null;
        if (this.source.getExampleSet().getPredictedLabel() != null) {
            att = this.source.getExampleSet().getPredictedLabel();
        }
        if (this.source.getExampleSet().getLabel() != null) {
            att = this.source.getExampleSet().getLabel();
        }
        if (att == null) {
            return;
        }
        this.classes = new String[att.getNumberOfValues()];
        Collection col = att.getValues();
        Iterator iter = col.iterator();
        int index = 0;
        while (iter.hasNext()) {
            this.classes[index] = (String)iter.next();
            ++index;
        }
    }

    public void parentIsCompiled() {
        ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).setValues(this.getColorAttributes());
    }

    public void refreshParameter() {
        ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).setValues(this.getColorAttributes());
    }

    public String[] getColorAttributes() {
        if (this.source == null) {
            return new String[]{"<None>"};
        }
        if (!this.source.isCompiled()) {
            return new String[]{"<None>"};
        }
        ExampleSet set = this.source.getExampleSet();
        if (set == null) {
            return new String[]{"<None>"};
        }
        int count = 1;
        count += set.getNumberOfAttributes();
        if (set.getLabel() != null) {
            ++count;
        }
        if (set.getPredictedLabel() != null) {
            ++count;
        }
        String[] categories = new String[count];
        categories[0] = "<None>";
        for (int i = 1; i <= set.getNumberOfAttributes(); ++i) {
            categories[i] = set.getAttribute(i - 1).getName();
        }
        int index = set.getNumberOfAttributes() + 1;
        if (set.getLabel() != null) {
            categories[index] = set.getLabel().getName();
            ++index;
        }
        if (set.getPredictedLabel() != null) {
            categories[index] = set.getPredictedLabel().getName();
            ++index;
        }
        return categories;
    }
}

