/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot;

import edu.udo.cs.jvito.JViTo;
import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.jvito.parameter.ParameterTypeColor;
import edu.udo.cs.jvito.plot.CircularArcCoordinatesPanel;
import edu.udo.cs.jvito.plot.MovingListener;
import edu.udo.cs.jvito.plot.SimplePlot;
import edu.udo.cs.jvito.plot.ZoomingListener;
import edu.udo.cs.jvito.util.Resources;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CircularArcCoordinates
extends SimplePlot
implements ItemListener {
    private JPanel mainpane;
    private JPanel settings;
    private String[] attr_names = new String[0];
    private int number_atts = 0;
    private int number_of_samples = 0;
    private float[][] samples;
    private float[] minima;
    private float[] maxima;
    private float[] labelvalues;
    private String[] classes;
    private String labelname;
    private int c_attr = 0;
    private JComboBox c_cbox;
    private JList attlist;

    public JPanel getPlotPanel() {
        if (!this.isCompiled()) {
            return null;
        }
        return this.mainpane;
    }

    private void initComponents() {
        this.initDisplay();
        this.mainpane = new JPanel();
        this.mainpane.setLayout(new BorderLayout(5, 5));
        this.settings = new JPanel();
        this.settings.setLayout(new BorderLayout(5, 5));
        this.mainpane.add((Component)this.settings, "East");
        JPanel settings2 = new JPanel();
        settings2.setLayout(new GridLayout(2, 1, 5, 5));
        this.settings.add((Component)settings2, "Center");
        settings2.add(this.plotpanel.getColorPanel());
        if (this.getParameterAsBoolean("label_axis")) {
            int s = this.attr_names.length;
            if (this.source.getExampleSet().getLabel() != null) {
                ++s;
            }
            String[] atts = new String[s];
            for (int i = 0; i < this.attr_names.length; ++i) {
                atts[i] = new String(Integer.toString(i + 1) + " " + this.attr_names[i]);
            }
            if (this.source.getExampleSet().getLabel() != null) {
                atts[s - 1] = new String("label: " + this.source.getExampleSet().getLabel().getName());
            }
            this.attlist = new JList<String>(atts);
            JScrollPane attscpane = new JScrollPane(this.attlist);
            settings2.add(attscpane);
        }
        String c = this.getParameterAsString("color_attribute");
        this.c_cbox = new JComboBox<String>(this.attr_names);
        if (!c.equals("")) {
            this.c_cbox.setSelectedItem(c);
            this.c_attr = this.c_cbox.getSelectedIndex();
        } else {
            this.c_cbox.setSelectedIndex(this.c_attr);
        }
        this.c_cbox.addItemListener(this);
        JLabel c_axis = new JLabel(Resources.getString("COLOR_ATTRIBUTE"));
        JPanel combos = new JPanel();
        combos.setLayout(new GridLayout(1, 2, 5, 5));
        if (this.getParameterAsBoolean("color_mode")) {
            combos.add(c_axis);
            combos.add(this.c_cbox);
        }
        this.settings.add((Component)combos, "North");
        this.mainpane.add((Component)this.plotpanel, "Center");
    }

    private void initDisplay() {
        this.plotpanel = new CircularArcCoordinatesPanel(this.samples, this.labelname, this.labelvalues, this.getParameterAsBoolean("label_axis"));
        this.plotpanel.setTitle(this.getParameterAsString("title"));
        this.plotpanel.setDrawTitle(this.getParameterAsBoolean("show title"));
        this.plotpanel.setForegroundColor(this.getParameterAsColor("foreground"));
        this.plotpanel.setBackgroundColor(this.getParameterAsColor("background"));
        this.plotpanel.setStartColor(this.getParameterAsColor("start_color"));
        this.plotpanel.setEndColor(this.getParameterAsColor("end_color"));
        MovingListener movinglistener = new MovingListener(this.plotpanel);
        ZoomingListener zoominlistener = new ZoomingListener(this.plotpanel);
        this.plotpanel.addMouseListener(movinglistener);
        this.plotpanel.addMouseMotionListener(movinglistener);
        this.plotpanel.addMouseListener(zoominlistener);
        this.plotpanel.addMouseMotionListener(zoominlistener);
        if (this.getParameterAsBoolean("color by label")) {
            this.plotpanel.colorByAttribute(this.source.getExampleSet().getLabel(), this.labelvalues);
            this.plotpanel.initColorTable();
        }
        if (this.getParameterAsBoolean("color by attribute")) {
            this.plotpanel.colorByAttribute(this.source.getExampleSet().getAttribute(this.c_attr), this.samples[this.c_attr]);
            this.plotpanel.initColorTable();
        }
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeBoolean("local_normalization", "The data have to be local normalized, otherwidse gloabl normalizeed.", false);
        types.add(type);
        type = new ParameterTypeBoolean("label_axis", "Label the axis.", true);
        types.add(type);
        type = new ParameterTypeBoolean("color_mode", "The points are colored.", false);
        types.add(type);
        type = new ParameterTypeBoolean("color by label", "Color the points with the label.", false);
        types.add(type);
        type = new ParameterTypeBoolean("color by attribute", "Color the points with the 'color_attribute'.", false);
        types.add(type);
        type = new ParameterTypeString("color_attribute", "This attribute is the color-dimension.", "");
        types.add(type);
        type = new ParameterTypeColor("start_color", "If 'color by label' and not in rgb-mode, then this is the start color.", Color.BLUE);
        types.add(type);
        type = new ParameterTypeColor("end_color", "If 'color by label' and not in rgb-mode, then this is the end color.", Color.RED);
        types.add(type);
        return types;
    }

    public void compile() throws CompilerException {
        int d;
        if (this.getParameterAsBoolean("color_mode")) {
            if (this.getParameterAsBoolean("color by label") && this.getParameterAsBoolean("color by attribute")) {
                this.setParameter("color by attribute", (Object)"false");
            }
            if (this.getParameterAsBoolean("color by attribute") && this.getParameterAsBoolean("color by label")) {
                this.setParameter("color by label", (Object)"false");
            }
        } else {
            if (this.getParameterAsBoolean("color by label")) {
                this.setParameter("color by label", (Object)"false");
            }
            if (this.getParameterAsBoolean("color by attribute")) {
                this.setParameter("color by attribute", (Object)"false");
            }
        }
        if (!this.source.isCompiled()) {
            return;
        }
        this.iscompiling = true;
        ExampleSet set = this.source.getExampleSet();
        if (this.getParameterAsBoolean("color by label") && set.getLabel() == null) {
            this.setParameter("color by label", (Object)"false");
        }
        this.number_of_samples = set.getSize();
        this.number_atts = set.getNumberOfAttributes();
        this.attr_names = new String[this.number_atts];
        String cname = this.getParameterAsString("color_attribute");
        for (int att = 0; att < this.number_atts; ++att) {
            this.attr_names[att] = set.getAttribute(att).getName();
            if (!this.attr_names[att].equals(cname)) continue;
            this.c_attr = att;
        }
        if (this.getParameterAsBoolean("color by label")) {
            this.labelname = set.getLabel().getName();
            this.initClassNames();
        }
        this.samples = new float[this.number_atts][this.number_of_samples];
        this.labelvalues = new float[this.number_of_samples];
        ExampleReader reader = set.getExampleReader();
        for (int sample = 0; sample < this.number_of_samples; ++sample) {
            Example example = reader.next();
            for (d = 0; d < this.number_atts; ++d) {
                this.samples[d][sample] = (float)example.getValue(d);
            }
            if (!this.getParameterAsBoolean("color by label")) continue;
            this.labelvalues[sample] = (float)example.getLabel();
        }
        this.minima = new float[this.number_atts];
        this.maxima = new float[this.number_atts];
        for (d = 0; d < this.number_atts; ++d) {
            Attribute a = set.getAttribute(d);
            if (a.isNominal()) {
                this.minima[d] = 0.0f;
                this.maxima[d] = a.getNumberOfValues() - 1;
            }
            if (!a.isNumerical()) continue;
            this.minima[d] = (float)a.getMinimum();
            this.maxima[d] = (float)a.getMaximum();
        }
        this.normalizeSamples(set);
        this.initComponents();
        this.iscompiling = false;
        this.iscompiled = true;
    }

    private void normalizeSamples(ExampleSet set) {
        int d;
        boolean normlocal = this.getParameterAsBoolean("local_normalization");
        float max = 1.0f;
        float min = 0.0f;
        if (!normlocal) {
            max = this.maxima[0];
            min = this.minima[0];
            for (d = 0; d < this.number_atts; ++d) {
                max = Math.max(max, this.maxima[d]);
                min = Math.min(min, this.minima[d]);
            }
        }
        for (d = 0; d < this.number_atts; ++d) {
            Attribute a = set.getAttribute(d);
            if (normlocal) {
                max = this.maxima[d];
                min = this.minima[d];
            }
            for (int sample = 0; sample < this.number_of_samples; ++sample) {
                this.samples[d][sample] = (this.samples[d][sample] - min) / (max - min);
            }
        }
    }

    private void initClassNames() {
        this.classes = new String[this.source.getExampleSet().getLabel().getNumberOfValues()];
        Collection col = this.source.getExampleSet().getLabel().getValues();
        Iterator iter = col.iterator();
        int index = 0;
        while (iter.hasNext()) {
            this.classes[index] = (String)iter.next();
            ++index;
        }
    }

    public void itemStateChanged(ItemEvent event) {
        this.c_attr = this.c_cbox.getSelectedIndex();
        if (this.getParameterAsBoolean("color by attribute")) {
            this.setParameter("color_attribute", (Object)this.attr_names[this.c_attr]);
        }
        JViTo.getApplication().inspector.repaint();
    }
}

