/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.parameter;

import edu.udo.cs.jvito.JViTo;
import edu.udo.cs.jvito.parameter.JViToParameters;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class ParameterObject {
    protected JViToParameters parameters;
    private String[] keys;
    private String description = new String("");

    public ParameterObject() {
        this.initParameters();
    }

    public void initParameters() {
        List list = this.getParameterTypes();
        this.parameters = new JViToParameters(list);
        this.keys = new String[list.size()];
        int index = 0;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            this.keys[index] = new String(((ParameterType)iter.next()).getKey());
            ++index;
        }
    }

    public JViToParameters getParameters() {
        return this.parameters;
    }

    public Object getParameter(String key) {
        return this.parameters.getParameter(key);
    }

    public Object getParameter(int index) {
        if (index >= this.countParameterTypes()) {
            return null;
        }
        return this.getParameter(this.keys[index]);
    }

    public boolean isParameterSet(String key) {
        return this.getParameter(key) != null;
    }

    public String getParameterAsString(String key) {
        return (String)this.getParameter(key);
    }

    public int getParameterAsInt(String key) {
        return (Integer)this.getParameter(key);
    }

    public double getParameterAsDouble(String key) {
        return (Double)this.getParameter(key);
    }

    public boolean getParameterAsBoolean(String key) {
        return (Boolean)this.getParameter(key);
    }

    public List getParameterList(String key) {
        return (List)this.getParameter(key);
    }

    public File getParameterAsFile(String key) {
        String fileName = this.getParameterAsString(key);
        return new File(fileName);
    }

    public Color getParameterAsColor(String key) {
        return (Color)this.getParameter(key);
    }

    public void setParameter(String key, Object object) {
        this.parameters.setParameter(key, object);
        JViTo.getApplication().setDirty();
    }

    public void setParameter(int index, Object object) {
        if (index >= this.countParameterTypes()) {
            return;
        }
        this.setParameter(this.keys[index], object);
        JViTo.getApplication().setDirty();
    }

    public List getParameterTypes() {
        return new ArrayList();
    }

    public int countParameterTypes() {
        return this.parameters.getKeys().size();
    }

    public ParameterType getParameterType(int index) {
        if (index >= this.countParameterTypes()) {
            return null;
        }
        return this.parameters.getParameterType(this.keys[index]);
    }

    public ParameterType getParameterType(String key) {
        return this.parameters.getParameterType(key);
    }

    public String getKey(int index) {
        return this.keys[index];
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        JViTo.getApplication().setDirty();
    }
}

