/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.JViTo;
import edu.udo.cs.jvito.OperatorsReader;
import edu.udo.cs.jvito.Project;
import edu.udo.cs.jvito.data.Source;
import edu.udo.cs.jvito.gui.DescriptionPanel;
import edu.udo.cs.jvito.gui.ExecutableMenuItem;
import edu.udo.cs.jvito.gui.Inspector;
import edu.udo.cs.jvito.gui.JViToMenu;
import edu.udo.cs.jvito.gui.NavigatorEditor;
import edu.udo.cs.jvito.gui.NavigatorRenderer;
import edu.udo.cs.jvito.gui.PlotTreeNode;
import edu.udo.cs.jvito.gui.ProjectTreeNode;
import edu.udo.cs.jvito.gui.SourceTreeNode;
import edu.udo.cs.jvito.parameter.ParameterObject;
import edu.udo.cs.jvito.plot.Plot;
import edu.udo.cs.jvito.util.Resources;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class Navigator
extends JTree
implements TreeSelectionListener,
MouseListener {
    private DefaultTreeModel treemodel;
    private ProjectTreeNode root;
    private Vector treenode_names;
    private Inspector inspector;
    private DescriptionPanel desc_panel;
    private boolean listeningToChanges = false;
    private JMenuItem compileselected;
    private JMenuItem compileall;
    private JMenuItem compilechilds;
    private JMenuItem compileparents;
    private JMenuItem showdata;
    private JMenuItem showplot;
    private JMenuItem saveplot;
    private JMenuItem show_coloring;
    private JMenuItem show_viscomp;

    public Navigator(ProjectTreeNode node) {
        this.treemodel = new DefaultTreeModel(node);
        this.setModel(this.treemodel);
        this.root = node;
        this.setEditable(true);
        this.treenode_names = new Vector();
        this.createTreeNodeNamesForChilds(this.root.getProject());
        this.setCellRenderer(new NavigatorRenderer(this));
        this.setCellEditor(new NavigatorEditor(this));
        this.setShowsRootHandles(true);
        this.addTreeSelectionListener(this);
        this.refresh();
        this.listeningToChanges = true;
        this.addMouseListener(this);
    }

    private void createTreeNodeNamesForChilds(Object obj) {
        if (obj instanceof Project) {
            Project pro = (Project)obj;
            if (!this.isValidTreeNodeName(pro.getName())) {
                pro.setName(this.getValidTreeNodeName(pro.getName()));
            }
            this.treenode_names.add(new TreeNodeName(pro.getName()));
            for (int i = 0; i < pro.getSourceCount(); ++i) {
                this.createTreeNodeNamesForChilds(pro.getSource(i));
            }
        } else if (obj instanceof Source) {
            int i;
            Source source = (Source)obj;
            if (!this.isValidTreeNodeName(source.getName())) {
                source.setName(this.getValidTreeNodeName(source.getName()));
            }
            this.treenode_names.add(new TreeNodeName(source.getName()));
            for (i = 0; i < source.getSourceCount(); ++i) {
                this.createTreeNodeNamesForChilds(source.getSource(i));
            }
            for (i = 0; i < source.getPlotCount(); ++i) {
                this.createTreeNodeNamesForChilds(source.getPlot(i));
            }
        } else if (obj instanceof Plot) {
            Plot plot = (Plot)obj;
            if (!this.isValidTreeNodeName(plot.getName())) {
                plot.setName(this.getValidTreeNodeName(plot.getName()));
            }
            this.treenode_names.add(new TreeNodeName(plot.getName()));
        }
    }

    public void setInspector(Inspector insp) {
        this.inspector = insp;
    }

    public void setDescriptionPanel(DescriptionPanel desc_panel) {
        this.desc_panel = desc_panel;
    }

    public void addSource(Source source) {
        SourceTreeNode node = new SourceTreeNode(source);
        if (this.isProjectNodeSelected()) {
            this.treemodel.insertNodeInto(node, this.root, this.root.getChildCount());
            ((Project)this.root.getUserObject()).addSource(source);
            source.setSource(null);
            this.refresh();
        }
        if (this.isSourceNodeSelected()) {
            SourceTreeNode selected = (SourceTreeNode)this.getSelectedTreeNode();
            Source sourc = selected.getSource();
            this.treemodel.insertNodeInto(node, selected, selected.getChildCount());
            sourc.addSource(source);
            source.setSource(sourc);
            this.refresh();
        }
        if (this.isSelectionEmpty()) {
            this.treemodel.insertNodeInto(node, this.root, this.root.getChildCount());
            ((Project)this.root.getUserObject()).addSource(source);
            source.setSource(null);
            this.refresh();
        }
        JViTo.getApplication().setDirty();
    }

    public void addSource(DefaultMutableTreeNode parent, Source source, int index) {
        SourceTreeNode node = new SourceTreeNode(source);
        if (parent instanceof ProjectTreeNode) {
            this.treemodel.insertNodeInto(node, this.root, index);
            ((Project)this.root.getUserObject()).addSource(source, index);
            source.setSource(null);
            this.refresh();
        }
        if (parent instanceof SourceTreeNode) {
            SourceTreeNode selected = (SourceTreeNode)parent;
            Source sourc = selected.getSource();
            this.treemodel.insertNodeInto(node, selected, index);
            sourc.addSource(source, index);
            source.setSource(sourc);
            this.refresh();
        }
        JViTo.getApplication().setDirty();
    }

    public boolean removeSource() {
        if (this.isSourceNodeSelected()) {
            SourceTreeNode node = (SourceTreeNode)this.getSelectedTreeNode();
            if (node.getParent() instanceof ProjectTreeNode) {
                ((ProjectTreeNode)node.getParent()).getProject().removeSource(node.getSource());
            }
            if (node.getParent() instanceof SourceTreeNode) {
                ((SourceTreeNode)node.getParent()).getSource().removeSource(node.getSource());
            }
            this.treemodel.removeNodeFromParent(node);
            this.refresh();
            JViTo.getApplication().setDirty();
            return true;
        }
        return false;
    }

    public boolean addPlot(Plot plot) {
        if (this.isSourceNodeSelected()) {
            SourceTreeNode node = (SourceTreeNode)this.getSelectedTreeNode();
            Source sourc = node.getSource();
            PlotTreeNode child = new PlotTreeNode(plot);
            this.treemodel.insertNodeInto(child, node, node.getChildCount());
            sourc.addPlot(plot);
            this.refresh();
            JViTo.getApplication().setDirty();
            return true;
        }
        return false;
    }

    public boolean addPlot(DefaultMutableTreeNode parent, Plot plot, int index) {
        if (parent instanceof SourceTreeNode) {
            SourceTreeNode node = (SourceTreeNode)parent;
            Source sourc = node.getSource();
            PlotTreeNode child = new PlotTreeNode(plot);
            this.treemodel.insertNodeInto(child, node, index);
            sourc.addPlot(plot, index);
            this.refresh();
            JViTo.getApplication().setDirty();
            return true;
        }
        return false;
    }

    public boolean removePlot() {
        if (this.isPlotNodeSelected()) {
            PlotTreeNode node = (PlotTreeNode)this.getSelectedTreeNode();
            ((SourceTreeNode)node.getParent()).getSource().removePlot(node.getPlot());
            this.treemodel.removeNodeFromParent(node);
            this.refresh();
            JViTo.getApplication().setDirty();
            return true;
        }
        return false;
    }

    public MutableTreeNode getSelectedTreeNode() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return this.root;
        }
        return (MutableTreeNode)path.getLastPathComponent();
    }

    public boolean isProjectNodeSelected() {
        if (this.isSelectionEmpty()) {
            return false;
        }
        return this.getSelectedTreeNode() instanceof ProjectTreeNode;
    }

    public boolean isSourceNodeSelected() {
        if (this.isSelectionEmpty()) {
            return false;
        }
        return this.getSelectedTreeNode() instanceof SourceTreeNode;
    }

    public boolean isPlotNodeSelected() {
        if (this.isSelectionEmpty()) {
            return false;
        }
        return this.getSelectedTreeNode() instanceof PlotTreeNode;
    }

    public void refresh() {
        this.revalidate();
        this.repaint();
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    public String getValidTreeNodeName(String name) {
        TreeNodeName nodename = null;
        boolean found = false;
        for (int i = 0; i < this.treenode_names.size(); ++i) {
            nodename = (TreeNodeName)this.treenode_names.get(i);
            if (!nodename.equals(name)) continue;
            found = true;
            break;
        }
        if (found) {
            nodename.increaseCounter();
            return nodename.getName();
        }
        nodename = new TreeNodeName(name);
        this.treenode_names.add(nodename);
        return nodename.getName();
    }

    public boolean isValidTreeNodeName(String name) {
        TreeNodeName nodename = null;
        boolean found = false;
        for (int i = 0; i < this.treenode_names.size(); ++i) {
            nodename = (TreeNodeName)this.treenode_names.get(i);
            if (!nodename.equals(name)) continue;
            found = true;
            break;
        }
        return !found;
    }

    public void valueChanged(TreeSelectionEvent event) {
        PlotTreeNode n;
        MutableTreeNode node = this.getSelectedTreeNode();
        ParameterObject object = null;
        if (node instanceof ProjectTreeNode) {
            ProjectTreeNode n2 = (ProjectTreeNode)node;
            if (n2.getUserObject() instanceof ParameterObject) {
                object = (ParameterObject)n2.getUserObject();
            }
        } else if (node instanceof SourceTreeNode) {
            SourceTreeNode n3 = (SourceTreeNode)node;
            if (n3.getUserObject() instanceof ParameterObject) {
                object = (ParameterObject)n3.getUserObject();
            }
        } else if (node instanceof PlotTreeNode && (n = (PlotTreeNode)node).getUserObject() instanceof ParameterObject) {
            object = (ParameterObject)n.getUserObject();
        }
        if (object != null) {
            if (object instanceof Source) {
                ((Source)object).refreshParameter();
            }
            if (object instanceof Plot) {
                ((Plot)object).refreshParameter();
            }
            this.inspector.setParameterObject(object);
            this.desc_panel.setParameterObject(object);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.setSelectionPath(this.getClosestPathForLocation(e.getX(), e.getY()));
        if (e.getModifiers() == 4) {
            this.createPopupMenu().show(this, e.getX(), e.getY());
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public JPopupMenu createPopupMenu() {
        Plot plot;
        Source source;
        JPopupMenu popmenu = new JPopupMenu();
        JMenu operatorsmenu = new JMenu(Resources.getString("OPERATORS"));
        JViToMenu.createOperatorsMenu(operatorsmenu, OperatorsReader.getGroups());
        popmenu.add(operatorsmenu);
        MutableTreeNode node = this.getSelectedTreeNode();
        if (this.isSourceNodeSelected() && (source = ((SourceTreeNode)node).getSource()).isCompiled()) {
            popmenu.addSeparator();
            this.showdata = new ExecutableMenuItem(popmenu, "MENU_PROJECT_SHOW_DATA"){

                public void execute() {
                    JViTo.getApplication().promptShowData();
                }
            };
            this.show_coloring = new ExecutableMenuItem(popmenu, "MENU_PROJECT_SHOW_EXAMPLECOLORING"){

                public void execute() {
                    JViTo.getApplication().promptShowExampleColoring();
                }
            };
            this.show_viscomp = new ExecutableMenuItem(popmenu, "MENU_PROJECT_SHOW_VISCOMP"){

                public void execute() {
                    JViTo.getApplication().promptShowVisualizationComponent();
                }
            };
        }
        if (this.isPlotNodeSelected() && (plot = ((PlotTreeNode)node).getPlot()).isCompiled()) {
            popmenu.addSeparator();
            this.showplot = new ExecutableMenuItem(popmenu, "MENU_PROJECT_SHOW_PLOT"){

                public void execute() {
                    JViTo.getApplication().promptShowPlot();
                }
            };
            this.saveplot = new ExecutableMenuItem(popmenu, "MENU_PROJECT_SAVE_PLOT"){

                public void execute() {
                    JViTo.getApplication().promptSavePlot();
                }
            };
        }
        popmenu.addSeparator();
        this.compileselected = new ExecutableMenuItem(popmenu, "MENU_PROJECT_COMPILESELECTED"){

            public void execute() {
                JViTo.getApplication().promptCompile(0);
            }
        };
        this.compileall = new ExecutableMenuItem(popmenu, "MENU_PROJECT_COMPILEALL"){

            public void execute() {
                JViTo.getApplication().promptCompile(1);
            }
        };
        this.compilechilds = new ExecutableMenuItem(popmenu, "MENU_PROJECT_COMPILECHILDS"){

            public void execute() {
                JViTo.getApplication().promptCompile(2);
            }
        };
        this.compileparents = new ExecutableMenuItem(popmenu, "MENU_PROJECT_COMPILEPARENTS"){

            public void execute() {
                JViTo.getApplication().promptCompile(3);
            }
        };
        return popmenu;
    }

    public boolean stopEditing() {
        JViTo.getApplication().setDirty();
        return super.stopEditing();
    }

    public void moveUp() {
        DefaultMutableTreeNode selectednode = (DefaultMutableTreeNode)this.getSelectedTreeNode();
        if (selectednode == null) {
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selectednode.getParent();
        if (parent == null) {
            return;
        }
        int oldPos = parent.getIndex(selectednode);
        if (oldPos > 0) {
            TreePath path = this.getSelectionPath().getParentPath();
            if (selectednode instanceof SourceTreeNode) {
                this.removeSource();
                this.addSource(parent, ((SourceTreeNode)selectednode).getSource(), oldPos - 1);
            }
            if (selectednode instanceof PlotTreeNode) {
                int index = parent.getIndex(selectednode);
                DefaultMutableTreeNode nextnode = (DefaultMutableTreeNode)parent.getChildAt(index - 1);
                if (nextnode instanceof SourceTreeNode) {
                    return;
                }
                this.removePlot();
                this.addPlot(parent, ((PlotTreeNode)selectednode).getPlot(), oldPos - 1);
            }
        }
    }

    public void moveDown() {
        DefaultMutableTreeNode selectednode = (DefaultMutableTreeNode)this.getSelectedTreeNode();
        if (selectednode == null) {
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selectednode.getParent();
        if (parent == null) {
            return;
        }
        int oldPos = parent.getIndex(selectednode);
        if (oldPos < parent.getChildCount() - 1) {
            TreePath path = this.getSelectionPath().getParentPath();
            if (selectednode instanceof SourceTreeNode) {
                int index = parent.getIndex(selectednode);
                DefaultMutableTreeNode nextnode = (DefaultMutableTreeNode)parent.getChildAt(index + 1);
                if (nextnode instanceof PlotTreeNode) {
                    return;
                }
                this.removeSource();
                this.addSource(parent, ((SourceTreeNode)selectednode).getSource(), oldPos + 1);
            }
            if (selectednode instanceof PlotTreeNode) {
                this.removePlot();
                this.addPlot(parent, ((PlotTreeNode)selectednode).getPlot(), oldPos + 1);
            }
        }
    }

    private class TreeNodeName {
        private String name;
        private int counter;

        public TreeNodeName(String name) {
            this.name = name;
            this.counter = 1;
        }

        public String getName() {
            if (this.counter == 1) {
                return this.name;
            }
            return this.name + "(" + this.counter + ")";
        }

        public void increaseCounter() {
            ++this.counter;
        }

        public boolean equals(String name) {
            return this.name.equals(name);
        }
    }
}

