/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.gui.Application;
import edu.udo.cs.jvito.gui.ColorEditor;
import edu.udo.cs.jvito.gui.ColorRenderer;
import edu.udo.cs.jvito.gui.InspectorModel;
import edu.udo.cs.jvito.gui.InspectorParameterRenderer;
import edu.udo.cs.jvito.gui.InspectorValueEditor;
import edu.udo.cs.jvito.parameter.ParameterObject;
import edu.udo.cs.jvito.parameter.ParameterTypeColor;
import edu.udo.cs.jvito.parameter.ParameterTypeDynamicCategory;
import edu.udo.cs.jvito.util.Resources;
import edu.udo.cs.yale.gui.SimpleFileCellEditor;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeAttributeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypePassword;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class Inspector
extends JTable {
    private Application app;
    private ParameterObject paramobject;
    private InspectorModel tablemodel;
    private InspectorParameterRenderer tablerenderer;
    private InspectorValueEditor valueeditor;
    private Vector editoren;
    private Vector renderer;
    private boolean listeningToChanges = false;

    public Inspector(Application app, ParameterObject paramobject) {
        this.app = app;
        this.paramobject = paramobject;
        this.setSelectionMode(0);
        this.setRowHeight(this.getRowHeight() + Resources.getInt("INSPECTOR_ROW_EXTRA_HEIGHT"));
        this.getTableHeader().setReorderingAllowed(false);
        this.tablemodel = new InspectorModel(paramobject);
        this.tablerenderer = new InspectorParameterRenderer(paramobject);
        this.setModel(this.tablemodel);
        this.createEditorAndRenderer();
        this.listeningToChanges = true;
    }

    public InspectorModel getInspectorModel() {
        return this.tablemodel;
    }

    private void createEditorAndRenderer() {
        this.editoren = new Vector();
        this.renderer = new Vector();
        for (int index = 0; index < this.paramobject.countParameterTypes(); ++index) {
            SimpleFileCellEditor editor;
            InspectorValueEditor valueeditor;
            ParameterTypeSingle param;
            ParameterType mytype = this.paramobject.getParameterType(index);
            if (mytype instanceof ParameterTypePassword) {
                param = (ParameterTypePassword)mytype;
                valueeditor = new InspectorValueEditor((ParameterTypePassword)param);
                this.editoren.add(valueeditor);
                this.renderer.add(valueeditor);
                continue;
            }
            if (mytype instanceof ParameterTypeBoolean) {
                param = (ParameterTypeBoolean)mytype;
                valueeditor = new InspectorValueEditor((ParameterTypeBoolean)param);
                this.editoren.add(valueeditor);
                this.renderer.add(valueeditor);
                continue;
            }
            if (mytype instanceof ParameterTypeInt) {
                param = (ParameterTypeInt)mytype;
                valueeditor = new InspectorValueEditor((ParameterTypeInt)param);
                this.editoren.add(valueeditor);
                this.renderer.add(valueeditor);
                continue;
            }
            if (mytype instanceof ParameterTypeDouble) {
                param = (ParameterTypeDouble)mytype;
                valueeditor = new InspectorValueEditor((ParameterTypeDouble)param);
                this.editoren.add(valueeditor);
                this.renderer.add(valueeditor);
                continue;
            }
            if (mytype instanceof ParameterTypeCategory) {
                param = (ParameterTypeCategory)mytype;
                valueeditor = new InspectorValueEditor((ParameterTypeCategory)param);
                this.editoren.add(valueeditor);
                this.renderer.add(valueeditor);
                continue;
            }
            if (mytype instanceof ParameterTypeDynamicCategory) {
                param = (ParameterTypeDynamicCategory)mytype;
                valueeditor = new InspectorValueEditor((ParameterTypeDynamicCategory)param);
                this.editoren.add(valueeditor);
                this.renderer.add(valueeditor);
                continue;
            }
            if (mytype instanceof ParameterTypeStringCategory) {
                param = (ParameterTypeStringCategory)mytype;
                valueeditor = new InspectorValueEditor((ParameterTypeStringCategory)param);
                this.editoren.add(valueeditor);
                this.renderer.add(valueeditor);
                continue;
            }
            if (mytype instanceof ParameterTypeAttributeFile) {
                param = (ParameterTypeAttributeFile)mytype;
                editor = new SimpleFileCellEditor((ParameterTypeFile)param);
                this.editoren.add(editor);
                this.renderer.add(editor);
                continue;
            }
            if (mytype instanceof ParameterTypeFile) {
                param = (ParameterTypeFile)mytype;
                editor = new SimpleFileCellEditor((ParameterTypeFile)param);
                this.editoren.add(editor);
                this.renderer.add(editor);
                continue;
            }
            if (mytype instanceof ParameterTypeString) {
                param = (ParameterTypeString)mytype;
                valueeditor = new InspectorValueEditor((ParameterTypeString)param);
                this.editoren.add(valueeditor);
                this.renderer.add(valueeditor);
                continue;
            }
            if (!(mytype instanceof ParameterTypeColor)) continue;
            param = (ParameterTypeColor)mytype;
            this.editoren.add(new ColorEditor(this.paramobject.getParameterAsColor(param.getKey())));
            this.renderer.add(new ColorRenderer(true));
        }
    }

    public void setParameterObject(ParameterObject paramobject) {
        this.paramobject = paramobject;
        this.tablemodel.setParameterObject(paramobject);
        this.tablerenderer.setParameterObject(paramobject);
        this.createEditorAndRenderer();
        this.revalidate();
        this.repaint();
    }

    public TableCellRenderer getCellRenderer(int rowIndex, int colIndex) {
        ParameterType type = this.paramobject.getParameterType(rowIndex);
        if (rowIndex < this.editoren.size()) {
            if (colIndex == 0) {
                return this.tablerenderer;
            }
            if (colIndex == 1) {
                return (TableCellRenderer)this.renderer.get(rowIndex);
            }
            return super.getCellRenderer(rowIndex, colIndex);
        }
        return this.tablerenderer;
    }

    public TableCellEditor getCellEditor(int rowIndex, int colIndex) {
        if (colIndex == 1) {
            return (TableCellEditor)this.editoren.get(rowIndex);
        }
        return super.getCellEditor(rowIndex, colIndex);
    }

    public String toString() {
        return Resources.getString("INSPECTOR_PARAMETERS");
    }

    public ImageIcon getImageIcon() {
        return Resources.getImageIcon("INSPECTOR_PARAMETERS");
    }
}

