/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.gui.Executable;
import edu.udo.cs.jvito.util.Resources;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ExecutableMenuItem
extends JMenuItem
implements ActionListener,
Executable {
    private boolean minimize;
    private String name;
    private String minname;

    public ExecutableMenuItem(String name) {
        super(name);
        this.name = name;
        this.minname = name;
        this.setName(name);
        this.minimize = false;
        this.addActionListener(this);
    }

    public ExecutableMenuItem(String name, boolean minimize) {
        super(name);
        this.minimize = minimize;
        if (minimize) {
            this.name = name;
            this.minname = this.calculateMinName(name);
            this.setName(this.minname);
            this.setText(this.minname);
        } else {
            this.setName(name);
            this.setText(name);
            this.name = name;
            this.minname = name;
        }
        this.addActionListener(this);
    }

    public String getRealName() {
        return this.name;
    }

    public String getName() {
        return this.getMinName();
    }

    public ExecutableMenuItem(JMenu parent, String key) {
        super(Resources.getString(key));
        this.setName(Resources.getString(key));
        this.name = Resources.getString(key);
        this.addActionListener(this);
        this.setMnemonic(Resources.getChar("MNEMONIC_" + key));
        this.setIcon(Resources.getImageIcon(key));
        parent.add(this);
    }

    public ExecutableMenuItem(JPopupMenu parent, String key) {
        super(Resources.getString(key));
        this.setName(Resources.getString(key));
        this.addActionListener(this);
        this.setMnemonic(Resources.getChar("MNEMONIC_" + key));
        this.setIcon(Resources.getImageIcon(key));
        parent.add(this);
    }

    public void execute() {
    }

    public void actionPerformed(ActionEvent event) {
        this.execute();
    }

    public String getMinName() {
        if (this.minimize) {
            return this.minname;
        }
        return this.name;
    }

    public String calculateMinName(String name) {
        String separator = System.getProperty("file.separator");
        StringTokenizer st = new StringTokenizer(name, separator);
        String[] names = new String[st.countTokens()];
        for (int n = 0; n < names.length; ++n) {
            names[n] = st.nextToken();
        }
        String back = new String("");
        if (names.length <= 3) {
            return name;
        }
        return names[0] + separator + names[1] + separator + "..." + separator + names[names.length - 1];
    }
}

