/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import javax.swing.table.AbstractTableModel;

public class DataTableModel
extends AbstractTableModel {
    private ExampleSet exampleset;

    public DataTableModel(ExampleSet exampleset) {
        this.exampleset = exampleset;
    }

    public int getColumnCount() {
        if (this.exampleset == null) {
            return 0;
        }
        int count = this.exampleset.getNumberOfAttributes();
        if (this.exampleset.getLabel() != null) {
            ++count;
        }
        if (this.exampleset.getPredictedLabel() != null) {
            ++count;
        }
        return count;
    }

    public String getColumnName(int index) {
        if (this.exampleset == null) {
            return "";
        }
        if (index < this.exampleset.getNumberOfAttributes()) {
            return this.exampleset.getAttribute(index).getName();
        }
        if (this.exampleset.getLabel() != null && index == this.exampleset.getNumberOfAttributes()) {
            return this.exampleset.getLabel().getName();
        }
        if (this.exampleset.getPredictedLabel() != null) {
            return this.exampleset.getPredictedLabel().getName();
        }
        return "";
    }

    public int getRowCount() {
        if (this.exampleset == null) {
            return 0;
        }
        return this.exampleset.getSize();
    }

    public Object getValueAt(int rowIndex, int colIndex) {
        ExampleReader reader = this.exampleset.getExampleReader();
        int index = 0;
        while (reader.hasNext()) {
            Example example = reader.next();
            if (index == rowIndex) {
                if (colIndex < this.exampleset.getNumberOfAttributes()) {
                    return example.getValueAsString(this.exampleset.getAttribute(colIndex));
                }
                if (this.exampleset.getLabel() != null && colIndex == this.exampleset.getNumberOfAttributes()) {
                    return example.getValueAsString(this.exampleset.getLabel());
                }
                if (this.exampleset.getPredictedLabel() != null) {
                    return example.getValueAsString(this.exampleset.getPredictedLabel());
                }
                return "";
            }
            ++index;
        }
        return new String("");
    }

    public boolean isCellEditable(int arg0, int arg1) {
        return false;
    }

    public void setValueAt(Object arg0, int arg1, int arg2) {
    }
}

