/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.Project;
import edu.udo.cs.jvito.compile.Compileable;
import edu.udo.cs.jvito.compile.JViToCompiler;
import edu.udo.cs.jvito.data.Source;
import edu.udo.cs.jvito.exception.KeyException;
import edu.udo.cs.jvito.gui.Application;
import edu.udo.cs.jvito.plot.Plot;
import edu.udo.cs.jvito.util.Preferences;
import edu.udo.cs.jvito.util.Resources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class CompilingDialog
extends JDialog {
    public static final int ONE_SECOND = 1000;
    public static final int MILLI_SECOND = 100;
    private Application app;
    private JProgressBar progressbar;
    private JLabel label;
    private JViToCompiler compiler;
    private Thread compilerThread;
    private Timer timer;
    private int value = 0;

    public CompilingDialog(Application parent, JViToCompiler compiler, Thread compilerThread) {
        super(parent, Resources.getString("COMPILING_TITLE"), true);
        this.app = parent;
        this.compiler = compiler;
        this.compilerThread = compilerThread;
        this.initComponents();
        this.initStuff();
    }

    private void initComponents() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.getContentPane().setLayout(new BorderLayout());
        JPanel top = new JPanel();
        top.setBorder(BorderFactory.createEmptyBorder(15, 25, 0, 25));
        this.label = new JLabel(Resources.getString("COMPILING"));
        top.add(this.label);
        this.getContentPane().add((Component)top, "North");
        this.progressbar = new JProgressBar(0, 1000);
        this.progressbar.setValue(0);
        this.progressbar.setIndeterminate(true);
        this.progressbar.setStringPainted(false);
        Dimension d = new Dimension(300, 25);
        this.progressbar.setMaximumSize(d);
        this.progressbar.setMinimumSize(d);
        this.progressbar.setPreferredSize(d);
        JPanel center = new JPanel();
        center.setBorder(BorderFactory.createEmptyBorder(25, 25, 25, 25));
        center.add(this.progressbar);
        this.getContentPane().add((Component)center, "Center");
        this.setDefaultCloseOperation(2);
        this.pack();
        Preferences pref = this.app.getPreferences();
        try {
            this.setSize(pref.getInt("compiler_dialog_width"), pref.getInt("compiler_dialog_height"));
        }
        catch (KeyException error) {
            this.setSize(350, 150);
        }
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dim.width - this.getSize().width) / 2, (dim.height - this.getSize().height) / 2);
    }

    private void initStuff() {
        this.value = 0;
        this.timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (CompilingDialog.this.compiler.isCompiling() && CompilingDialog.this.compiler.getException() == null) {
                    String text = new String("");
                    Compileable comp = CompilingDialog.this.compiler.getCurrentCompileableObject();
                    if (comp != null) {
                        if (comp instanceof Project) {
                            Project project = (Project)comp;
                            text = text + project.getName();
                        } else if (comp instanceof Source) {
                            Source source = (Source)comp;
                            text = text + source.getName();
                        } else if (comp instanceof Plot) {
                            Plot plot = (Plot)comp;
                            text = text + plot.getName();
                        }
                    }
                    CompilingDialog.this.setLabelText(text);
                } else {
                    CompilingDialog.this.dispose();
                }
            }
        });
    }

    public void dispose() {
        Preferences pref = this.app.getPreferences();
        pref.setInt("compiler_dialog_width", this.getSize().width);
        pref.setInt("compiler_dialog_height", this.getSize().height);
        super.dispose();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.timer.start();
        }
        super.setVisible(visible);
    }

    public void setLabelText(String text) {
        if (this.label != null) {
            String s = new String(Resources.getString("COMPILING"));
            if (text != null) {
                s = s + " " + text;
            }
            this.label.setText(s);
        }
    }
}

