/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.JViTo;
import edu.udo.cs.jvito.exception.KeyException;
import edu.udo.cs.jvito.util.Logger;
import edu.udo.cs.jvito.util.Preferences;
import edu.udo.cs.jvito.util.Resources;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class Browser
extends JEditorPane
implements HyperlinkListener {
    public Browser() {
        this.setEditable(false);
        this.setMargin(new Insets(5, 5, 5, 5));
        this.addHyperlinkListener(this);
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)this.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
            } else {
                try {
                    this.setPage(e.getURL());
                }
                catch (Exception error) {
                    Logger.logException(error.getMessage(), error);
                }
            }
        }
    }

    private JMenuItem createItem(String name, final URL url) {
        JMenuItem item = new JMenuItem(name);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Browser.this.setPage(url);
                }
                catch (IOException error) {
                    Logger.logException(error.getMessage(), error);
                }
            }
        });
        return item;
    }

    public static void showDialog(URL url) {
        Browser browser = new Browser();
        JDialog dialog = new JDialog(JViTo.getApplication()){

            public void dispose() {
                Preferences pref = JViTo.getApplication().getPreferences();
                pref.setInt("browser_window_x", this.getLocation().x);
                pref.setInt("browser_window_y", this.getLocation().y);
                pref.setInt("browser_window_width", this.getSize().width);
                pref.setInt("browser_window_height", this.getSize().height);
                super.dispose();
            }
        };
        dialog.setTitle(Resources.getString("BROWSER_TITLE"));
        JMenuBar menuBar = new JMenuBar();
        JMenu visitMenu = new JMenu(Resources.getString("BROWSER_MENU"));
        visitMenu.add(browser.createItem(Resources.getString("BROWSER_GUI_MANUAL"), Resources.getURLByClassLoader("BROWSER_MANUAL_URL")));
        visitMenu.add(browser.createItem(Resources.getString("BROWSER_WWW"), Resources.getURL("BROWSER_WWW_URL")));
        visitMenu.add(browser.createItem(Resources.getString("BROWSER_LICENCE"), Resources.getURLByClassLoader("BROWSER_LICENCE_URL")));
        menuBar.add(visitMenu);
        dialog.setJMenuBar(menuBar);
        JScrollPane editorScrollPane = new JScrollPane(browser);
        editorScrollPane.setPreferredSize(new Dimension(600, 500));
        dialog.getContentPane().add(editorScrollPane);
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        try {
            Preferences pref = JViTo.getApplication().getPreferences();
            dialog.setSize(pref.getInt("browser_window_width"), pref.getInt("browser_window_height"));
            dialog.setLocation(pref.getInt("browser_window_x"), pref.getInt("browser_window_y"));
        }
        catch (KeyException error) {
            // empty catch block
        }
        dialog.setVisible(true);
        if (url != null) {
            try {
                browser.setPage(url);
            }
            catch (Exception error) {
                Logger.logException(error.getMessage(), error);
                dialog.dispose();
            }
        }
    }
}

