/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.util.Resources;
import edu.udo.cs.yale.example.Attribute;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AttributeRangeDialog
extends JDialog
implements ActionListener,
ChangeListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private int exitaction = 1;
    private JSlider minslider;
    private JSlider maxslider;
    private JLabel minlabel;
    private JLabel maxlabel;
    private JTextField mintext;
    private JTextField maxtext;
    private JButton ok;
    private JButton cancel;
    private Attribute attribute;
    private double min;
    private double max;

    public AttributeRangeDialog(JDialog parent, Attribute attribute) {
        super(parent, Resources.getString("EXAMPLECOLORING_RANGE_TITLE"), true);
        this.attribute = attribute;
        this.min = attribute.getMinimum();
        this.max = attribute.getMaximum();
        this.initComponents();
        this.pack();
        this.setSize(250, 250);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dim.width - this.getSize().width) / 2, (dim.height - this.getSize().height) / 2);
        this.setVisible(true);
    }

    public AttributeRangeDialog(JDialog parent, Attribute attribute, double min, double max) {
        super(parent, Resources.getString("EXAMPLECOLORING_RANGE_TITLE"), true);
        this.attribute = attribute;
        this.min = min;
        this.max = max;
        this.initComponents();
        this.pack();
        this.setSize(250, 250);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dim.width - this.getSize().width) / 2, (dim.height - this.getSize().height) / 2);
        this.setVisible(true);
    }

    private void initComponents() {
        int mi = (int)((this.min - this.attribute.getMinimum()) / (this.attribute.getMaximum() - this.attribute.getMinimum()) * 10000.0);
        int ma = (int)((this.max - this.attribute.getMinimum()) / (this.attribute.getMaximum() - this.attribute.getMinimum()) * 10000.0);
        this.minslider = new JSlider(0, 0, 10000, mi);
        this.minslider.setMajorTickSpacing(2500);
        this.minslider.setMinorTickSpacing(500);
        this.minslider.setPaintTicks(true);
        this.minslider.setPaintLabels(false);
        this.minslider.addChangeListener(this);
        this.maxslider = new JSlider(0, 0, 10000, ma);
        this.maxslider.setMajorTickSpacing(2500);
        this.maxslider.setMinorTickSpacing(500);
        this.maxslider.setPaintTicks(true);
        this.maxslider.setPaintLabels(false);
        this.maxslider.addChangeListener(this);
        this.minlabel = new JLabel(Resources.getString("MIN_LABEL_TEXT"));
        this.maxlabel = new JLabel(Resources.getString("MAX_LABEL_TEXT"));
        this.mintext = new JTextField("");
        this.maxtext = new JTextField("");
        this.setMinText();
        this.setMaxText();
        JPanel midpanel = new JPanel();
        midpanel.setLayout(new GridLayout(4, 1, 5, 5));
        JPanel row = new JPanel();
        row.setLayout(new GridLayout(1, 2, 5, 5));
        row.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        row.add(this.minlabel);
        row.add(this.mintext);
        midpanel.add(row);
        midpanel.add(this.minslider);
        row = new JPanel();
        row.setLayout(new GridLayout(1, 2, 5, 5));
        row.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        row.add(this.maxlabel);
        row.add(this.maxtext);
        midpanel.add(row);
        midpanel.add(this.maxslider);
        this.ok = new JButton(Resources.getString("OK"));
        this.ok.addActionListener(this);
        this.cancel = new JButton(Resources.getString("CANCEL"));
        this.cancel.addActionListener(this);
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this.ok);
        bottom.add(Box.createRigidArea(new Dimension(10, 0)));
        bottom.add(this.cancel);
        JPanel toppanel = new JPanel();
        toppanel.setLayout(new BorderLayout());
        toppanel.add((Component)midpanel, "Center");
        toppanel.add((Component)bottom, "South");
        toppanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(toppanel);
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals(Resources.getString("OK"))) {
            this.exitaction = 0;
        }
        if (cmd.equals(Resources.getString("CANCEL"))) {
            this.exitaction = 1;
        }
        try {
            this.min = Double.parseDouble(this.mintext.getText());
            this.max = Double.parseDouble(this.maxtext.getText());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.exitaction = 1;
        }
        if (this.min > this.max) {
            this.exitaction = 1;
        }
        if (this.min < this.attribute.getMinimum()) {
            this.exitaction = 1;
        }
        if (this.max > this.attribute.getMaximum()) {
            this.exitaction = 1;
        }
        this.dispose();
    }

    public void setMinText() {
        this.min = this.attribute.getMinimum() + (double)this.minslider.getValue() * (this.attribute.getMaximum() - this.attribute.getMinimum()) / 10000.0;
        this.mintext.setText(Double.toString(this.min));
    }

    public void setMaxText() {
        this.max = this.attribute.getMinimum() + (double)this.maxslider.getValue() * (this.attribute.getMaximum() - this.attribute.getMinimum()) / 10000.0;
        this.maxtext.setText(Double.toString(this.max));
    }

    public int getExitAction() {
        return this.exitaction;
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource().equals(this.minslider)) {
            this.setMinText();
        }
        if (e.getSource().equals(this.maxslider)) {
            this.setMaxText();
        }
    }

    public double getMinimum() {
        return this.min;
    }

    public double getMaximum() {
        return this.max;
    }
}

