/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.data;

import edu.udo.cs.jvito.data.Source;
import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.jvito.util.Logger;
import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.DatabaseExampleTable;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.example.ResultSetDataRowReader;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.io.DatabaseExampleSource;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.tools.DatabaseHandler;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.OperatorService;
import edu.udo.cs.yale.tools.Tools;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DBExampleSource
extends Source {
    private DatabaseExampleSource ex_source;
    private DatabaseHandler dbAccess;

    public DBExampleSource() {
        this.plots = new LinkedList();
        this.sources = new LinkedList();
        this.initExampleSource();
    }

    public DBExampleSource(String name) {
        this.name = name;
        this.plots = new LinkedList();
        this.sources = new LinkedList();
        this.initExampleSource();
    }

    public void initExampleSource() {
        if (this.ex_source == null) {
            try {
                this.ex_source = (DatabaseExampleSource)OperatorService.createOperator("DatabaseExampleSource");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        if (this.ex_source == null) {
            this.initExampleSource();
        }
        List types_source = this.ex_source.getParameterTypes();
        Iterator iter = types_source.iterator();
        while (iter.hasNext()) {
            ParameterType type = (ParameterType)iter.next();
            types.add(type);
        }
        return types;
    }

    public void compile() throws CompilerException {
        IOObject[] obj;
        this.iscompiling = true;
        try {
            obj = this.apply();
        }
        catch (OperatorException e) {
            this.iscompiling = false;
            throw new CompilerException(e.getMessage(), e);
        }
        this.exampleset = (ExampleSet)obj[0];
        this.iscompiling = false;
        this.iscompiled = true;
    }

    public void setNominalValues(List attributeList, ResultSet resultSet, Attribute label) {
        this.setNominalValuesForLabel(label);
    }

    public void setNominalValuesForLabel(Attribute label) {
        if (label != null) {
            String classes = this.getParameterAsString("classes");
            if (label.isNominal()) {
                if (classes != null) {
                    String[] labelClasses = classes.split(" ");
                    for (int i = 0; i < labelClasses.length; ++i) {
                        label.mapString(labelClasses[i].trim());
                    }
                }
            } else if (classes != null && classes.length() > 0) {
                Logger.logMessage("Ignoring classes for non-nominal attribute " + label.getName() + ".", 5);
            }
        }
    }

    public IOObject[] apply() throws OperatorException {
        if (!this.getParameterAsBoolean("work_on_database")) {
            IOObject[] output = this.apply2();
            try {
                this.dbAccess.disconnect();
            }
            catch (SQLException sqle) {
                LogService.logException("Could not disconnect from Database!", sqle);
            }
            return output;
        }
        try {
            String tableName = this.getParameterAsString("table_name");
            if (tableName == null) {
                throw new OperatorException("You must specify a tablename.");
            }
            DatabaseExampleTable table = DatabaseExampleTable.createDatabaseExampleTable(this.getConnectedDatabaseHandler(), tableName);
            return new IOObject[]{this.createExampleSet(table)};
        }
        catch (SQLException e) {
            throw new OperatorException(e.getMessage(), e);
        }
        catch (CompilerException e) {
            throw new OperatorException(e.getMessage(), e);
        }
    }

    public IOObject[] apply2() throws OperatorException {
        ResultSet resultSet;
        int dataRowType = this.getParameterAsInt("datamanagement");
        try {
            resultSet = this.getResultSet();
        }
        catch (CompilerException e) {
            throw new OperatorException(e.getMessage(), e);
        }
        List attributeList = null;
        try {
            attributeList = DatabaseHandler.createAttributes(resultSet);
        }
        catch (SQLException e) {
            throw new OperatorException(e.getMessage(), e);
        }
        this.setNominalValues(attributeList, resultSet, DBExampleSource.find(attributeList, this.getParameterAsString("label_attribute")));
        ResultSetDataRowReader reader = new ResultSetDataRowReader(new DataRowFactory(dataRowType), attributeList, resultSet);
        MemoryExampleTable table = new MemoryExampleTable(attributeList, reader);
        return new IOObject[]{this.createExampleSet(table)};
    }

    private static Attribute find(List attributeList, String name) throws OperatorException {
        if (name == null) {
            return null;
        }
        Iterator i = attributeList.iterator();
        while (i.hasNext()) {
            Attribute attribute = (Attribute)i.next();
            if (!attribute.getName().equals(name)) continue;
            return attribute;
        }
        throw new UserError(null, 111, name);
    }

    protected ExampleSet createExampleSet(ExampleTable table) throws OperatorException {
        String labelName = this.getParameterAsString("label_attribute");
        String weightName = this.getParameterAsString("weight_attribute");
        String idName = this.getParameterAsString("id_attribute");
        Attribute label = table.findAttribute(labelName);
        Attribute weight = table.findAttribute(weightName);
        Attribute id = table.findAttribute(idName);
        return table.createCompleteExampleSet(label, null, weight, id);
    }

    private String getQuery() throws CompilerException {
        String query = this.getParameterAsString("query");
        String parameterUsed = null;
        boolean warning = false;
        if (query == null) {
            String queryFileName = this.getParameterAsString("query_file");
            File queryFile = new File(queryFileName);
            if (queryFileName != null) {
                try {
                    query = Tools.readTextFile(queryFile);
                    parameterUsed = "query_file";
                }
                catch (IOException ioe) {
                    throw new CompilerException(ioe.getMessage(), ioe);
                }
                if (query.length() == 0) {
                    throw new CompilerException("Query-length is 0.");
                }
            }
        } else {
            parameterUsed = "query";
            if (this.isParameterSet("query_file")) {
                warning = true;
            }
        }
        if (query == null) {
            if (this.isParameterSet("table_name")) {
                query = "select * from " + this.getParameterAsString("table_name");
                parameterUsed = "table_name";
            }
        } else if (this.isParameterSet("table_name")) {
            warning = true;
        }
        if (query == null) {
            throw new CompilerException("No Query!");
        }
        if (warning) {
            LogService.logMessage("Only one of the parameters 'query', 'query_file', and 'table_name' have to be set. Using value of '" + parameterUsed + "'.", 4);
        }
        return query;
    }

    public DatabaseHandler getConnectedDatabaseHandler() throws CompilerException, SQLException {
        String driver = this.getParameterAsString("driver");
        if (driver == null || driver.length() == 0) {
            throw new CompilerException("You need a driver for database-access.");
        }
        String urlprefix = this.getParameterAsString("urlprefix");
        String databasename = this.getParameterAsString("databasename");
        String username = this.getParameterAsString("username");
        String password = this.getParameterAsString("password");
        if (password == null) {
            password = Yale.getInputHandler().inputPassword(databasename + ": Password for user '" + username + "' required");
        }
        DatabaseHandler databaseHandler = new DatabaseHandler(databasename, urlprefix, driver);
        Logger.logMessage("Connecting to '" + urlprefix + "' (" + databasename + ").", 0);
        databaseHandler.connect(username, password, true);
        return databaseHandler;
    }

    public ResultSet getResultSet() throws CompilerException {
        ResultSet rs = null;
        try {
            this.dbAccess = this.getConnectedDatabaseHandler();
            String query = this.getQuery();
            LogService.logMessage("Executing query: '" + query + "'", 0);
            rs = this.dbAccess.query(query);
            Logger.logMessage("Query executed.", 0);
        }
        catch (SQLException sqle) {
            throw new CompilerException(sqle.getMessage(), sqle);
        }
        return rs;
    }
}

