/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito;

import edu.udo.cs.jvito.JViTo;
import edu.udo.cs.jvito.OperatorDescription;
import edu.udo.cs.jvito.OperatorsReader;
import edu.udo.cs.jvito.XMLDocument;
import edu.udo.cs.jvito.compile.Compileable;
import edu.udo.cs.jvito.data.Source;
import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.jvito.exception.XMLException;
import edu.udo.cs.jvito.parameter.ParameterObject;
import edu.udo.cs.jvito.util.Resources;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.awt.Image;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Project
extends ParameterObject
implements XMLDocument,
Compileable {
    public static final String[] WOCHENTAGE = new String[]{Resources.getString("SUNDAY"), Resources.getString("MONDAY"), Resources.getString("TUESDAY"), Resources.getString("WEDNESDAY"), Resources.getString("THURSDAY"), Resources.getString("FRIDAY"), Resources.getString("SATURDAY")};
    private String name;
    private String oldname;
    private LinkedList sources;

    public Project() {
        this(Resources.getString("NEW_PROJECT"));
    }

    public Project(String name) {
        this.name = name;
        this.oldname = name;
        this.sources = new LinkedList();
    }

    public String getName() {
        return this.name;
    }

    public String getOldName() {
        return this.oldname;
    }

    public void setName(String name) {
        this.oldname = this.name;
        this.name = name;
        JViTo.getApplication().setDirty();
    }

    public int getSourceCount() {
        return this.sources.size();
    }

    public Source getSource(int index) {
        return (Source)this.sources.get(index);
    }

    public void addSource(Source source) {
        this.sources.add(source);
    }

    public void addSource(Source source, int index) {
        this.sources.add(index, source);
    }

    public void removeSource(Source source) {
        this.sources.remove(source);
    }

    public Image getImage() {
        return Resources.getImage("TREE_PROJECT");
    }

    public void setParameter(String key, Object object) {
        if (key.equals("Created on") || key.equals("Last changes")) {
            return;
        }
        super.setParameter(key, object);
    }

    public void setCreationParameter(String created) {
        GregorianCalendar cal = new GregorianCalendar();
        int wochentag = cal.get(7);
        if (created == null) {
            created = new String("");
            created = created + WOCHENTAGE[wochentag - 1];
            created = created + "   " + this.adjustLength(cal.get(5), 2);
            created = created + "." + this.adjustLength(cal.get(2) + 1, 2);
            created = created + "." + cal.get(1);
            created = created + "   " + this.adjustLength(cal.get(11), 2);
            created = created + ":" + this.adjustLength(cal.get(12), 2);
            created = created + ":" + this.adjustLength(cal.get(13), 2);
        }
        super.setParameter("Created on", (Object)created);
    }

    private String adjustLength(int value, int length) {
        String back = Integer.toString(value);
        while (back.length() < length) {
            back = "0" + back;
        }
        return back;
    }

    public void setChangesParameter(String changes) {
        GregorianCalendar cal = new GregorianCalendar();
        int wochentag = cal.get(7);
        if (changes == null) {
            changes = new String("");
            changes = changes + WOCHENTAGE[wochentag - 1];
            changes = changes + "   " + this.adjustLength(cal.get(5), 2);
            changes = changes + "." + this.adjustLength(cal.get(2) + 1, 2);
            changes = changes + "." + cal.get(1);
            changes = changes + "   " + this.adjustLength(cal.get(11), 2);
            changes = changes + ":" + this.adjustLength(cal.get(12), 2);
            changes = changes + ":" + this.adjustLength(cal.get(13), 2);
        }
        super.setParameter("Last changes", (Object)changes);
    }

    public List getParameterTypes() {
        ArrayList<ParameterTypeString> types = new ArrayList<ParameterTypeString>();
        ParameterTypeString type = new ParameterTypeString("Created on", "The project was created on this date and time.", false);
        types.add(type);
        type = new ParameterTypeString("Last changes", "The project was changed last on this date and time.", false);
        types.add(type);
        type = new ParameterTypeString("Author(s)", "The author(s) of the project.", true);
        types.add(type);
        type = new ParameterTypeString("Version", "The version of the project.", true);
        types.add(type);
        return types;
    }

    public String getClassName() {
        String classname = this.getClass().getName();
        return classname.substring(classname.lastIndexOf(".") + 1);
    }

    public String getXML(String indent) {
        StringBuffer result = new StringBuffer();
        result.append(indent + "<project " + "name=\"" + this.name + "\" " + "class=\"" + this.getClass().getName() + "\">\n");
        result.append(indent + "  <description text=\"" + this.getDescription() + "\"/>\n");
        result.append(this.parameters.getXML(indent + "\t"));
        LinkedList childs = this.getXMLDocChilds();
        Iterator iter = childs.iterator();
        while (iter.hasNext()) {
            XMLDocument doc = (XMLDocument)iter.next();
            result.append(doc.getXML(indent + "\t"));
        }
        result.append(indent + "</project>\n");
        return result.toString();
    }

    public LinkedList getXMLDocChilds() {
        return this.sources;
    }

    private String createDescriptionFromXML(Element element) throws XMLException {
        Attr textAttr = element.getAttributeNode("text");
        if (textAttr == null) {
            throw new XMLException("Attribute 'text' of <description> tag is not set.");
        }
        if (element.getChildNodes().getLength() > 0) {
            throw new XMLException("No inner tags allowed for <description>");
        }
        return textAttr.getValue();
    }

    private Object[] createParameterFromXML(Element element) throws XMLException {
        Attr keyAttr = element.getAttributeNode("key");
        Attr valueAttr = element.getAttributeNode("value");
        if (keyAttr == null) {
            throw new XMLException("Attribute 'key' of <parameter> tag is not set.");
        }
        if (valueAttr == null) {
            throw new XMLException("Attribute 'value' of <parameter> tag is not set.");
        }
        if (element.getChildNodes().getLength() > 0) {
            throw new XMLException("No inner tags allowed for <parameter>");
        }
        return new Object[]{keyAttr.getValue(), valueAttr.getValue()};
    }

    public void loadXMLDocument(Element element) throws XMLException {
        if (!element.getTagName().toLowerCase().equals("project")) {
            throw new XMLException("<project> expected!");
        }
        String className = null;
        String name = null;
        Attr classAttr = element.getAttributeNode("class");
        if (classAttr == null) {
            throw new XMLException("Attribute 'class' of <project> tag is not defined! ");
        }
        className = classAttr.getValue();
        Attr nameAttr = element.getAttributeNode("name");
        if (nameAttr == null) {
            throw new XMLException("Attribute 'name' of <project> tag is not defined! ");
        }
        name = nameAttr.getValue();
        if (!className.equals("edu.udo.cs.jvito.Project")) {
            throw new XMLException(" class=\"edu.udo.cs.jvito.Project\" expected");
        }
        this.setName(name);
        NodeList innerTags = element.getChildNodes();
        for (int i = 0; i < innerTags.getLength(); ++i) {
            Node node = innerTags.item(i);
            if (!(node instanceof Element)) continue;
            Element inner = (Element)node;
            if (inner.getTagName().toLowerCase().equals("parameter")) {
                Object[] parameter = this.createParameterFromXML(inner);
                if (((String)parameter[0]).equals("Created on")) {
                    this.setCreationParameter((String)parameter[1]);
                    continue;
                }
                if (parameter[0].equals("Last Changes")) {
                    this.setChangesParameter((String)parameter[1]);
                    continue;
                }
                this.getParameters().setParameter((String)parameter[0], parameter[1]);
                continue;
            }
            if (inner.getTagName().toLowerCase().equals("source")) {
                Class<?> c;
                classAttr = inner.getAttributeNode("class");
                if (classAttr == null) {
                    throw new XMLException("Attribute 'class' of <source> tag is not defined! ");
                }
                className = classAttr.getValue();
                Source source = null;
                try {
                    c = Class.forName(className);
                    source = (Source)c.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new XMLException("Can't find class " + className, e);
                }
                catch (InstantiationException e) {
                    throw new XMLException("Can not instantiate the class for className: " + className, e);
                }
                catch (IllegalAccessException e) {
                    throw new XMLException("Illegal Access for the class: " + className, e);
                }
                catch (ClassCastException e) {
                    throw new XMLException("Can not cast from " + className + " to Source!");
                }
                OperatorDescription opdesc = OperatorsReader.getOperatorDescription(c);
                source.setImage(opdesc.getIcon());
                source.loadXMLDocument(inner);
                this.addSource(source);
                continue;
            }
            if (inner.getTagName().toLowerCase().equals("description")) {
                String description = this.createDescriptionFromXML(inner);
                this.setDescription(description);
                continue;
            }
            throw new XMLException("Ilegal inner tag for <project>: " + inner.getTagName());
        }
    }

    public void writeXML(PrintWriter out, String indent) {
    }

    public void compile() throws CompilerException {
    }

    public Compileable getCompileableChild(int index) {
        return (Compileable)this.sources.get(index);
    }

    public int getCompileableChildCount() {
        return this.sources.size();
    }

    public Compileable getParentCompileableObject() {
        return null;
    }

    public boolean isCompiled() {
        return true;
    }

    public boolean isCompiling() {
        return false;
    }

    public void fireIsCompiled() {
    }
}

