/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito;

import edu.udo.cs.jvito.gui.Application;
import edu.udo.cs.jvito.util.Resources;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.tools.Tools;
import java.io.File;

public class JViTo {
    private static Application app;
    private static String workingDir;
    private static boolean resourcesloaded;

    public static Application getApplication() {
        return app;
    }

    public static File resolveFileName(String name) {
        File workingDir = new File(JViTo.getWorkingDir());
        return Tools.getFile(app.getProjectFile() != null ? app.getProjectFile().getParentFile() : workingDir, name);
    }

    public static String getWorkingDir() {
        return workingDir;
    }

    public static void setWorkingDir(String dir) {
        workingDir = dir;
    }

    public static void loadResources() {
        if (!resourcesloaded) {
            Resources.addResource("edu/udo/cs/jvito/resources/jvito_constants");
            resourcesloaded = true;
        }
    }

    public static void initApplication(boolean dispose_on_exit) {
        app = new Application();
        if (dispose_on_exit) {
            app.setTypeHowToExit(1);
        }
        app.init();
    }

    public static boolean isApplicationOpen() {
        if (app == null) {
            return false;
        }
        return app.isOpen();
    }

    public static void initApplication(ExampleSet exampleset) {
        app = new Application();
        app.setTypeHowToExit(1);
        app.init();
        app.promptNew();
        app.addOperator(exampleset);
    }

    public static void setPreferencesFile(String file) {
        System.setProperty("JVITO_PREFERENCES", file);
    }

    public static void main(String[] args) {
        JViTo.loadResources();
        System.setProperty("yale.gui.resultviewer.attributelimit", "100");
        if (args.length < 1) {
            System.out.println("Specify the preferences-file as first argument!");
            return;
        }
        JViTo.setPreferencesFile(args[0]);
        JViTo.initApplication(false);
        if (args.length >= 2) {
            JViTo.getApplication().promptOpen(new File(args[1]));
        }
    }

    static {
        resourcesloaded = false;
    }
}

