/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.print;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import org.musoft.limo.application.Application;
import org.musoft.limo.application.Resource;
import org.musoft.limo.print.PrinterSource;

public class PrinterDialog
extends JDialog {
    private static final int height = 320;
    private static final int width = 450;
    private PrinterSource[] printPanels;
    private JCheckBox[] selection;
    private JCheckBox selAllCBox;
    private BufferedImage image = new BufferedImage(120, 120, 1);
    private JRadioButton sc;
    private JRadioButton mp;
    private Application owner;
    private JLabel preview;
    private boolean result;
    private boolean selectAll = false;
    private JPanel[] listItems;
    private int oldIndex = -1;
    private Hashtable indexTable;

    public PrinterDialog(Application application, PrinterSource[] printerSourceArray) {
        super(application, Resource.getString("PRINT_TITLE"), true);
        Serializable serializable;
        this.owner = application;
        this.printPanels = printerSourceArray;
        JPanel jPanel = new JPanel(null);
        jPanel.setMinimumSize(new Dimension(450, 320));
        jPanel.setPreferredSize(new Dimension(450, 320));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Resource.getString("PRINT_FORMAT")), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.sc = new JRadioButton(Resource.getString("PRINT_SCALED"), true);
        this.sc.setMinimumSize(new Dimension(210, 25));
        this.sc.setPreferredSize(new Dimension(210, 25));
        this.sc.setMaximumSize(new Dimension(210, 25));
        this.mp = new JRadioButton(Resource.getString("PRINT_MULTIPAGE"), false);
        this.mp.setMinimumSize(new Dimension(210, 25));
        this.mp.setPreferredSize(new Dimension(210, 25));
        this.mp.setMaximumSize(new Dimension(210, 25));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.sc);
        buttonGroup.add(this.mp);
        jPanel2.add(this.sc);
        jPanel2.add(this.mp);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Resource.getString("PRINT_WHAT")), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        BoxLayout boxLayout = new BoxLayout(jPanel3, 1);
        jPanel3.setLayout(boxLayout);
        JPanel jPanel4 = new JPanel();
        int n = this.printPanels.length < 5 ? 5 : 0;
        JPanel jPanel5 = new JPanel(new GridLayout(n, 1));
        jPanel5.setForeground(Color.white);
        jPanel5.setBackground(Color.white);
        JScrollPane jScrollPane = new JScrollPane(jPanel5);
        jScrollPane.setMinimumSize(new Dimension(300, 120));
        jScrollPane.setPreferredSize(new Dimension(300, 120));
        jScrollPane.setMaximumSize(new Dimension(300, 120));
        jScrollPane.setForeground(Color.white);
        jScrollPane.setBackground(Color.white);
        this.selection = new JCheckBox[this.printPanels.length];
        FlowLayout flowLayout = new FlowLayout(0);
        this.listItems = new JPanel[this.printPanels.length];
        this.indexTable = new Hashtable(this.printPanels.length);
        for (int i = 0; i < this.printPanels.length; ++i) {
            final int n2 = i;
            this.listItems[i] = new JPanel();
            this.listItems[i].setLayout(flowLayout);
            this.listItems[i].setForeground(Color.WHITE);
            this.listItems[i].setBackground(Color.WHITE);
            this.selection[i] = new JCheckBox();
            this.selection[i].setBackground(Color.white);
            this.selection[i].addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    PrinterDialog.this.setPreview(n2);
                    PrinterDialog.this.selAllCBox.setSelected(false);
                }
            });
            serializable = new JLabel(this.printPanels[i].getPrintTitle());
            serializable.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    PrinterDialog.this.setPreview(n2);
                    int n = (Integer)PrinterDialog.this.indexTable.get(mouseEvent.getSource());
                    if (PrinterDialog.this.oldIndex != -1) {
                        PrinterDialog.this.listItems[PrinterDialog.this.oldIndex].setBackground(Color.WHITE);
                    }
                    PrinterDialog.this.oldIndex = n;
                    PrinterDialog.this.listItems[n].setBackground(new JList().getSelectionBackground());
                }
            });
            this.indexTable.put(serializable, new Integer(i));
            this.listItems[i].add(this.selection[i]);
            this.listItems[i].add((Component)serializable);
            jPanel5.add(this.listItems[i]);
        }
        ImageIcon imageIcon = new ImageIcon(this.image);
        this.preview = new JLabel();
        this.preview.setMinimumSize(new Dimension(120, 120));
        this.preview.setPreferredSize(new Dimension(120, 120));
        this.preview.setMaximumSize(new Dimension(120, 120));
        this.preview.setOpaque(true);
        this.preview.setForeground(Color.white);
        this.preview.setBackground(Color.white);
        this.preview.setBorder(new BevelBorder(1));
        this.preview.setIcon(imageIcon);
        jPanel4.add(jScrollPane);
        jPanel4.add(this.preview);
        this.setPreview(0);
        JPanel jPanel6 = new JPanel();
        serializable = new FlowLayout(0, 2, 0);
        jPanel6.setLayout((LayoutManager)((Object)serializable));
        jPanel6.setMinimumSize(new Dimension(425, 25));
        jPanel6.setPreferredSize(new Dimension(425, 25));
        jPanel6.setMaximumSize(new Dimension(425, 25));
        this.selAllCBox = new JCheckBox(Resource.getString("PRINT_SELECTALL"));
        this.selAllCBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                PrinterDialog.this.selectAll = ((JCheckBox)actionEvent.getSource()).isSelected();
                for (int i = 0; i < PrinterDialog.this.selection.length; ++i) {
                    if (PrinterDialog.this.selection[i].isSelected() == PrinterDialog.this.selectAll) continue;
                    PrinterDialog.this.selection[i].setSelected(PrinterDialog.this.selectAll);
                }
            }
        });
        jPanel6.add(this.selAllCBox);
        jPanel3.add(jPanel4);
        jPanel3.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout());
        JButton jButton = new JButton(Resource.getString("PRINT_OK"));
        jButton.setMinimumSize(new Dimension(120, 30));
        jButton.setPreferredSize(new Dimension(120, 30));
        jButton.setMaximumSize(new Dimension(120, 30));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrinterDialog.this.result = true;
                PrinterDialog.this.setVisible(false);
            }
        });
        JButton jButton2 = new JButton(Resource.getString("PRINT_CANCEL"));
        jButton2.setMinimumSize(new Dimension(120, 30));
        jButton2.setPreferredSize(new Dimension(120, 30));
        jButton2.setMaximumSize(new Dimension(120, 30));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrinterDialog.this.result = false;
                PrinterDialog.this.setVisible(false);
            }
        });
        jPanel7.add(jButton);
        jPanel7.add(jButton2);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 1));
        jPanel8.setMinimumSize(new Dimension(450, 320));
        jPanel8.setPreferredSize(new Dimension(450, 320));
        jPanel8.setMaximumSize(new Dimension(450, 320));
        jPanel8.add(jPanel3);
        jPanel8.add(jPanel2);
        jPanel8.add(jPanel7);
        this.getContentPane().add(jPanel8);
        this.setResizable(false);
        this.pack();
    }

    private void setPreview(int n) {
        Rectangle rectangle = this.printPanels[n].getPrintBounds();
        Graphics2D graphics2D = this.image.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, 120, 120);
        AffineTransform affineTransform = new AffineTransform();
        double d = Math.min(120.0 / rectangle.getWidth(), 120.0 / rectangle.getHeight());
        affineTransform.scale(d, d);
        affineTransform.translate(-rectangle.x, -rectangle.y);
        graphics2D.setTransform(affineTransform);
        this.printPanels[n].doPrintComponent(graphics2D);
        this.preview.repaint();
    }

    public boolean getFitToPage() {
        return this.sc.isSelected();
    }

    public void setFitToPage(boolean bl) {
        this.sc.setSelected(bl);
        this.mp.setSelected(!bl);
    }

    public boolean[] getSelection() {
        boolean[] blArray = new boolean[this.selection.length];
        for (int i = 0; i < this.selection.length; ++i) {
            blArray[i] = this.selection[i].isSelected();
        }
        return blArray;
    }

    public void setSelection(boolean[] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            this.selection[i].setSelected(blArray[i]);
        }
    }

    public boolean getResult() {
        return this.result;
    }
}

