/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.navigator;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jhotdraw.util.Iconkit;
import org.musoft.limo.application.Application;
import org.musoft.limo.application.Resource;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.navigator.RessourceTree;

public class RessourceTreeNode
extends DefaultMutableTreeNode {
    private Vector childs;
    private String elementName;
    private int typeIndex = 0;
    private ModelElement thisElement;
    private RessourceTree tree;
    private Application app;
    private JLabel hasFocusLabel;
    private JLabel selLabel;
    private JLabel standardLabel;
    private ImageIcon labelIcon;
    public static final int BAUMBREITE = 400;
    public static final int BAUMHOEHE = 2000;
    public static final Font HASFOCUS_FONT = new Font("ARIAL", 1, 12);
    public static final Color HASFOCUS_FONTCOLOR = Color.black;
    public static final Font STANDARD_FONT = new Font("ARIAL", 0, 12);
    public static final Color STANDARD_FONTCOLOR = Color.darkGray;
    public Iconkit kit = Iconkit.instance();
    public ImageIcon StandardIcon = new ImageIcon(this.kit.loadImage(Resource.getString("STANDARD_ICON"), true));

    public RessourceTreeNode() {
        this.childs = new Vector();
    }

    public RessourceTreeNode(ModelElement modelElement, String string, RessourceTree ressourceTree, Application application) {
        super(modelElement);
        this.elementName = string;
        this.thisElement = modelElement;
        this.childs = new Vector();
        this.createLabels(this.thisElement);
        this.tree = ressourceTree;
        this.app = application;
    }

    public String getElementName() {
        return this.elementName;
    }

    public ModelElement getElement() {
        return this.thisElement;
    }

    public void createLabels(ModelElement modelElement) {
        String string = modelElement.toString();
        String string2 = Resource.getIconPath(this.thisElement.getType());
        this.labelIcon = new ImageIcon(this.kit.loadImage(string2, true));
        this.selLabel = new JLabel(string, this.labelIcon, 2);
        this.selLabel.setFont(HASFOCUS_FONT);
        this.selLabel.setForeground(HASFOCUS_FONTCOLOR);
        this.selLabel.setBorder(new LineBorder(Color.LIGHT_GRAY));
        this.selLabel.setOpaque(false);
        this.selLabel.setMaximumSize(new Dimension(400, 24));
        this.selLabel.setMinimumSize(new Dimension(400, 24));
        this.selLabel.setPreferredSize(new Dimension(400, 24));
        this.standardLabel = new JLabel(string, this.labelIcon, 2);
        this.standardLabel.setFont(STANDARD_FONT);
        this.standardLabel.setForeground(STANDARD_FONTCOLOR);
        this.standardLabel.setOpaque(false);
        this.standardLabel.setMaximumSize(new Dimension(400, 24));
        this.standardLabel.setMinimumSize(new Dimension(400, 24));
        this.standardLabel.setPreferredSize(new Dimension(400, 24));
        this.hasFocusLabel = new JLabel(string, this.labelIcon, 2);
        this.hasFocusLabel.setFont(HASFOCUS_FONT);
        this.hasFocusLabel.setForeground(new Color(135, 25, 25));
        this.hasFocusLabel.setBorder(new LineBorder(Color.GRAY));
        this.hasFocusLabel.setOpaque(false);
        this.hasFocusLabel.setMaximumSize(new Dimension(400, 24));
        this.hasFocusLabel.setMinimumSize(new Dimension(400, 24));
        this.hasFocusLabel.setPreferredSize(new Dimension(400, 24));
    }

    public void updateLabels(ModelElement modelElement) {
        this.selLabel.setText(modelElement.toString());
        this.standardLabel.setText(modelElement.toString());
        this.hasFocusLabel.setText(modelElement.toString());
    }

    public JLabel getLabel(boolean bl, boolean bl2) {
        if (bl) {
            return this.selLabel;
        }
        if (bl2) {
            return this.hasFocusLabel;
        }
        return this.standardLabel;
    }

    public ModelElement getThisElement() {
        return this.thisElement;
    }
}

