/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.model;

import java.awt.Rectangle;
import java.util.Vector;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelEnumeration;
import org.musoft.limo.model.ModelException;
import org.musoft.limo.model.ModelFigureElement;

public class Model
extends ModelFigureElement {
    private Vector connections = new Vector();
    private boolean dirty;

    public Model() {
        this(null);
    }

    public Model(String string) {
        this(string, null, null);
    }

    public Model(String string, Rectangle rectangle, ModelFigureElement modelFigureElement) {
        super(string, rectangle, modelFigureElement);
    }

    public String getValidConnectionName(String string) {
        for (int i = 1; i < 10000; ++i) {
            String string2 = string + i;
            if (this.getConnection(string2) != null) continue;
            return string2;
        }
        throw new ModelException("Kein Name mehr frei - zuviele Verbindungen");
    }

    public ModelConnectionElement getConnection(String string) {
        int n = this.indexOfConnection(string);
        if (n == -1) {
            return null;
        }
        ModelConnectionElement modelConnectionElement = this.getConnection(n);
        return modelConnectionElement;
    }

    public int indexOfConnection(String string) {
        if (string != null) {
            for (int i = 0; i < this.getConnectionCount(); ++i) {
                if (!string.equals(this.getConnection(i).getName())) continue;
                return i;
            }
        }
        return -1;
    }

    public Model getRootModel() {
        return this.getModel() == null ? this : this.getModel().getRootModel();
    }

    public void addConnection(ModelConnectionElement modelConnectionElement) {
        this.connections.add(modelConnectionElement);
    }

    public int getConnectionCount() {
        return this.connections.size();
    }

    public ModelConnectionElement getConnection(int n) {
        return (ModelConnectionElement)this.connections.get(n);
    }

    public ModelEnumeration getConnections(Class clazz) {
        Vector<ModelConnectionElement> vector = new Vector<ModelConnectionElement>();
        for (int i = 0; i < this.getConnectionCount(); ++i) {
            ModelConnectionElement modelConnectionElement = this.getConnection(i);
            if (!clazz.isInstance(modelConnectionElement)) continue;
            vector.add(modelConnectionElement);
        }
        return new ModelEnumeration(vector.elements());
    }

    public int indexOfConnection(ModelConnectionElement modelConnectionElement) {
        return this.connections.indexOf(modelConnectionElement);
    }

    public void removeConnection(ModelConnectionElement modelConnectionElement) {
        this.connections.remove(modelConnectionElement);
    }

    public void removeConnection(int n) {
        this.connections.remove(n);
    }

    public boolean canAddChild(ModelFigureElement modelFigureElement) {
        return true;
    }

    public boolean canRemoveChild(ModelFigureElement modelFigureElement) {
        return true;
    }

    public void destroy() {
        super.destroy();
        for (int i = 0; i < this.getConnectionCount(); ++i) {
            this.getConnection(i).destroy();
        }
    }

    public ModelElement getElement(String string) {
        int n;
        int n2;
        String string2 = null;
        if (string.startsWith("Proxy") && (n2 = this.indexOfChild(string)) != -1) {
            return this.getChild(n2);
        }
        n2 = string.indexOf(46);
        if (n2 != -1) {
            string2 = string.substring(n2 + 1);
            string = string.substring(0, n2);
        }
        if ((n = this.indexOfChild(string)) == -1) {
            if (string2 == null && (n = this.indexOfConnection(string)) != -1) {
                return this.getConnection(n);
            }
            return null;
        }
        ModelFigureElement modelFigureElement = this.getChild(n);
        if (string2 != null) {
            return modelFigureElement.getElement(string2);
        }
        return modelFigureElement;
    }

    public void changed() {
        Model model = this.getRootModel();
        if (model != null) {
            model.setDirty(true);
        } else {
            this.setDirty(true);
        }
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        if (bl != this.dirty) {
            this.dirty = bl;
            for (int i = this.getListenerCount() - 1; i >= 0; --i) {
                this.getListener(i).onSetDirty();
            }
        }
    }

    public ModelElement getChildOrConnection(String string) {
        ModelElement modelElement = super.getChildOrConnection(string);
        if (modelElement != null) {
            return modelElement;
        }
        return this.getConnection(string);
    }
}

