/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.drawing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.jhotdraw.contrib.GraphicalCompositeFigure;
import org.jhotdraw.figures.RectangleFigure;
import org.jhotdraw.figures.TextFigure;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.FigureChangeListener;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.standard.BoxHandleKit;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.standard.NullHandle;
import org.jhotdraw.standard.RelativeLocator;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.ColorMap;
import org.musoft.limo.drawing.ModelConnection;
import org.musoft.limo.drawing.ModelDrawing;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelAssociationEnd;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelListener;
import org.musoft.limo.model.ModelPrimitiveAttribute;
import org.musoft.limo.util.LogFile;

public class ModelFigure
extends GraphicalCompositeFigure
implements ModelListener {
    public static final int LABEL_HIDDEN = 0;
    public static final int LABEL_INSIDE = 1;
    public static final int LABEL_OUTSIDE = 2;
    public static final int LABEL_EAST = 16;
    public static final int LABEL_NORTH = 32;
    public static final int LABEL_WEST = 64;
    public static final int LABEL_SOUTH = 128;
    public static final int LABEL_CENTER = 240;
    private ModelDrawing drawing;
    private ModelFigureElement element;
    private String labelText;
    private int labelPosition;
    protected TextFigure labelFigure;
    private Hashtable associates = new Hashtable();
    private Figure decoration;
    private boolean sizeable = true;
    private boolean moveable = true;

    public ModelFigure(ModelFigureElement modelFigureElement, ModelDrawing modelDrawing) {
        if (modelDrawing != null) {
            this.drawing = modelDrawing;
            modelDrawing.add((Figure)this);
        }
        this.setElement(modelFigureElement);
        Rectangle rectangle = modelFigureElement.getBounds();
        if (rectangle != null) {
            this.basicDisplayBox(rectangle.getLocation(), new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
        }
        this.getPresentationFigure().setAttribute(FigureAttributeConstant.getConstant((String)"FillColor"), ((ModelPrimitiveAttribute)modelFigureElement.getAttribute("Color")).getValue());
    }

    protected void initialize() {
    }

    public void addToContainer(FigureChangeListener figureChangeListener) {
        super.addToContainer(figureChangeListener);
        if (figureChangeListener instanceof ModelDrawing) {
            this.drawing = (ModelDrawing)figureChangeListener;
        }
    }

    public void displayBox(Point point, Point point2) {
        if (this.sizeable) {
            this.element.setBounds(point, point2);
        }
    }

    public void moveBy(int n, int n2) {
        if (this.moveable) {
            try {
                if (this.element != null) {
                    this.element.setPosition(n, n2);
                }
            }
            catch (Exception exception) {
                LogFile.log("ModelFigure.moveBy(): NPE beim Verschieben von Figur '" + this.getLabelFigure().getText() + "'", LogFile.INFO);
                LogFile.log(exception);
            }
        }
    }

    public void basicDisplayBox(Point point, Point point2) {
        if (this.getLayouter() != null) {
            Rectangle rectangle = this.getLayouter().layout(point, point2);
            this.getPresentationFigure().basicDisplayBox(rectangle.getLocation(), new Point(rectangle.width, rectangle.height));
        } else {
            this.getPresentationFigure().basicDisplayBox(point, point2);
        }
    }

    public HandleEnumeration handles() {
        List list = CollectionsFactory.current().createList();
        if (this.sizeable) {
            BoxHandleKit.addHandles((Figure)this, (List)list);
        } else {
            list.add(new NullHandle((Figure)this, RelativeLocator.northWest()));
            list.add(new NullHandle((Figure)this, RelativeLocator.northEast()));
            list.add(new NullHandle((Figure)this, RelativeLocator.southEast()));
            list.add(new NullHandle((Figure)this, RelativeLocator.southWest()));
        }
        return new HandleEnumerator((Collection)list);
    }

    public ModelDrawing getDrawing() {
        return this.drawing;
    }

    private void setElement(ModelFigureElement modelFigureElement) {
        this.element = modelFigureElement;
        if (modelFigureElement != null) {
            modelFigureElement.addListener(this);
            this.getDrawing().putElementFigure(modelFigureElement, this);
        }
    }

    public ModelFigureElement getElement() {
        return this.element;
    }

    public String getLabel() {
        return this.labelText;
    }

    public void setLabel(String string) {
        this.labelText = string;
        this.updateLabel();
    }

    public int getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(int n) {
        this.labelPosition = n;
        this.updateLabel();
    }

    private void updateLabel() {
        if ((this.labelPosition & 0xF) == 0 && this.labelFigure != null) {
            this.labelFigure.release();
            this.labelFigure = null;
        } else if ((this.labelPosition & 0xF) != 0 && this.labelFigure == null) {
            this.labelFigure = new TextFigure();
            this.labelFigure.setReadOnly(true);
            this.labelFigure.setFont(new Font("Helvetica", 1, 12));
            this.add((Figure)this.labelFigure);
        }
        if (this.labelFigure == null) {
            return;
        }
        this.labelFigure.setText(this.labelText == null ? "(null)" : this.labelText);
        Rectangle rectangle = this.displayBox();
        Rectangle rectangle2 = this.labelFigure.displayBox();
        if ((this.labelPosition & 0xF) == 2) {
            switch (this.labelPosition & 0xF0) {
                case 16: {
                    rectangle2.x = rectangle.x + rectangle.width + 4;
                    rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height) / 2;
                    break;
                }
                case 32: {
                    rectangle2.x = rectangle.x + (rectangle.width - rectangle2.width) / 2;
                    rectangle2.y = rectangle.y - rectangle2.height;
                    break;
                }
                case 64: {
                    rectangle2.x = rectangle.x - rectangle2.width - 4;
                    rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height) / 2;
                    break;
                }
                case 128: {
                    rectangle2.x = rectangle.x + (rectangle.width - rectangle2.width) / 2;
                    rectangle2.y = rectangle.y + rectangle.height;
                }
            }
        } else {
            switch (this.labelPosition & 0xF0) {
                case 16: {
                    rectangle2.x = rectangle.x + rectangle.width - rectangle2.width - 4;
                    rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height) / 2;
                    break;
                }
                case 32: {
                    rectangle2.x = rectangle.x + (rectangle.width - rectangle2.width) / 2;
                    rectangle2.y = rectangle.y;
                    break;
                }
                case 64: {
                    rectangle2.x = rectangle.x + 4;
                    rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height) / 2;
                    break;
                }
                case 128: {
                    rectangle2.x = rectangle.x + (rectangle.width - rectangle2.width) / 2;
                    rectangle2.y = rectangle.y - rectangle.height;
                    break;
                }
                case 240: {
                    rectangle2.x = rectangle.x + (rectangle.width - rectangle2.width) / 2;
                    rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height) / 2;
                }
            }
        }
        this.labelFigure.displayBox(rectangle2);
    }

    public void onSetName(ModelElement modelElement) {
    }

    public void onSetPosition(ModelFigureElement modelFigureElement, int n, int n2) {
        if (modelFigureElement == this.element) {
            this.willChange();
            this.basicMoveBy(n, n2);
            this.changed();
        }
    }

    public void onSetBounds(ModelFigureElement modelFigureElement) {
        if (modelFigureElement == this.element) {
            this.willChange();
            this.basicDisplayBox(modelFigureElement.getPosition(), modelFigureElement.getCorner());
            this.changed();
            this.updateLabel();
        }
    }

    public void onSetParent(ModelFigureElement modelFigureElement) {
    }

    public void onAddChild(ModelFigureElement modelFigureElement, ModelElement modelElement) {
    }

    public void onRemoveChild(ModelFigureElement modelFigureElement, ModelElement modelElement) {
    }

    public void onSetAttribute(ModelElement modelElement, String string, Object object) {
        if (modelElement == this.element && string.equals("Color")) {
            this.getPresentationFigure().setAttribute(FigureAttributeConstant.getConstant((String)"FillColor"), (Object)((Color)object));
            this.invalidate();
        }
    }

    public void onCreateChild(ModelFigureElement modelFigureElement, ModelElement modelElement) {
    }

    public void onDestroy(ModelElement modelElement) {
        if (modelElement == this.element) {
            if (this.labelFigure != null) {
                this.labelFigure.release();
            }
            if (this.element != null) {
                this.getDrawing().putElementFigure(this.element, null);
                this.element = null;
            }
            if (this.drawing.includes((Figure)this)) {
                this.drawing.remove((Figure)this);
            }
            this.release();
        }
    }

    public void onAddAssociate(ModelElement modelElement, ModelAssociationEnd modelAssociationEnd, ModelElement modelElement2) {
    }

    public void onRemoveAssociate(ModelElement modelElement, ModelAssociationEnd modelAssociationEnd, ModelElement modelElement2) {
    }

    protected ModelConnection createConnector(ModelPrimitiveAttribute modelPrimitiveAttribute, ModelElement modelElement) {
        return null;
    }

    public void setDecoration(Color color) {
        if (this.decoration != null) {
            this.orphan(this.decoration);
            this.decoration.release();
            this.decoration = null;
        }
        if (color != null) {
            this.decoration = new RectangleFigure();
            Rectangle rectangle = this.displayBox();
            this.decoration.displayBox(new Rectangle(rectangle.x - 2, rectangle.y - 2, rectangle.width + 4, rectangle.height + 4));
            this.decoration.setAttribute(FigureAttributeConstant.getConstant((String)"FrameColor"), (Object)color);
            this.decoration.setAttribute(FigureAttributeConstant.getConstant((String)"FillColor"), (Object)ColorMap.color((String)"None"));
            this.add(this.decoration);
            this.sendToBack(this.decoration);
        }
    }

    public Color getDecoration() {
        if (this.decoration == null) {
            return null;
        }
        return (Color)this.decoration.getAttribute(FigureAttributeConstant.getConstant((String)"FrameColor"));
    }

    public void onCreateConnection(Model model, ModelConnectionElement modelConnectionElement) {
    }

    public void onSetConnectionStart(ModelConnectionElement modelConnectionElement) {
    }

    public void onSetConnectionEnd(ModelConnectionElement modelConnectionElement) {
    }

    public void onSetConnectionPoints(ModelConnectionElement modelConnectionElement) {
    }

    public void onSetAttribute(ModelElement modelElement, ModelPrimitiveAttribute modelPrimitiveAttribute) {
    }

    public void bringToFront() {
        ModelFigure modelFigure;
        this.drawing.bringToFront((Figure)this);
        for (int i = 0; i < this.element.getChildCount(); ++i) {
            modelFigure = this.getDrawing().getElementFigure(this.element.getChild(i));
            if (modelFigure == null) continue;
            modelFigure.bringToFront();
        }
        FigureEnumeration figureEnumeration = this.getDependendFigures();
        while (figureEnumeration.hasNextFigure()) {
            modelFigure = figureEnumeration.nextFigure();
            if (!(modelFigure instanceof ModelConnection)) continue;
            ((ModelConnection)((Object)modelFigure)).bringToFront();
        }
    }

    public void setPresentationFigure(Figure figure) {
        Color color;
        super.setPresentationFigure(figure);
        if (figure != null && this.element != null && (color = ((ModelPrimitiveAttribute)this.element.getAttribute("Color")).getColor()) != null) {
            figure.setAttribute(FigureAttributeConstant.getConstant((String)"FillColor"), (Object)color);
        }
    }

    public boolean getSizeable() {
        return this.sizeable;
    }

    public void setSizeable(boolean bl) {
        this.sizeable = bl;
    }

    public boolean getMoveable() {
        return this.moveable;
    }

    public void setMoveable(boolean bl) {
        this.moveable = bl;
    }

    public Color getLabelColor() {
        return this.labelFigure == null ? null : (Color)this.labelFigure.getAttribute(FigureAttributeConstant.TEXT_COLOR);
    }

    public void setLabelColor(Color color) {
        if (this.labelFigure != null) {
            this.labelFigure.setAttribute(FigureAttributeConstant.TEXT_COLOR, (Object)Color.white);
        }
    }

    public void onSetDirty() {
    }

    public TextFigure getLabelFigure() {
        return this.labelFigure;
    }
}

