/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.drawing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.io.Serializable;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.PointConstrainer;
import org.jhotdraw.standard.CompositeFigure;
import org.jhotdraw.standard.GridConstrainer;
import org.jhotdraw.standard.StandardDrawing;
import org.jhotdraw.standard.StandardDrawingView;
import org.musoft.limo.application.Application;
import org.musoft.limo.util.LogFile;

public class ModelDrawingView
extends StandardDrawingView {
    private boolean hasGrid;
    private Application parent;
    private KeyListener myKeyListener;
    private boolean selectOnly;
    private Dimension offset;

    public ModelDrawingView(Application application) {
        this(application, 250, 250);
    }

    public ModelDrawingView(Application application, int n, int n2) {
        super((DrawingEditor)application, 1500, 1500);
        this.parent = application;
        this.offset = new Dimension(n, n2);
    }

    protected KeyListener createKeyListener() {
        this.myKeyListener = super.createKeyListener();
        return this.myKeyListener;
    }

    public boolean isSelectOnly() {
        return this.selectOnly;
    }

    public void setSelectOnly(boolean bl) {
        if (bl != this.selectOnly) {
            this.selectOnly = bl;
            if (this.selectOnly) {
                this.removeKeyListener(this.myKeyListener);
            } else {
                this.addKeyListener(this.myKeyListener);
            }
        }
    }

    public Color getBackground() {
        return Color.white;
    }

    protected void handleMouseEventException(Throwable throwable) {
        LogFile.log(throwable);
    }

    public void drawBackground(Graphics graphics) {
        Graphics2D graphics2D;
        Serializable serializable;
        super.drawBackground(graphics);
        if (graphics instanceof Graphics2D && (serializable = (graphics2D = (Graphics2D)graphics).getTransform()) != null && (serializable.getType() & 6) != 0) {
            return;
        }
        if (this.getConstrainer() instanceof GridConstrainer) {
            graphics2D = (GridConstrainer)this.getConstrainer();
            serializable = graphics.getColor();
            graphics.setColor(new Color(192, 192, 192));
            Rectangle rectangle = graphics.getClipBounds();
            int n = graphics2D.getStepX();
            int n2 = graphics2D.getStepY();
            if (n > 1 && n2 > 1) {
                for (int i = n * (rectangle.x / n); i < rectangle.x + rectangle.width; i += n) {
                    for (int j = n2 * (rectangle.y / n2); j < rectangle.y + rectangle.height; j += n2) {
                        graphics.drawLine(i, j, i, j);
                    }
                }
            }
            graphics.setColor((Color)serializable);
        }
    }

    public void setConstrainer(PointConstrainer pointConstrainer) {
        super.setConstrainer(pointConstrainer);
        this.hasGrid = pointConstrainer instanceof GridConstrainer;
        this.repaint();
    }

    public boolean hasGrid() {
        return this.hasGrid;
    }

    private Rectangle getFigureBounds(Figure figure) {
        CompositeFigure compositeFigure;
        Rectangle rectangle = figure.displayBox();
        if (figure instanceof CompositeFigure && !(compositeFigure = (CompositeFigure)figure).isEmpty()) {
            FigureEnumeration figureEnumeration = compositeFigure.figures();
            while (figureEnumeration.hasNextFigure()) {
                rectangle.add(this.getFigureBounds(figureEnumeration.nextFigure()));
            }
        }
        return rectangle;
    }

    public Rectangle getDrawingBounds() {
        return this.getFigureBounds((Figure)((StandardDrawing)this.drawing()));
    }

    public void setDrawing(Drawing drawing) {
        super.setDrawing(drawing);
        if (this.drawing() != null) {
            this.checkSize(this.parent.getMainPane().getViewableSize());
        }
    }

    public void checkSize(Dimension dimension) {
        Dimension dimension2 = this.getDrawingSize();
        if (this.offset.width != 0 && this.offset.height != 0) {
            dimension2.width = this.offset.width * (dimension2.width + this.offset.width - 1) / this.offset.width;
            dimension2.height = this.offset.height * (dimension2.height + this.offset.height - 1) / this.offset.height;
        }
        dimension2.width = dimension2.width > dimension.width ? dimension2.width : dimension.width;
        dimension2.height = dimension2.height > dimension.height ? dimension2.height : dimension.height;
        this.setPreferredSize(dimension2);
        this.setMinimumSize(dimension2);
        this.setMaximumSize(dimension2);
        this.setSize(dimension2);
    }
}

