/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.drawing;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Vector;
import org.jhotdraw.figures.TextFigure;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.DragTracker;
import org.jhotdraw.standard.FigureEnumerator;
import org.musoft.limo.drawing.ModelConnection;
import org.musoft.limo.drawing.ModelDrawing;
import org.musoft.limo.drawing.ModelFigure;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelFigureElement;

public class ModelDragTracker
extends DragTracker {
    private ModelFigure movedFigure;
    private Vector movedElements = new Vector();
    private Rectangle movedRectangle;
    private Point originalPosition;
    private ModelFigure belowFigure;
    private boolean fullyContained;
    private boolean validMovement;

    public ModelDragTracker(DrawingEditor drawingEditor, ModelFigure modelFigure) {
        super(drawingEditor, (Figure)modelFigure);
        this.movedFigure = modelFigure;
        this.originalPosition = modelFigure.getElement().getPosition();
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDown(mouseEvent, n, n2);
        this.getUndoActivity().setAffectedFigures(this.determineAffectedFigures(this.getActiveView().selection()));
        this.movedRectangle = this.movedFigure.displayBox();
        for (int i = 0; i < this.movedElements.size(); ++i) {
            ModelFigureElement modelFigureElement = (ModelFigureElement)this.movedElements.get(i);
            this.movedRectangle = this.movedRectangle.union(modelFigureElement.getBounds());
        }
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        boolean bl;
        Point point = this.movedFigure.displayBox().getLocation();
        super.mouseDrag(mouseEvent, n, n2);
        Point point2 = this.movedFigure.displayBox().getLocation();
        this.movedRectangle.translate(point2.x - point.x, point2.y - point.y);
        ModelFigureElement modelFigureElement = this.movedFigure.getElement();
        Figure figure = this.drawing().findFigureWithout(n, n2, (Figure)this.movedFigure);
        boolean bl2 = figure != null && figure.displayBox().contains(this.movedRectangle);
        boolean bl3 = bl = figure == null && (modelFigureElement.getParent() instanceof Model || !modelFigureElement.getParent().getBounds().intersects(this.movedRectangle));
        if (figure != this.belowFigure || (bl2 || bl) != this.fullyContained) {
            if (this.belowFigure != null) {
                this.belowFigure.setDecoration(null);
                this.belowFigure = null;
            }
            boolean bl4 = this.fullyContained = bl2 || bl;
            if (figure instanceof ModelFigure) {
                this.belowFigure = (ModelFigure)figure;
                ModelFigureElement modelFigureElement2 = this.belowFigure.getElement();
                if (!this.fullyContained) {
                    this.belowFigure.setDecoration(Color.YELLOW);
                    this.validMovement = false;
                } else if (modelFigureElement2 == modelFigureElement.getParent()) {
                    this.belowFigure.setDecoration(Color.GREEN);
                    this.validMovement = true;
                } else if (modelFigureElement.canSetParent(modelFigureElement2) && modelFigureElement2.canAddChild(modelFigureElement)) {
                    if (this.movedElements.size() <= 1) {
                        this.belowFigure.setDecoration(Color.GREEN);
                        this.validMovement = true;
                    } else {
                        this.belowFigure.setDecoration(Color.YELLOW);
                        this.validMovement = false;
                    }
                } else {
                    this.belowFigure.setDecoration(Color.RED);
                    this.validMovement = false;
                }
            } else {
                this.belowFigure = null;
                Model model = ((ModelDrawing)this.drawing()).getModel();
                this.validMovement = model == modelFigureElement.getParent() ? true : (modelFigureElement.canSetParent(model) && ((ModelFigureElement)model).canAddChild(modelFigureElement) ? this.movedElements.size() <= 1 : false);
            }
        }
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        super.mouseUp(mouseEvent, n, n2);
        ModelFigureElement modelFigureElement = this.movedFigure.getElement();
        if (this.belowFigure != null) {
            this.belowFigure.setDecoration(null);
        }
        if (!this.validMovement) {
            DragTracker.UndoActivity undoActivity = (DragTracker.UndoActivity)this.getUndoActivity();
            undoActivity.setOriginalPoint(this.originalPosition);
            undoActivity.setBackupPoint(this.movedFigure.displayBox().getLocation());
            this.getUndoActivity().undo();
            return;
        }
        if (this.belowFigure != null) {
            ModelFigureElement modelFigureElement2;
            ModelFigureElement modelFigureElement3 = modelFigureElement.getParent();
            if (modelFigureElement3 != (modelFigureElement2 = this.belowFigure.getElement())) {
                modelFigureElement.setParent(modelFigureElement2);
            }
        } else {
            Model model = ((ModelDrawing)this.drawing()).getModel();
            ModelFigureElement modelFigureElement4 = modelFigureElement.getParent();
            if (modelFigureElement4 != model) {
                modelFigureElement.setParent(model);
            }
        }
    }

    private void addModelSubTree(Vector vector, ModelFigureElement modelFigureElement) {
        if (!vector.contains(modelFigureElement)) {
            vector.add(modelFigureElement);
        }
        if (!(modelFigureElement instanceof Model)) {
            for (int i = 0; i < modelFigureElement.getChildCount(); ++i) {
                this.addModelSubTree(vector, modelFigureElement.getChild(i));
            }
        }
    }

    private FigureEnumeration determineAffectedFigures(FigureEnumeration figureEnumeration) {
        ModelFigureElement modelFigureElement;
        Object object;
        int n;
        Object object2;
        Object object3;
        Vector vector = new Vector();
        Vector<Object> vector2 = new Vector<Object>();
        Vector<ModelConnection> vector3 = new Vector<ModelConnection>();
        Vector<Object> vector4 = new Vector<Object>();
        while (figureEnumeration.hasNextFigure()) {
            object3 = figureEnumeration.nextFigure();
            if (object3 instanceof ModelFigure) {
                ModelFigureElement modelFigureElement2;
                object2 = (ModelFigure)object3;
                if (((ModelFigure)object2).getMoveable()) {
                    modelFigureElement2 = ((ModelFigure)object3).getElement();
                    this.addModelSubTree(vector, modelFigureElement2);
                    continue;
                }
                modelFigureElement2 = ((ModelFigure)object3).getElement().getParent();
                this.addModelSubTree(vector, modelFigureElement2);
                continue;
            }
            if (object3 instanceof ModelConnection) {
                vector2.add(object3);
                continue;
            }
            if (!(object3 instanceof TextFigure)) continue;
            vector4.add(object3);
        }
        object3 = (ModelDrawing)this.drawing();
        object2 = ((ModelDrawing)object3).getModel();
        for (n = 0; n < ((Model)object2).getConnectionCount(); ++n) {
            ModelConnection modelConnection;
            object = ((Model)object2).getConnection(n);
            modelFigureElement = ((ModelConnectionElement)object).getStart();
            ModelFigureElement modelFigureElement3 = ((ModelConnectionElement)object).getEnd();
            boolean bl = vector.contains(modelFigureElement);
            boolean bl2 = vector.contains(modelFigureElement3);
            if (bl && bl2 && !vector2.contains(modelConnection = ((ModelDrawing)object3).getConnectionFigure((ModelConnectionElement)object))) {
                vector2.add(modelConnection);
            }
            if (!bl && !bl2 || vector3.contains(modelConnection = ((ModelDrawing)object3).getConnectionFigure((ModelConnectionElement)object))) continue;
            vector3.add(modelConnection);
        }
        for (n = 0; n < vector3.size(); ++n) {
            object = (ModelConnection)vector3.get(n);
            modelFigureElement = ((ModelConnection)object).getLabelFigure();
            if (!vector4.contains(modelFigureElement)) continue;
            vector4.remove(modelFigureElement);
        }
        block3: for (n = vector.size() - 1; n >= 0; --n) {
            object = (ModelFigureElement)vector.get(n);
            modelFigureElement = ((ModelFigureElement)object).getParent();
            while (!(modelFigureElement instanceof Model)) {
                if (vector.contains(modelFigureElement)) {
                    vector.remove(n);
                    continue block3;
                }
                modelFigureElement = modelFigureElement.getParent();
            }
        }
        this.movedElements.addAll(vector);
        Vector<Object> vector5 = new Vector<Object>();
        for (int i = 0; i < vector.size(); ++i) {
            vector5.add(((ModelDrawing)object3).getElementFigure((ModelFigureElement)vector.get(i)));
        }
        vector5.addAll(vector2);
        vector5.addAll(vector4);
        return new FigureEnumerator(vector5);
    }
}

