/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.application;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.BevelBorder;

public class StaticJButton
extends JButton
implements MouseListener {
    private boolean isTouched;
    private boolean isActive;

    public StaticJButton(String string, ImageIcon imageIcon) {
        super(imageIcon);
        this.setContentAreaFilled(false);
        this.setBorder(null);
        this.addMouseListener(this);
        this.setName(string);
        this.setToolTipText(string);
    }

    public Dimension getMinimumSize() {
        return new Dimension(40, 40);
    }

    public Dimension getPreferredSize() {
        return new Dimension(40, 40);
    }

    public Dimension getMaximumSize() {
        return new Dimension(40, 40);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.isTouched = true;
        this.updateDecoration();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.isTouched = false;
        this.updateDecoration();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.isActive = this.isEnabled();
        this.updateDecoration();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.isActive = false;
        this.updateDecoration();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.updateDecoration();
    }

    public void updateUI() {
        super.updateUI();
        this.updateDecoration();
    }

    private void updateDecoration() {
        this.setContentAreaFilled(this.isTouched && this.isEnabled());
        if (this.isActive && this.isEnabled()) {
            this.setBorder(new BevelBorder(1));
        } else if (this.isTouched && this.isEnabled()) {
            this.setBorder(new BevelBorder(0));
        } else {
            this.setBorder(null);
        }
    }
}

